#define START_ADDRESS 0x020;
#define MISO_PIN PTE3

/**************Defining Counter Limits**************/

#define THRS 3
#define STATE_ERR_THRS 3
#define PHY_OFF_EXEC_TIME 300
#define PHY_ON_EXEC_TIME 300
#define PHY_TX_EXEC_TIME 600
/******DEFINING COMMANDS*********/

#define CMD_HW_RESET 0xC8
#define CMD_PHY_ON 0xB1
#define CMD_PHY_OFF 0xB0
#define CMD_PHY_TX 0xB5
#define CMD_CONFIG_DEV 0xBB

/*****FUNCTION Declaration********************/
bool assrt_phy_off( int, int, int);
bool assrt_phy_on( int,int,int);
bool assrt_phy_tx(int,int,int);
/****************************/
SPI adf(PTE1, PTE3, PTE2); //MOSI, MISO, CLOCK
//SPI adf(PTA16, PTA17, PTA15); //MOSI, MISO, CLOCK
//DigitalOut CS(D10);
DigitalOut CS(PTA15);
DigitalOut led2(LED_RED);
//InterruptIn IRQ(D8);
InterruptIn IRQ(PTA14);
Ticker ticker;
unsigned char d = 0,c=1; 
unsigned char k = 0;
unsigned char bbram_buffer[66]={0x19,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0xF4,0xC2,0x10,0xC0,0x00,0x30,0x31,0x07,0x00,0x01,0x00,0x7F,0x00,0x0B,0x37,0x00,0x00,0x40,0x0C,0x00,0x05,0x00,0x00,0x18,0x12,0x34,0x56,0x10,0x10,0xC4,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00};

unsigned char status =0;
unsigned int cmd_err_cnt=0;
unsigned int state_err_cnt=0;
unsigned int miso_err_cnt=0;
unsigned int hw_reset_err_cnt=0;

bool bcn_flag=0;
bool bbram_flag=0;

/*******ADDITIONAL STUFF****************/    
unsigned char check_status(void){
    unsigned char stat=0;
    CS=0;
    adf.write(0xFF);
    stat = adf.write(0xFF);
    CS=1;
    return stat;
    }
/*****************************************/
bool assrt_phy_off(int cmd_err_cnt,int spi_err_cnt,int state_err_cnt){
    status=check_status();
        if(status==0xB1){
            return 0;
        }
        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){
            return 1;//You need to Reset the hardware
        }
        else if(state_err_cnt>STATE_ERR_THRS){
            return 1;//Again reset the hardware
        }
        else if((status&0xA0)==0xA0){  //If Status' first three bit ore 0b1X1 =>SPI ready, Dont care interrupt and CMD Ready.
            CS=0;
            adf.write(CMD_PHY_OFF);        //CMD_PHY_OFF=0xB0
            CS=1;
            wait_us(PHY_OFF_EXEC_TIME);// Typical = 24us  We are giving 300us 
            return assrt_phy_off(cmd_err_cnt,spi_err_cnt,state_err_cnt+1);
        }
        else if(status&0x80==0x00){
            wait_ms(5);
            //Error: SPI=0 Not ready CMD= Dont care
            return assrt_phy_off(cmd_err_cnt,spi_err_cnt+1,state_err_cnt);
        }
        else {//if(status&0xA0==0x80){
            wait_ms(1);
            //Error: Command Not ready SPI Ready cmd_err_cnt is a global variable
            return assrt_phy_off(cmd_err_cnt+1,spi_err_cnt,state_err_cnt);
        }
}
/*****************************/
bool assrt_phy_on(int cmd_err_cnt,int spi_err_cnt,int state_err_cnt){
    status=check_status();
        if((status&0x1F)==0x12){
            return 0;
        }
        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){
            return 1;//You need to Reset the hardware
        }
        else if(state_err_cnt>STATE_ERR_THRS){
            return 1;//Again reset the hardware
        }
        else if((status&0xA0)==0xA0){  //If Status' first three bit ore 0b1X1 =>SPI ready, Dont care interrupt and CMD Ready.
            CS=0;
            adf.write(0xB1);        //CMD_PHY_OFF
            CS=1;
            wait_us(PHY_ON_EXEC_TIME);// Typical = 24us  We are giving 300us 
            return assrt_phy_on(cmd_err_cnt,spi_err_cnt,state_err_cnt+1);
        }
        else if(status&0x80==0x00){
            wait_ms(5);
            //Error: SPI=0 Not ready CMD= Dont care
            return assrt_phy_on(cmd_err_cnt,spi_err_cnt+1,state_err_cnt);
        }
        else if(status&0xA0==0x80){
            wait_ms(1);
            //Error: Command Not ready SPI Ready cmd_err_cnt is a global variable
            return assrt_phy_on(cmd_err_cnt+1,spi_err_cnt,state_err_cnt);
        }
}
 /*****************************/
 bool assrt_phy_tx(int cmd_err_cnt,int spi_err_cnt,int state_err_cnt){
    status=check_status();
        if((status & 0x1F) == 0x14){
            return 0;
        }
        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){
            return 1;//You need to Reset the hardware
        }
        else if(state_err_cnt>STATE_ERR_THRS){
            return 1;//Again reset the hardware
        }
        else if((status&0xA0)==0xA0){  //If Status' first three bit ore 0b1X1 =>SPI ready, Dont care interrupt and CMD Ready.
            CS=0;
            adf.write(0xB1);        //CMD_PHY_OFF
            CS=1;
            wait_us(PHY_TX_EXEC_TIME);// Typical = 24us  We are giving 300us 
            return assrt_phy_tx(cmd_err_cnt,spi_err_cnt,state_err_cnt+1);
        }
        else if(status&0x80==0x00){
            wait_ms(1);
            //Error: SPI=0 Not ready CMD= Dont care
            return assrt_phy_tx(cmd_err_cnt,spi_err_cnt+1,state_err_cnt);
        }
        else if(status&0xA0==0x80){
            wait_us(50);
            //Error: Command Not ready SPI Ready cmd_err_cnt is a global variable
            return assrt_phy_tx(cmd_err_cnt+1,spi_err_cnt,state_err_cnt);
        }
}

/***************************/
bool hardware_reset(int bcn_call){
    if (bcn_call>20){//Worst Case 20seconds will be lost !
        return 1;
    }
    int count=0;
    CS=0;
    adf.write(CMD_HW_RESET);
    CS=1;
    wait_ms(2);// Typically 1 ms
    while(count<10 && miso_err_cnt<10){      
        if(MISO_PIN){
            
            if(!assrt_phy_off(0,0,0)){
                break;
            }
            count++;
        }
        else{
            wait_us(50);
            miso_err_cnt++;
        }
    }
    if(count==10 ||miso_err_cnt==10){
        return hardware_reset(bcn_call+1);  
    }
    else
        return 0;
    
}
/**********END OF STATUS CHECKING FUNCTIONS******************/

void bbram_write()
{   
    CS=0;
    adf.write(0xB0);//PHY_OFF
    wait_us(300);
    CS=1;
    
    // Write bbram
    CS=0;
     for(int i=0;i<66;i++){
        adf.write(bbram_buffer[i]);    
    }
    CS=1;
//    wait(1);
    
}




/******************************************************************************************/

void initiate(void){
    
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);

    CS=0;
    adf.write(0x08);    // TRANSMIT_DATA LENGTH
    adf.write(0x14);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);
    CS=0;
    adf.write(0x08);        // TRANSMIT_DATA LENGTH
    adf.write(0x15);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);
    
    CS=0;
    adf.write(0x09);
    adf.write(0x24);   // TX_BASE ADDRESS   0x20(starting Tx Byte)
    adf.write(0x20);
    CS=1;
//    wait_ms(2);
    
    CS=0;
    adf.write(0x09);
    adf.write(0x37);// BUFFER SIZE 0xE0=224 Bytes 0x137 is adress of buffer size
    adf.write(0xE0);
    CS=1;
//    wait_ms(2);
    
    CS=0;
    adf.write(0x09);
    adf.write(0x36);//BB_Tx_Buffer Signal when Buffer is half filled
    adf.write(0x70);//0x70 = 112 >> When Half buffer interrupt is given
    CS=1;
//    wait_ms(2);
    
    
    CS=0;
    adf.write(0x09);
    adf.write(0x39);//BB_Tx_Buffer Signal when Buffer is half filled
    adf.write(0x10);//0x70 = 112 >> When Half buffer interrupt is given
    CS=1;
//    wait_ms(2);    
    }

 

void write_data(void){
   
//    wait_ms(0);
    CS=0;
    adf.write(0x0B);//IRQ_SOURCE_Random write //To read CMD = 2B 36 FF FF
    adf.write(0x36);//Address : 0x336
    adf.write(0xFF);//Put Low
    CS=1;
//    wait_us(80);
    CS=0;
    static bool first_2_time = true;
    k=0;
 
    if(!first_2_time){
               if(d==1 && snd_tm.last_buffer==false){
//                cout<<"3"<<ENDL;
                adf.write(0x18);
                adf.write(0x20);
                while(k<112)
                {
                adf.write(snd_tm.transmit[k]);  
                k++;
                }
                d=2;
                }
                   
    
            else  if(d==2 && snd_tm.last_buffer==false){     
//                    cout<<"4"<<ENDL;
                    adf.write(0x18);
                    adf.write(0x90);
                    while(k<112)
                    {
                        adf.write(snd_tm.transmit[k]);  
                        k++;
                    }
                    d=1;   
         
              }   
     
        
    }
 
    if(first_2_time){
        switch(c){
        case 1:  
//           cout<<"1"<<ENDL;
                    adf.write(0x18);
                    adf.write(0x20);
                    while(k<112)
                    {
                    adf.write(snd_tm.transmit[k]);  
                    k++;
                    }
                    c++;
                    break;   
        
        case 2:    
//         cout<<"2"<<ENDL;
                        adf.write(0x18);
                        adf.write(0x90);
                        while(k<112)
                        {
                            adf.write(snd_tm.transmit[k]);  
                            k++;
                        }
                        c++;
                        d=1;
                        first_2_time = false;
                     break;   
                     }   
            
     }
                 
     
            
      if(snd_tm.last_buffer){
                CS=0;
                adf.write(0x18);
                adf.write(0x20);
               
                while(k<112){
                    adf.write(snd_tm.transmit[k]);  
                    k++;
                }
                CS=1;
//            //        
                snd_tm.transmission_done=true;
                //ticker.detach();
//                wait_ms(60);
//                CS=0;
//                 adf.write(0xB1);
//                CS=1;
//                snd_tm.transmission_done=true;
        }
                          
     CS=1;
//     wait_us(1);
    }
    


void check()
    {   
     
     if(IRQ){
         if(snd_tm.transmission_done==false){
             write_data();
             snd_tm.transmit_data();
         }
         else{
                ticker.detach();
                CS=0;
                 adf.write(0xB1);
                CS=1;
//                snd_tm.transmission_done=true;
             }
         }
     }

void send_data(void){
        
    CS=0;
    adf.write(0xBB);
    CS=1;
//    wait_us(300); 
    
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2); 
    snd_tm.transmit_data();
//    wait_ms(1);
    write_data();
//    wait_ms(1);
    snd_tm.transmit_data();
//    wait_ms(1);
    write_data();
    snd_tm.transmit_data();
//    snd_tm.transmit_data();
//    write_data();
//  wait_ms(2);  
    CS=0;
    adf.write(0xB1);
    CS=1;
    wait_us(300); 
    
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);  
    
    CS=0;
    adf.write(0xB5);
    CS=1;
    printf("b5 gien\n");
    wait_us(300);  
//    int b5=t.read_us();
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);
    
    ticker.attach_us(&check,32000);
    }
    
    void adf_callme(){
        adf.format(8,0);
        adf.frequency(1000000);
        printf("inside callme");
        bool state_0=0;
        adf.write(CMD_PHY_OFF); //0xB0
        while(hw_reset_err_cnt<2){
        
            if(!assrt_phy_off(0,0,0)){  //assrt_phy_off () returns 0 if state is PHY_OFF , returns 1 if couldn't go to PHY_OFF
                bbram_write();
                bbram_flag=1;
                break;
            }
            else{
                hardware_reset(0);  // Asserts Hardware for 20sec(20times). PHY_OFF for 20,000 times
                hw_reset_err_cnt++;
            }
        }
        state_0=assrt_phy_off(0,0,0);// We actually do not need this but make sure "we do not need this"
        if(!bbram_flag){
        //Switch to beacon
            bcn_flag=1;
         }
    
//        bbram_write();
        initiate();
        send_data();
    
        while(!snd_tm.transmission_done)
        {
                led2=!led2;
                wait(.1);
        }
    }