    void interleave( unsigned char *input, unsigned char *output ){
    
    unsigned int outState = 0;
    unsigned int outByte = 0;
    
    for( unsigned int i = 0 ; i < 36 ; ++i ){
        for(unsigned int j = 0 ; j < 30 ; ++j){
            unsigned int x = j*36+i;
            unsigned char tempBit = ((input[x >> 3]) >> (7-(x % 8))) & 1;
            switch(outState){
                case 0:
                    outState = 1;
                    output[outByte] = tempBit << 7;
                    break;
                case 1:
                    outState = 2;
                    output[outByte] += tempBit << 6;
                    break;
                case 2:
                    outState = 3;
                    output[outByte] += tempBit << 5;
                    break;
                case 3:
                    outState = 4;
                    output[outByte] += tempBit << 4;
                    break;
                case 4:
                    outState = 5;
                    output[outByte] += tempBit << 3;
                    break;
                case 5:
                    outState = 6;
                    output[outByte] += tempBit << 2;
                    break;
                case 6:
                    outState = 7;
                    output[outByte] += tempBit << 1;
                    break;
                case 7:
                    outState = 0;
                    output[outByte] += tempBit;
                    ++outByte;
                    break;
            }
        }
        for(unsigned int j = 0 ; j < 2 ; ++j){
            switch(outState){
                case 0:
                    output[outByte] = 0;
                    outState = 1;
                    break;
                case 1:
                    outState = 2;
                    break;
                case 2:
                    outState = 3;
                    break;
                case 3:
                    outState = 4;
                    break;
                case 4:
                    outState = 5;
                    break;
                case 5:
                    outState = 6;
                    break;
                case 6:
                    outState = 7;
                    break;
                case 7:
                    outState = 0;
                    ++outByte;
                    break;
            }
        }
    }
}