

class Convolution{
    
private:
    typedef struct ConvNode{
        //next state
        //format : 8 bits mapped as [1]xxxx [0]xxxx
        unsigned char nextState;
        
        //output
        // format : 8 bits mapped as 
        // **** xxxx{2} [1]-[0]   {1} [1]-[0]      i.e.   ****xxxx
        // x = data, * = junk
        unsigned char output;
    }ConvNode;

    ConvNode convStateList[16]; 
    
public:
    /*
    @brief:     Constructor : Initialise all the variables
    @param:     none
    @return:    none
    */
    Convolution(){
        
        convStateList[0].nextState = 0x10;
        convStateList[1].nextState = 0x32;
        convStateList[2].nextState = 0x54;
        convStateList[3].nextState = 0x76;
        convStateList[4].nextState = 0x98;
        convStateList[5].nextState = 0xBA;
        convStateList[6].nextState = 0xDC;
        convStateList[7].nextState = 0xFE;
        convStateList[8].nextState = 0x10;
        convStateList[9].nextState = 0x32;
        convStateList[10].nextState = 0x54;
        convStateList[11].nextState = 0x76;
        convStateList[12].nextState = 0x98;
        convStateList[13].nextState = 0xBA;
        convStateList[14].nextState = 0xDC;
        convStateList[15].nextState = 0xFE;
        
        convStateList[0].output = 0x0A;
        convStateList[1].output = 0x06;
        convStateList[2].output = 0x06;
        convStateList[3].output = 0x0A;
        convStateList[4].output = 0x09;
        convStateList[5].output = 0x05;
        convStateList[6].output = 0x05;
        convStateList[7].output = 0x09;
        convStateList[8].output = 0x05;
        convStateList[9].output = 0x09;
        convStateList[10].output = 0x09;
        convStateList[11].output = 0x05;
        convStateList[12].output = 0x06;
        convStateList[13].output = 0x0A;
        convStateList[14].output = 0x0A;
        convStateList[15].output = 0x06;
    }
    
        
    /*
    @brief:     convolution encode the input bytes : in sync with =>   (1-TM-Frame -> 2-T-Frame)
    @param:     inPtr : pointer to input unsigned char array
                inLength : length in bytes of input array
                outPtr : pointer to the output bytes, define it outside the function
                outLength : length of output array in bytes [call by reference, edited inside the function]
    @return:    none
    */
    void convolutionEncode(unsigned char *input, unsigned char *output){
        
//      cout << "inside convolution" << endl;
        
        unsigned int convState = 0;
        
        int inBit = 7;
        unsigned int inByte = 0;
        
        unsigned int outState = 0;
        unsigned int outByte = 0;
        
        for(unsigned int j = 0 ; j < 536 ; ++j){
//          printf("j = %u, inByte = %u\n", j, inByte);
            // read a new bit from input stream
//          cout << "inByte " <<inByte;
            unsigned char tempBit = (input[inByte] >> inBit) & 1;
            --inBit;
            
            // convolute and write output
            switch(outState){
                case 0:
                    outState = 2;
                    output[outByte] = ( (convStateList[convState].output >> tempBit) & 1 ) << 7;
                    output[outByte] += ( (convStateList[convState].output >> (tempBit + 2)) & 1 ) << 6;
                    break;
                case 2:
                    outState = 4;
                    output[outByte] += ( (convStateList[convState].output >> tempBit) & 1 ) << 5;
                    output[outByte] += ( (convStateList[convState].output >> (tempBit + 2)) & 1 ) << 4;
                    break;
                case 4:
                    outState = 6;
                    output[outByte] += ( (convStateList[convState].output >> tempBit) & 1 ) << 3;
                    output[outByte] += ( (convStateList[convState].output >> (tempBit + 2)) & 1 ) << 2;
                    break;
                case 6:
                    outState = 0;
                    output[outByte] += ( (convStateList[convState].output >> tempBit) & 1 ) << 1;
                    output[outByte] += ( (convStateList[convState].output >> (tempBit + 2)) & 1 );
                    ++outByte;
                    output[outByte] = 0x00;
                    break;
            }
            
            // next state transition
            switch(tempBit){
                case 0:
                    convState = (convStateList[convState].nextState) & 0xF;
                    break;
                case 1:
                    convState = (convStateList[convState].nextState >> 4) & 0xF;
                    break;
            }
            
            if(inBit == -1){
//              printf("in byte = %u\n", inByte);
                ++inByte;
                inBit = 7;
            }
            
        }
        
//      printf("normal iteration complete, outByte = %u\n", outByte);

        for(unsigned int j = 0 ; j < 4 ; ++j){
//          printf("j = %u\n, outByte = %u\n", j, outByte);
            // append zero at the end
            switch(outState){
                case 0:
                    outState = 2;
                    output[outByte] = ( (convStateList[convState].output) & 1 ) << 7;
                    output[outByte] += ( (convStateList[convState].output >> 2) & 1 ) << 6;
                    break;
                case 2:
                    outState = 4;
                    output[outByte] += ( (convStateList[convState].output) & 1 ) << 5;
                    output[outByte] += ( (convStateList[convState].output >> 2) & 1 ) << 4;
                    break;
                case 4:
                    outState = 6;
                    output[outByte] += ( (convStateList[convState].output ) & 1 ) << 3;
                    output[outByte] += ( (convStateList[convState].output >> 2) & 1 ) << 2;
                    break;
                case 6:
                    outState = 0;
                    output[outByte] += ( (convStateList[convState].output ) & 1 ) << 1;
                    output[outByte] += ( (convStateList[convState].output >> 2) & 1 );
                    ++outByte;
//                  printf("outByte @ end of switch = %u\n", outByte);
                    break;
            }
            // next state transition
            convState = (convStateList[convState].nextState) & 0xF;
        }
//      printf("complete\n");
    }
    
};
