int disk_write(const uint8_t *, uint64_t);
uint64_t  RTC_TIME;                                    //need to  be changed to uint_64


namespace Science_TMframe {
    
    #define OUTLENGTH 360                                           //length of the output frame after convolution
    #define SDcard_block 512                                        //block size of the sd card
    
    Convolution ConvObj;                                            //object which stores the frame after convolution
    bool fresh[3] = {true,true,true};                               // True only for the first time                                                                 
    unsigned char frames[3][134] = {0};                             // "frame" stores the address of the current frame...."first_frame_address" stores the address of the first node made.
    unsigned int FCN[4] = {0};                                      //frame count number
    unsigned int data_starting_point[3] = {8,5,10};             
    unsigned int max_data[3] = {124,127,122};                       //number of bytes in each frame excluding TMID,FCN,first_header_point,crc
    unsigned char TM_convoluted_data[270] = {0};                    //270 bytes is the size after convolution of 1072 bits
    unsigned char complete_frame[SDcard_block] = {0};
    uint64_t  SDC_address = 10;
    bool SCH_FCCH_FLAG = true;
    
    
    void add_SCH_FCCH(){
        int i = 0;
        complete_frame[0] = 0x0a;
        complete_frame[1] = 0x3f;;
        complete_frame[2] = 0x46;
        complete_frame[3] = 0xb4;
        complete_frame[4] = 0x00;
        
        for(i = 149 ; i < 159 ; i ++){
            complete_frame[i] = 0 ; 
        }
        
        complete_frame[159] = 0x0a;
        complete_frame[160] = 0x3f;;
        complete_frame[161] = 0x46;
        complete_frame[162] = 0xb4;
        complete_frame[163] = 0x00;
        
        for(i = 308 ; i < 318 ; i ++){
            complete_frame[i] = 0 ; 
        }
        
    }
    
    void making_frameHeader(unsigned char  TMID){
    
        unsigned char frame_type_identifier = 0;                                                        // not conform about the values , yet to be done    
        frames[TMID][0] = (frame_type_identifier<<7) + ( (TMID + 1)<<3 ) + ( (FCN[TMID]>>24) & 0x7 );   //frame number should be less than 2^23 since 23 bits are assigned for that
        frames[TMID][1] = ((FCN[TMID]>>16) & 0xff );
        frames[TMID][2] = ( (FCN[TMID]>>8 )& 0xff );
        frames[TMID][3] = ( FCN[TMID] & 0xff      );                                                        // first bit for (frame identifier), next 4 for (TMID) and next 27 for FCN
        
        if(TMID == 0){
            frames[TMID][5] =( (RTC_TIME>>29) & 0xff );
            frames[TMID][6] =( (RTC_TIME>>21) & 0xff ); 
            frames[TMID][7] =( (RTC_TIME>>13) & 0xff );
            
        }else if(TMID == 2){
            frames[TMID][5] =( (RTC_TIME>>32) & 0xff );
            frames[TMID][6] =( (RTC_TIME>>24) & 0xff ); 
            frames[TMID][7] =( (RTC_TIME>>16) & 0xff );
            frames[TMID][8] =( (RTC_TIME>>8 ) & 0xff );
            frames[TMID][9] =( (RTC_TIME    ) & 0xff );
        }
        
    }

    void convolution (unsigned char * ptr){
    
        ConvObj.convolutionEncode(ptr , TM_convoluted_data);
        ConvObj.convolutionEncode(ptr + 67, TM_convoluted_data + 135);

    }

    /*
        @brief : take the address of array of LCR or HCR and stores it into a frame
        @parameters: type->L or H , deprnding on wheather it is LCR or HCR respectively
        @return: nothing
    */

//  type 2 yet to be done
    void making_frame(unsigned char TMID ,unsigned char type, unsigned char* pointer){
        
        TMID--;                                          //TMID goes from 1 to 3 , convinient to ue from 0 to 2
        static int frame_space_number[3] = {0};          //this variable represents the register number of the frame in which LCR or HCR data to be written not including header
        int  packet_len = 0;
        int copy_count = 0 ;
        
        switch(int(TMID)){
            case 0:                                     //SCP
                if(type == 'L'){                        //below threshold
                    packet_len = 22;   
                }
                else if(type == 'H'){                   //above threshold
                    packet_len = 26;
                }
                break;
            
            case 1:                                     //SFP above threshold
                packet_len = 35;
                break;
        
            case 2:                                     //SFP  below threshold
                packet_len = 23;
                break;  
        }
        
        if(SCH_FCCH_FLAG){
            add_SCH_FCCH();
            SCH_FCCH_FLAG = false;
        }

        if(fresh[TMID]){
            //welcome to first frame
            making_frameHeader(TMID);
            frames[TMID][4] = 0;
            fresh[TMID] = false;
        }
    
    
        while(copy_count < packet_len){                                                                  // 22 bytes is the size of the LCR
            frames[TMID][ frame_space_number[TMID] + data_starting_point[TMID] ]= *(pointer + copy_count);
            frame_space_number[TMID]++;                                          
            copy_count++;
            if( frame_space_number[TMID] == max_data[TMID] ){                                //frame space number can go from 0 to 126 as data is written from 0+5 to 126+5
                FCN[TMID]++;
                // convolution and save frame in the sd card
                
                // copying crc in 132 and 133
                int temp_crc;
                temp_crc = CRC::crc16_gen(frames[TMID],132);
                frames[TMID][132] = temp_crc>>8;
                frames[TMID][133] = temp_crc & 0xff;                
                
                //convolution and interleaving  
                convolution(frames[TMID]);
                interleave(TM_convoluted_data , complete_frame + 5);
                interleave(TM_convoluted_data+ 135,complete_frame + 164);
                
                disk_write(complete_frame , SDC_address);
                SDC_address++;
               
            
                
                //now save to the sd card TM_convoluted_data
//              std::bitset<8> b;
//              printf("\nthis is frame %d\n",TMID);                                        //for printing frame 
//                  for(int j =0; j<134;j++){
//                  printf(" %d",frames[TMID][j]);
////                    b =  frames[TMID][j];
////                    cout<<b;
//                  }
                
                frame_space_number[TMID] = 0;
                making_frameHeader(TMID);
                frames[TMID][4]=packet_len - copy_count;
                //write time  here also
                continue;
            }       
        }
    
//      printf("\nthis is frame %d\n",TMID);                                              //for printing frame 
//      for(int j =0; j<134;j++){
//          printf(" %d",frames[TMID][j]);
//      }

    }   


}





namespace Science_Data_Compression{

    # define PACKET_SEQUENCE_COUNT 1                         //1 byte
    # define NUM_PROTON_BIN 17                               //2 byte each
    # define NUM_ELECTRON_BIN 14                             //2 byte each 
    # define VETO 1                                          //2 byte
    # define FASTCHAIN 2                                     //4 byte each
    #define RAW_PACKET_LENGTH 73                             //73 bytes

//  #define PACKET_SEQ_COUNT 1
//  #define PROTON_BIN_SIZE 2
//  #define ELECTRON_BIN_SIZE 2
//  #define VETO 2
//  #define FAST_CHAIN 4
    
    
    /*
    @brief:     read one uint16_t equivalent of first two chars from the stream. short int because 16 bits
    @param:     pointer to the start of the short int
    @return:    uint16_t 
    */
    
    
    unsigned int read_2byte(unsigned char* ptr){
        unsigned int output = (unsigned int) *(ptr+1);
        output += ( (unsigned int)(*ptr) ) << 8;
        return output;
    }
    
    /*
    @brief:     read one int equivalent of first four chars from the stream.  int because 32 bits
    @param:     pointer to the start of the short int
    @return:    unsigned int  
    */

    unsigned int read_4byte(unsigned char* ptr){
        unsigned int output = (unsigned int) *(ptr+3);
        output += (unsigned int)*(ptr+2)<<8;
        output += (unsigned int)*(ptr+1)<<16;
        output += (unsigned int)*(ptr)<<24;
        return output;
    }

    unsigned int SFP_thresholds[35]={0  ,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100};//threashold values 
    unsigned int SCP_thresholds[35]={0  ,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,500,0  ,0  ,0  };
    unsigned int SFP_bin[35];
    unsigned int SCP_bin[35]={0};
    unsigned char SFP_outputBT[23];                         //BT = below threshold
    unsigned char SFP_outputAT[35];
    unsigned char SCP_outputLCR[22];
    unsigned char SCP_outputHCR[26];

    
//**********************************************************************************************************************************************************************
    //lots of compression functions are listed below

    
    unsigned char SFP_compress4_BT(unsigned int input){                                 //for veto
        int de_4 = 0;
        unsigned char output;
        
        if(input<= 3){
        //  DE = 0;
            output = 0x0;
            de_4 = 0;
        }
        else if(input <= 12){
        //  DE = 01;
            output = 0x1;
            de_4 = 2;   
        }
        else if(input <= 48){
        //  DE = 10
            output = 0x2;
            de_4 = 4;   
        }
        else {
        //  DE = 11
            output = 0x3;
            de_4 = 6;
        }
        
        unsigned short int temp = input >> de_4;
        output += (temp ) << 2;
        return output;
    }
    
    
    unsigned char SFP_compress5_BT(unsigned int input){
        int de_4 = 0;                                   //number by which bin value need to be shifted
        unsigned char output;
        
        if(input <= 15){
//            D = 0 [0]
            output = 0x0;
            de_4 = 0;
        }
        else if(input <= 60){
//            D = 1
            output = 0x1;
            de_4 = 2;
        }
        
        unsigned short int temp = input >> de_4;
        output += (temp ) << 1;
        
        return output;      
    };
    
    
    unsigned char SFP_compress6_BT(unsigned int input){
        int de_4 = 0;;
        unsigned char output;
        
        if(input <= 31){
//          E = 0 [0]
            output = 0x0;
            de_4 = 0;
        }
        else if(input <= 124){
//            E = 1
            output = 0x1;
            de_4 = 2;
        }
         
        
        unsigned short int temp = input >> de_4;
        output += (temp ) << 1;
        
        return output;
    };
    
    unsigned char SFP_compress7_AT(unsigned int input){
        int de_4  = 0;
        unsigned char output;
        
        if(input <= 31){
//            DE = 00 [0]
            output = 0x0;
            de_4 = 0;
        }
        else if(input <= 124){
//            DE = 01 [1]
            output = 0x1;
            de_4 = 2;
        }
        
        else if(input <= 496){
//            DE = 10 [2]
            output = 0x2;
            de_4 = 4;
        }
        
        else if(input <= 1984){
//           DE = 11 [3]
            output = 0x3;
            de_4 = 6;
        }
        
        unsigned short int temp = input >> de_4;
        output += (temp ) << 2;
        
        return output;
        
    };
    
    
    unsigned char SFP_compress8_AT(unsigned int input){
        
        int de_4 = 0;;
        unsigned char output;
        
        if(input <= 63){
//            DE = 00 [0]
            output = 0x0;
            de_4 = 0;
        }
        else if(input <= 252){
//            DE = 01 [1]
            output = 0x1;
            de_4 = 2;
        }
        
        else if(input <= 1008){
//            DE = 10 [2]
            output = 0x2;
            de_4 = 4;
        }
        
        else {
//           DE = 11 [3]
            output = 0x3;
            de_4 = 6;
        }
        
        unsigned short int temp = input >> de_4;
        output += (temp ) << 2;
        
        return output;
    };
    
    unsigned char SFP_compress5_AT(unsigned int input){
        int de_4 = 0;;
        unsigned char output;
        
        if(input <= 3){
//            DE = 000 [0]
            output = 0x0;
            de_4 = 0;
        }
        else if(input <= 12){
//            DE = 001 [1]
            output = 0x1;
            de_4 = 2;
        }
        
        else if(input <= 48){
//            DE = 010 [2]
            output = 0x2;
            de_4 = 4;
        }
        
        else if(input <= 192) {
//           DE = 011 [3]
            output = 0x3;
            de_4 = 6;
        }
        
        else if(input <= 768) {
//           DE = 100 [4]
            output = 0x4;
            de_4 = 8;
        }
        
        else if(input <= 3072) {
//           DE = 101 [5]
            output = 0x5;
            de_4 = 10;
        }
        
        else if(input <= 12288) {
//           DE = 110 [6]
            output = 0x6;
            de_4 = 12;
        }
        
        else  {
//          DE = 111 [7]
            output = 0x7;
            de_4 = 14;
        }
           
        unsigned short int temp = input >> de_4;
        output += (temp ) << 3;
        
        return output;
    }
    
    unsigned char SFP_compress7FC_AT(unsigned int input){                   // for fast chain above threshold
        int de_4 = 0;;
        unsigned char output;
        
        if(input <= 15){
//            DE = 000 [0]
            output = 0x0;
            de_4 = 0;
        }
        else if(input <= 60){
//            DE = 001 [1]
            output = 0x1;
            de_4 = 2;
        }
        
        else if(input <= 240){
//            DE = 010 [2]
            output = 0x2;
            de_4 = 4;
        }
        
        else if(input <= 960) {
//           DE = 011 [3]
            output = 0x3;
            de_4 = 6;
        }
        
        else if(input <= 3840) {
//           DE = 100 [4]
            output = 0x4;
            de_4 = 8;
        }
        
        else if(input <= 15360) {
//           DE = 101 [5]
            output = 0x5;
            de_4 = 10;
        }
        
        else if(input <= 61440) {
//           DE = 110 [6]
            output = 0x6;
            de_4 = 12;
        }
        
        else  {
//          DE = 111 [7]
            output = 0x7;
            de_4 = 14;
        }
           
        unsigned short int temp = input >> de_4;
        output += (temp ) << 3;
        
        return output;
    }
    
    
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    unsigned char SCP_compress6(unsigned int input){
        int ef_4;
        unsigned char output;
        
        if(input <= 15){
//      EF = 00
        output = 0x0;
        ef_4 = 0;
        }
        
        else if(input <= 60 ){
//          EF = 01 [1]
            output = 0x01;
            ef_4 = 2;
        }
        else if(input <= 240){
//          EF = 10 [2]
            output = 0x02;
            ef_4 = 4;
        }
        else{
//          EF = 11 [3]
            output = 0x03;
            ef_4 = 6;
        }
            
            unsigned short int temp = input >> ef_4;
            output += (temp & 0xf) << 2;
            
            return output;
    }
    
    unsigned char SCP_compress5(unsigned int input){
        
        int de_4 = 0;;
        unsigned char output;
        
        if(input <= 7){
//            DE = 00 [0]
            output = 0x0;
            de_4 = 0;
        }
        
        else if(input <= 28){
//            DE = 01 [1]
            output = 0x01;
            de_4 = 2;
        }
        else if(input <= 112){
//            DE = 10 [2]
            output = 0x02;
            de_4 = 4;
        }
        else{
//        DE = 11 [3]
            output = 0x03;
            de_4 = 6;
        }
        
        unsigned short int temp = input >> de_4;
        output += (temp & 0x7) << 2;
        
        return output;
    }
    
        unsigned char SCP_compress6h(unsigned int input) {
    
        int ef_4;
        unsigned char output;
        
        if(input <=7){
//          EF = 000 [0]
            output = 0x00;
            ef_4 = 0;
        }
        
        else if(input <=28){
//          EF = 001 [1]
            output = 0x01;
            ef_4 = 2;
        }
        else if(input <= 112){
        
//          EF = 010 [2]
            output = 0x02;
            ef_4 = 4;
        }
        else if(input <= 448){
//          EF = 011 [3]
            output = 0x03;
            ef_4 = 6;
        }
        else if(input <= 1792){
//          EF = 100 [4]
            output = 0x04;
            ef_4 = 8;
            
        }
        else if(input <= 7168){
//          EF = 101 [5]
            output = 0x05;
            ef_4 = 10;
            
        }
        else if(input <= 28672){
//          EF = 110 [6]
            output = 0x06;
            ef_4 = 12;
        }
        else{
//          EF = 111 [7]
            output = 0x07;
            ef_4 =14;
        }
        
        unsigned short int temp = input >> ef_4;
        output += (temp & 0x7) << 3;
        
        return output;
        
    }
    
    
    unsigned char SCP_compress7h(unsigned int input) {
    
        int fg_4;
        unsigned char output;
        
        if(input <= 15){
//          EF = 000 [0]
            output = 0x0;
            fg_4 = 0;
        }
        
        else if(input <= 60){
//          EF = 001 [1]
            output = 0x01;
            fg_4 = 2;
        }
        else if(input <= 240){
        
//          EF = 010 [2]                    
            output = 0x02;
            fg_4 = 4;
        }
        else if(input <= 960){
//          EF = 011 [3]
            output = 0x03;
            fg_4 = 6;
        }
        else if(input <= 3840){
//          EF = 100 [4]
            output = 0x04;
            fg_4 = 8;
            
        }
        else if(input <= 15360){
//          EF = 101 [5]
            output = 0x05;
            fg_4 = 10;
            
        }
        else if(input <= 61440){
//          EF = 110 [6]
            output = 0x06;
            fg_4 = 12;
        }
        else{
//          EF = 111 [7]
            output = 0x07;
            fg_4 =14;
        }
        
        unsigned short int temp = input >> fg_4;
        output += (temp & 0xf) << 3;
        
        return output;
        
    }
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    void SCP_compress_data();                   
    void SFP_compress_data(unsigned char* input){

            bool LCR = true;
            int i = 0;
            static int packet_no = 0;                       //takes value from 0 to 29
            //TRAVERSE THE LIST TO DETERMINE LCR OR HCR and stroing the values in proton_bin and electron bin
            SFP_bin[0] = *input;
            for(i=1 ; i<= NUM_PROTON_BIN + NUM_ELECTRON_BIN + VETO ; ++i){          //storing the bin values into an array name bin
                SFP_bin[i]=read_2byte(input+1+((i-1)<<1));                             //proton bin and elecron bin are 2 byte, hence read_2byte and 
                SCP_bin[i]+=SFP_bin[i];
                if(SFP_bin[i] > SFP_thresholds[i]){                                         //fast cahin is 4 byte hence read_4byte
                    LCR = false;                                                    // if a single value is above threshold then lcr becomes false
                    i++;
                    break;
                }
            }
            
            for( ; i<= NUM_PROTON_BIN + NUM_ELECTRON_BIN + VETO ; ++i){
                SCP_bin[i]+=SFP_bin[i];
                SFP_bin[i] = read_2byte(input + 1 + ( (i-1)<<1) );
            }
            
            SFP_bin[i] = read_4byte(input+1+ ((i-1)<<1))    ;
            SCP_bin[i]+=SFP_bin[i];
            
            if(SFP_bin[i]>SFP_thresholds[i])
                LCR = false;                                                    //since veto starts from location (input + 65) and (input + 69)
                    
            SFP_bin[i+1] = read_4byte(input+69);
            SCP_bin[i]+=SFP_bin[i];
            
            if(SFP_bin[i]>SFP_thresholds[i])
                LCR = false;
            
            
//          printf("\n");                       //for printing the sfp bin
//          for (i=0;i<35;i++){
//              printf("sfp[%d] = %d",i,SFP_bin[i]);
//          }
//          printf("\n");

            if(LCR){   
                
                 SFP_outputBT[0]  =  (packet_no<<3) + ( SFP_compress5_BT(SFP_bin[1])>>2 );
                 SFP_outputBT[1]  =  ( SFP_compress5_BT(SFP_bin[1])<<6 ) + ( SFP_compress5_BT(SFP_bin[2])<<1 ) +   ( SFP_compress5_BT(SFP_bin[3])>>4 );
                 SFP_outputBT[2]  =  ( SFP_compress5_BT(SFP_bin[3])<<4 ) + ( SFP_compress5_BT(SFP_bin[4])>>1 );
                 SFP_outputBT[3]  =  ( SFP_compress5_BT(SFP_bin[4])<<7 ) + ( SFP_compress5_BT(SFP_bin[5])<<2 ) + ( SFP_compress5_BT(SFP_bin[6])>>3 );            
                 SFP_outputBT[4]  =  ( SFP_compress5_BT(SFP_bin[6])<<5 ) + ( SFP_compress5_BT(SFP_bin[7]) );
                 SFP_outputBT[5]  =  ( SFP_compress5_BT(SFP_bin[8])<<3 ) + ( SFP_compress5_BT(SFP_bin[9])>>2 );
                 SFP_outputBT[6]  =  ( SFP_compress5_BT(SFP_bin[9])<<6 ) + ( SFP_compress5_BT(SFP_bin[10])<<1 ) +  ( SFP_compress5_BT(SFP_bin[11])>>4 );
                 SFP_outputBT[7]  =  ( SFP_compress5_BT(SFP_bin[11])<<4 ) + ( SFP_compress5_BT(SFP_bin[12])>>1 );            
                 SFP_outputBT[8]  =  ( SFP_compress5_BT(SFP_bin[12])<<7 ) + ( SFP_compress5_BT(SFP_bin[13])<<2 ) + ( SFP_compress5_BT(SFP_bin[14])>>3 );
                 SFP_outputBT[9]  =  ( SFP_compress5_BT(SFP_bin[14])<<5 ) + ( SFP_compress5_BT(SFP_bin[15]) );
                 SFP_outputBT[10] =  ( SFP_compress5_BT(SFP_bin[16])<<3 ) + ( SFP_compress5_BT(SFP_bin[17])>>2 );
                 SFP_outputBT[11] =  ( SFP_compress5_BT(SFP_bin[17])<<6 ) + ( SFP_compress6_BT(SFP_bin[18]) );
                 SFP_outputBT[12] =  ( SFP_compress6_BT(SFP_bin[19])<<2 ) + ( SFP_compress6_BT(SFP_bin[20])>>4 );
                 SFP_outputBT[13] =  ( SFP_compress6_BT(SFP_bin[20])<<4 ) + ( SFP_compress5_BT(SFP_bin[21])>>1 );        
                 SFP_outputBT[14] =  ( SFP_compress5_BT(SFP_bin[21])<<7 ) + ( SFP_compress5_BT(SFP_bin[22])<<2 )  + ( SFP_compress5_BT(SFP_bin[23])>>3 );
                 SFP_outputBT[15] =  ( SFP_compress5_BT(SFP_bin[23])<<5 ) + ( SFP_compress5_BT(SFP_bin[24]) );
                 SFP_outputBT[16] =  ( SFP_compress5_BT(SFP_bin[25])<<3 ) + ( SFP_compress5_BT(SFP_bin[26])>>2 );
                 SFP_outputBT[17] =  ( SFP_compress5_BT(SFP_bin[26])<<6 ) + ( SFP_compress5_BT(SFP_bin[27])<<1 ) + ( SFP_compress5_BT(SFP_bin[28])>>4);
                 SFP_outputBT[18] =  ( SFP_compress5_BT(SFP_bin[28])<<4 ) + ( SFP_compress5_BT(SFP_bin[29])>>1) ;
                 SFP_outputBT[19] =  ( SFP_compress5_BT(SFP_bin[29])<<7 ) + ( SFP_compress5_BT(SFP_bin[30])<<2 ) + ( SFP_compress5_BT(SFP_bin[31])>>3)  ; 
                 SFP_outputBT[20] =  ( SFP_compress5_BT(SFP_bin[31])<<5 ) + ( SFP_compress4_BT(SFP_bin[32])<<1)  + ( SCP_compress5(SFP_bin[33])>>4 ) ; //
                 SFP_outputBT[21] =  ( SCP_compress5(SFP_bin[33])<<4 ) + ( SCP_compress5(SFP_bin[34])>>1 );        //here intentionally SCP_compress is used instead of SCP_compress5 is different than SFP_compress5
                 SFP_outputBT[22] =  ( SCP_compress5(SFP_bin[34])<<7 );                                             //7 bits are spare
                 
                 Science_TMframe::making_frame(3,'L',SFP_outputBT);
                 if(++packet_no == 30){
                    packet_no=0;
                    SCP_compress_data();
                    for(i=0;i<PACKET_SEQUENCE_COUNT + NUM_PROTON_BIN + NUM_ELECTRON_BIN + VETO + FASTCHAIN;i++){
                        if(packet_no==0){
                            SCP_bin[i]=0;
                        }
                    }
                 }
                 
                 
            }

            else {
                
                
                SFP_outputAT[0]  = (RTC_TIME>>27)&(0xff);
                SFP_outputAT[1]  = (RTC_TIME>>19)&(0xff);
                SFP_outputAT[2]  = (RTC_TIME>>11)&(0xff);
                SFP_outputAT[3]  = (RTC_TIME>>3 )&(0xff);
                SFP_outputAT[4]  = (RTC_TIME<<5 )&(0xff) + (packet_no);
                SFP_outputAT[5]  = ( SFP_compress7_AT(SFP_bin[1])<<1 ) + ( SFP_compress7_AT(SFP_bin[2])>>6 );
                SFP_outputAT[6]  = ( SFP_compress7_AT(SFP_bin[2])<<2 ) + ( SFP_compress7_AT(SFP_bin[3])>>5 );
                SFP_outputAT[7]  = ( SFP_compress7_AT(SFP_bin[3])<<3 ) + ( SFP_compress7_AT(SFP_bin[4])>>4 );
                SFP_outputAT[8]  = ( SFP_compress7_AT(SFP_bin[4])<<4 ) + ( SFP_compress7_AT(SFP_bin[5])>>3 );
                SFP_outputAT[9]  = ( SFP_compress7_AT(SFP_bin[5])<<5 ) + ( SFP_compress7_AT(SFP_bin[6])>>2 );
                SFP_outputAT[10] = ( SFP_compress7_AT(SFP_bin[6])<<6 ) + ( SFP_compress7_AT(SFP_bin[7])>>1 );
                SFP_outputAT[11] = ( SFP_compress7_AT(SFP_bin[7])<<7 ) + ( SFP_compress7_AT(SFP_bin[8]) );
                SFP_outputAT[12] = ( SFP_compress7_AT(SFP_bin[9])<<1 ) + ( SFP_compress7_AT(SFP_bin[10])>>6);
                SFP_outputAT[13] = ( SFP_compress7_AT(SFP_bin[10])<<2 ) + ( SFP_compress7_AT(SFP_bin[11])>>5);
                SFP_outputAT[14] = ( SFP_compress7_AT(SFP_bin[11])<<3 ) + ( SFP_compress7_AT(SFP_bin[12])>>4);
                SFP_outputAT[15] = ( SFP_compress7_AT(SFP_bin[12])<<4 ) + ( SFP_compress7_AT(SFP_bin[13])>>3);
                SFP_outputAT[16] = ( SFP_compress7_AT(SFP_bin[13])<<5 ) + ( SFP_compress7_AT(SFP_bin[14])>>2);
                SFP_outputAT[17] = ( SFP_compress7_AT(SFP_bin[14])<<6 ) + ( SFP_compress7_AT(SFP_bin[15])>>1);
                SFP_outputAT[18] = ( SFP_compress7_AT(SFP_bin[15])<<7 ) + ( SFP_compress7_AT(SFP_bin[16]));
                SFP_outputAT[19] = ( SFP_compress7_AT(SFP_bin[17])<<1 ) + ( SFP_compress8_AT(SFP_bin[18])>>7 );
                SFP_outputAT[20] = ( SFP_compress8_AT(SFP_bin[18])<<1 ) + ( SFP_compress8_AT(SFP_bin[19])>>7 );
                SFP_outputAT[21] = ( SFP_compress8_AT(SFP_bin[19])<<1 ) + ( SFP_compress8_AT(SFP_bin[20])>>7 );
                SFP_outputAT[22] = ( SFP_compress8_AT(SFP_bin[20])<<1 ) + ( SFP_compress7_AT(SFP_bin[21])>>6 );
                SFP_outputAT[23] = ( SFP_compress7_AT(SFP_bin[21])<<2 ) + ( SFP_compress7_AT(SFP_bin[22])>>5 );
                SFP_outputAT[24] = ( SFP_compress7_AT(SFP_bin[22])<<3 ) + ( SFP_compress7_AT(SFP_bin[23])>>4 );
                SFP_outputAT[25] = ( SFP_compress7_AT(SFP_bin[23])<<4 ) + ( SFP_compress7_AT(SFP_bin[24])>>3 );
                SFP_outputAT[26] = ( SFP_compress7_AT(SFP_bin[24])<<5 ) + ( SFP_compress7_AT(SFP_bin[25])>>2 );
                SFP_outputAT[27] = ( SFP_compress7_AT(SFP_bin[25])<<6 ) + ( SFP_compress7_AT(SFP_bin[26])>>1 );
                SFP_outputAT[28] = ( SFP_compress7_AT(SFP_bin[26])<<7 ) + ( SFP_compress7_AT(SFP_bin[27]) );
                SFP_outputAT[29] = ( SFP_compress7_AT(SFP_bin[28])<<1 ) + ( SFP_compress7_AT(SFP_bin[29])>>6);
                SFP_outputAT[30] = ( SFP_compress7_AT(SFP_bin[29])<<2 ) + ( SFP_compress7_AT(SFP_bin[30])>>5);
                SFP_outputAT[31] = ( SFP_compress7_AT(SFP_bin[30])<<3 ) +( SFP_compress7_AT(SFP_bin[31])>>4);  
                SFP_outputAT[32] = ( SFP_compress7_AT(SFP_bin[31])<<4 ) +( SFP_compress5_AT(SFP_bin[32])>>1); 
                SFP_outputAT[33] = ( SFP_compress5_AT(SFP_bin[32])<<7 ) +( SFP_compress7FC_AT(SFP_bin[33])); 
                SFP_outputAT[34] =  ( SFP_compress7FC_AT(SFP_bin[34])<<1 );                                             // 1 bit is spare          
                
                Science_TMframe::making_frame(2,'H',SFP_outputAT);
                if(++packet_no == 30){
                    packet_no=0;
                    SCP_compress_data();
                    for(i=0;i<PACKET_SEQUENCE_COUNT + NUM_PROTON_BIN + NUM_ELECTRON_BIN + VETO + FASTCHAIN;i++){
                        if(packet_no==0){
                            SCP_bin[i]=0;
                        }
                    }
                }
                            
            }

    }


/*
    brief: takes the  pointer of the raw data string and return the address of the array which stores the address of 30 packets.
    input: pointer to the raw data.
    output : void
*/

    void complete_compression(unsigned char *SRP,uint64_t x){
        RTC_TIME = x;
        int i;                  //30 times because 3 second data
    
        for(i=0;i<30;i++){
         SFP_compress_data(SRP + 73*i); 
        }

    }



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    
    
    /*
    @brief:     compresses the given input stream and return output packet
    @param:     pointer to input stream. Input stream always has the fixed size of RAW_PACKET_LENGTH
    @return:    pointer to output stream. Output stream has the size of 22 or 26 bytes
    */
    void SCP_compress_data(){
        
        bool LCR = true;
        int i = 0;
        
        for(i=1;i<=PACKET_SEQUENCE_COUNT + NUM_PROTON_BIN + NUM_ELECTRON_BIN + VETO + FASTCHAIN ;i++){
            if(SCP_bin[i]>SCP_thresholds[i]){
            LCR = false;
            break;
            }
        }
//      printf("\n");                    //for printing the scp bin
//          for (i=0;i<35;i++){
//              printf(" scp[%d] = %d    ",i,SCP_bin[i]);
//          }
//          printf("\n");         
        // compressing the data
        if(LCR){   
             SCP_outputLCR[0] = (RTC_TIME>>5)&(0xff);                //first 13 bits for time tagging
             SCP_outputLCR[1] = (RTC_TIME<<3)&(0xff);                //then 4 bits for attitude tag
             SCP_outputLCR[2] = 0x00;                                //only attitude tag is left
             SCP_outputLCR[2] += ( SCP_compress5(SCP_bin[0])<<1 ) + ( SCP_compress5(SCP_bin[1])>>4 );
             SCP_outputLCR[3] = ( SCP_compress5(SCP_bin[1])<<4 ) + ( SCP_compress5(SCP_bin[2])>>1 );
             SCP_outputLCR[4] = ( SCP_compress5(SCP_bin[2])<<7 ) + ( SCP_compress5(SCP_bin[3])<<2 ) + ( SCP_compress5(SCP_bin[4])>>3 );
             SCP_outputLCR[5] = ( SCP_compress5(SCP_bin[4])<<5 ) + ( SCP_compress5(SCP_bin[5]) );            
             SCP_outputLCR[6] = ( SCP_compress5(SCP_bin[6])<<3 ) + ( SCP_compress5(SCP_bin[7])>>2 );
             SCP_outputLCR[7] = ( SCP_compress5(SCP_bin[7])<<6 ) + ( SCP_compress5(SCP_bin[8])<<1 ) +  ( SCP_compress5(SCP_bin[9])>>4 );
             SCP_outputLCR[8] = ( SCP_compress5(SCP_bin[9])<<4 ) + ( SCP_compress5(SCP_bin[10])>>1 );
             SCP_outputLCR[9] = ( SCP_compress5(SCP_bin[10])<<7 ) + ( SCP_compress5(SCP_bin[11])<<2) + ( SCP_compress5(SCP_bin[12])>>3 );            
             SCP_outputLCR[10] = ( SCP_compress5(SCP_bin[12])<<5 ) + ( SCP_compress5(SCP_bin[13]) );
             SCP_outputLCR[11] = ( SCP_compress5(SCP_bin[14])<<3 ) + ( SCP_compress5(SCP_bin[15])>>2 );
             SCP_outputLCR[12] = ( SCP_compress5(SCP_bin[15])<<6 ) + ( SCP_compress5(SCP_bin[16])<<1) +  ( SCP_compress6(SCP_bin[17])>>5 );
             SCP_outputLCR[13] = ( SCP_compress6(SCP_bin[17])<<3 ) + ( SCP_compress6(SCP_bin[18])>>3 );
             SCP_outputLCR[14] = ( SCP_compress5(SCP_bin[18])<<5 ) + ( SCP_compress6(SCP_bin[19])>>1 );
             SCP_outputLCR[15] = ( SCP_compress6(SCP_bin[19])<<7 ) + ( SCP_compress5(SCP_bin[20])<<2 ) + ( SCP_compress5(SCP_bin[21])>>3 );          
             SCP_outputLCR[16] = ( SCP_compress5(SCP_bin[21])<<5 ) + ( SCP_compress5(SCP_bin[22]) );
             SCP_outputLCR[17] = ( SCP_compress5(SCP_bin[23])<<3 ) + ( SCP_compress5(SCP_bin[24])>>2 );
             SCP_outputLCR[18] = ( SCP_compress5(SCP_bin[24])<<6 ) + ( SCP_compress5(SCP_bin[25])<<1) +  ( SCP_compress5(SCP_bin[26])>>4 );
             SCP_outputLCR[19] = ( SCP_compress5(SCP_bin[26])<<4 ) + ( SCP_compress5(SCP_bin[27])>>1 );
             SCP_outputLCR[20] = ( SCP_compress5(SCP_bin[27])<<7 ) + ( SCP_compress5(SCP_bin[28])<<2 ) + ( SCP_compress5(SCP_bin[29])>>3 ); 
             SCP_outputLCR[21] = ( SCP_compress5(SCP_bin[29])<<5 ) + ( SCP_compress5(SCP_bin[30]) );
         
             Science_TMframe::making_frame(1,'L',SCP_outputLCR);
        }
        else{
            
            SCP_outputLCR[0] = (RTC_TIME>>5)&(0xff);                //first 13 bits for time tagging
            SCP_outputLCR[1] = (RTC_TIME<<3)&(0xff);
            SCP_outputHCR[2] = 0x40;
            SCP_outputHCR[2] += ( SCP_compress6h(SCP_bin[0])<<6 ) ;
            SCP_outputHCR[3] = ( SCP_compress6h(SCP_bin[1])<<2 ) + ( SCP_compress6h(SCP_bin[2])>>4) ;
            SCP_outputHCR[4] = ( SCP_compress6h(SCP_bin[2])<<4 ) + ( SCP_compress6h(SCP_bin[3])>>2) ;
            SCP_outputHCR[5] = ( SCP_compress6h(SCP_bin[3])<<6 ) + ( SCP_compress6h(SCP_bin[4])) ;
            SCP_outputHCR[6] = ( SCP_compress6h(SCP_bin[5])<<2 ) + ( SCP_compress6h(SCP_bin[6])>>4) ;
            SCP_outputHCR[7] = ( SCP_compress6h(SCP_bin[6])<<4 ) + ( SCP_compress6h(SCP_bin[7])>>2) ;
            SCP_outputHCR[8] = ( SCP_compress6h(SCP_bin[7])<<6 ) + ( SCP_compress6h(SCP_bin[8])) ;
            SCP_outputHCR[9] = ( SCP_compress6h(SCP_bin[9])<<2 ) + ( SCP_compress6h(SCP_bin[10])>>4) ;
            SCP_outputHCR[10] = ( SCP_compress6h(SCP_bin[10])<<4 ) + ( SCP_compress6h(SCP_bin[11])>>2);
            SCP_outputHCR[11] = ( SCP_compress6h(SCP_bin[11])<<6 ) + ( SCP_compress6h(SCP_bin[12])) ;
            SCP_outputHCR[12] = ( SCP_compress6h(SCP_bin[13])<<2 ) + ( SCP_compress6h(SCP_bin[14])>>4)  ;
            SCP_outputHCR[13] = ( SCP_compress6h(SCP_bin[14])<<4 ) + ( SCP_compress6h(SCP_bin[15])>>2)  ;
            SCP_outputHCR[14] = ( SCP_compress6h(SCP_bin[15])<<6 ) + ( SCP_compress6h(SCP_bin[16]))     ;
            SCP_outputHCR[15] = ( SCP_compress7h(SCP_bin[17])<<1 ) + ( SCP_compress7h(SCP_bin[18])>>6)  ;
            SCP_outputHCR[16] = ( SCP_compress7h(SCP_bin[18])<<2 ) + ( SCP_compress7h(SCP_bin[19])>>5)  ;
            SCP_outputHCR[17] = ( SCP_compress7h(SCP_bin[19])<<3 ) + ( SCP_compress6h(SCP_bin[20])>>3)  ;
            SCP_outputHCR[18] = ( SCP_compress6h(SCP_bin[20])<<5 ) + ( SCP_compress6h(SCP_bin[21])>>1)  ;
            SCP_outputHCR[19] = ( SCP_compress6h(SCP_bin[21])<<7 ) + ( SCP_compress6h(SCP_bin[22])<<1) +  ( SCP_compress6h(SCP_bin[23])>>5) ;
            SCP_outputHCR[20] = ( SCP_compress6h(SCP_bin[23])<<3 ) + ( SCP_compress6h(SCP_bin[24])>>3)  ;
            SCP_outputHCR[21] = ( SCP_compress6h(SCP_bin[24])<<5 ) + ( SCP_compress6h(SCP_bin[25])>>1)  ;
            SCP_outputHCR[22] = ( SCP_compress6h(SCP_bin[25])<<7 ) + ( SCP_compress6h(SCP_bin[26])<<1) +  ( SCP_compress6h(SCP_bin[27])>>5) ;
            SCP_outputHCR[23] = ( SCP_compress6h(SCP_bin[27])<<3 ) + ( SCP_compress6h(SCP_bin[28])>>3)  ;
            SCP_outputHCR[24] = ( SCP_compress6h(SCP_bin[28])<<5 ) + ( SCP_compress6h(SCP_bin[29])>>1)  ;
            SCP_outputHCR[25] = ( SCP_compress6h(SCP_bin[29])<<7 ) + ( SCP_compress6h(SCP_bin[30])<<1)  ; //last bit is empty
        
        /*  for (i=0;i<26;i++){
                printf("\nscp[%d] = %d",i,SCP_outputHCR[i]);
            }*/
            Science_TMframe::making_frame(1,'H',SCP_outputHCR);
        }
    }
    
}
