SPI adf(PTA16, PTA17, PTA15); //MOSI, MISO, CLOCK
DigitalOut cs_adf(D10);
DigitalOut led2(LED_RED);
InterruptIn IRQ(D8);
Ticker ticker;
unsigned char buffer_half=1; 
unsigned char buffer_counter = 0;
bool transmission_done = false;
bool sent_tmfrom_SDcard;
unsigned char bbram_buffer[66]={0x19,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0xF4,0xc2,0x10,0xC0,0x00,0x30,0x31,0x07,0x00,0x01,0x00,0x7F,0x00,0x0B,0x37,0x00,0x00,0x40,0x0C,0x00,0x05,0x00,0x00,0x18,0x12,0x34,0x56,0x10,0x10,0xC4,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00};
void bbram_write(){   
 
    cs_adf=0;
    adf.write(0xB0);//PHY_OFF
    wait_us(300);
    cs_adf=1;

    // Write bbram
    cs_adf=0;
    for(int i=0;i<66;i++){
        adf.write(bbram_buffer[i]);    
    }
    cs_adf=1;
    
}


/******************************************************************************************/

void initiate(void){
    cs_adf=0;
    adf.write(0xFF);
    adf.write(0xFF);
    cs_adf=1;
//    wait_ms(2);

    cs_adf=0;
    adf.write(0x08);    // TRANSMIT_DATA LENGTH
    adf.write(0x14);
    adf.write(0xFF);
    cs_adf=1;
//    wait_ms(2);
    cs_adf=0;
    adf.write(0x08);        // TRANSMIT_DATA LENGTH
    adf.write(0x15);
    adf.write(0xFF);
    cs_adf=1;
//    wait_ms(2);
    
    cs_adf=0;
    adf.write(0x09);
    adf.write(0x24);   // TX_BASE ADDRESS   0x20(starting Tx Byte)
    adf.write(0x20);
    cs_adf=1;
//    wait_ms(2);
    
    cs_adf=0;
    adf.write(0x09);
    adf.write(0x37);// BUFFER SIZE 0xE0=224 Bytes 0x137 is adress of buffer size
    adf.write(0xE0);
    cs_adf=1;
//    wait_ms(2);
    
    cs_adf=0;
    adf.write(0x09);
    adf.write(0x36);//BB_Tx_Buffer Signal when Buffer is half filled
    adf.write(0x70);//0x70 = 112 >> When Half buffer interrupt is given
    cs_adf=1;
//    wait_ms(2);
    
    
    cs_adf=0;
    adf.write(0x09);
    adf.write(0x39);//BB_Tx_Buffer Signal when Buffer is half filled
    adf.write(0x10);//0x70 = 112 >> When Half buffer interrupt is given
    cs_adf=1;
//    wait_ms(2);    
    }

 

void write_data(void){
   
    cs_adf=0;
    adf.write(0x0B);//IRQ_SOURCE_Random write //To read CMD = 2B 36 FF FF
    adf.write(0x36);//Address : 0x336
    adf.write(0xFF);//Put Low
    cs_adf=1;

    cs_adf=0;
    static bool first_2_time = true;
    buffer_counter=0;
 
    if(first_2_time==false && last_buffer==false){
       
        adf.write(0x18);
        if(buffer_half==1){
            adf.write(0x20);
            buffer_half = 2;
        }
        else if(buffer_half==2){
            adf.write(0x90);
            buffer_half = 1;
        }
        
        buffer_counter = 0;
        while(buffer_counter<112){
            adf.write(buffer_112[buffer_counter]);  
            buffer_counter++;
        }
           
    }
 
    if(first_2_time == true && last_buffer==false){
        
        adf.write(0x18);
        if(buffer_half==1){
            adf.write(0x20);
            buffer_half=2;
        }
        else{
            adf.write(0x90);
            buffer_half=1;
            first_2_time = false;
        }
        
        while(buffer_counter<112){
            adf.write(buffer_112[buffer_counter]);  
            buffer_counter++;
        }
            
    }

    if(last_buffer){
        cs_adf=0;
        adf.write(0x18);
        adf.write(0x20);
       
        while(buffer_counter<112){
            adf.write(buffer_112[buffer_counter]);  
            buffer_counter++;
        }
        cs_adf=1;
            
        ticker.detach();
        cs_adf=0;
         adf.write(0xB1);
        cs_adf=1;
        transmission_done=true;
    }
                          
cs_adf=1;
}
    

void check(){   
    
    if(IRQ){
        write_data();
        if(sent_tmfrom_SDcard){
        send_tm_from_SD_card();
        }
        
        else{
        snd_tm.transmit_data(buffer_112,&last_buffer);
        }    
    }
}
  

void send_data(void){
        
    cs_adf=0;
    adf.write(0xBB);
    cs_adf=1;
//    wait_us(300); 
    
    cs_adf=0;
    adf.write(0xFF);
    adf.write(0xFF);
    cs_adf=1;
//    wait_ms(2);
    if(sent_tmfrom_SDcard){
        send_tm_from_SD_card();
    }
    else{ 
        snd_tm.transmit_data(buffer_112,&last_buffer);
    }
    write_data();
    if(sent_tmfrom_SDcard)
    {
        send_tm_from_SD_card();
    }
    else
    { 
        snd_tm.transmit_data(buffer_112,&last_buffer);
    }
    write_data();
    if(sent_tmfrom_SDcard)
    {
        send_tm_from_SD_card();
    }
    else
    { 
        snd_tm.transmit_data(buffer_112,&last_buffer);
    }

    cs_adf=0;
    adf.write(0xB1);
    cs_adf=1;
    wait_us(300); 
    
    cs_adf=0;
    adf.write(0xFF);
    adf.write(0xFF);
    cs_adf=1;
//    wait_ms(2);  
    
    cs_adf=0;
    adf.write(0xB5);
    cs_adf=1;
//    cout<<"B5 given"<<ENDL;
    wait_us(300);  
//    int b5=t.read_us();
    cs_adf=0;
    adf.write(0xFF);
    adf.write(0xFF);
    cs_adf=1;
//    wait_ms(2);
    ticker.attach_us(&check,32000);
    
    while(!transmission_done){
        led2=!led2;
        wait(.1);
    }
    
}
    
    
    
void inline adf_SND_SDCard(uint64_t x,uint64_t y ){
    start_block_num = x;
    end_block_num = y;
    sent_tmfrom_SDcard = true;
    adf.format(8,0);
    adf.frequency(1000000);

    bbram_write();
    initiate();
    send_data();

}
    
void read_TC(TC_list* TC_ptr){
    unsigned char service_subtype = 0;
    uint64_t starting_add  = 0, ending_add = 0;
    service_subtype = (TC_ptr->TC_string[2])&0x0f;
    starting_add =  (TC_ptr->TC_string[5]) +  ( (TC_ptr->TC_string[4])<<8 ) + ( (TC_ptr->TC_string[3]) <<16);
    ending_add =  (TC_ptr->TC_string[8]) +  ( (TC_ptr->TC_string[7])<<8 ) + ( (TC_ptr->TC_string[6]) <<16);
    adf_SND_SDCard(starting_add , ending_add);   
}
    

void adf_not_SDcard(){
    adf.format(8,0);
    adf.frequency(1000000);
    sent_tmfrom_SDcard = false;
    
    bbram_write();
    initiate();
    send_data();

}    

