//without warning
void adf_not_SDcard();

#define S_FRAME_SIZE 48
#define EoS_SIZE 120
#define SEGMENT_SIZE 40
#define TM_FRAME_SIZE 134

class SND_TM{
    
    int diff_prev;
    int type0_no;                                               //number of type zero frames
    int type1_no;                                           
    int total_frames;                                           //number of type one packe (TMP)
    int segment_no;                                             //number of type one packe (TMP)
    TM_list * list_ptr;   
    unsigned char SCH40[5];                                     
    unsigned char FCCH80[10];
    bool reset_flag;                                            //for reseting all the static variables when new list is given.
    
    void differential_encode(unsigned char* ptr, int length){
    
        for(int i=0; i<length;i++){
        
            unsigned char s = ptr[i] , t;
            t = s ^ (s >> 1);
            (diff_prev == 0) ? t=t^0x00 : t=t^0x80 ;
            diff_prev = int(s & 0x01);
            ptr[i] = t;
        }
        
    }    
    
    int decide_type(unsigned char tmid){
        int type = 0;
    
        switch(tmid){
            case 0x1:
            case 0x2:
            case 0x3:
            case 0x4:
            case 0x5:
            case 0x6:
            case 0x7:
            case 0x8:
                type = 0;
                break;
            case 0xA:
            case 0xB:
            case 0xC:
            case 0xD:
            case 0xE:
                type = 1;
                break;
        }
    
        return type;
    }
    
    void data_number(){

        int type1_frame_no;
        TM_list *head = list_ptr;
        
        type0_no = 0;
        type1_no = 0;
        
        do{
            
            switch( decide_type(head->tmid) ){
                case 0:
                        type0_no++;
                        break;
                case 1:
                        type1_no++;
                    
            }
            
            head=head->next_TM;
            
        }
        while(head->next_TM != NULL);
        
        type1_frame_no = ( type1_no % 10 == 0 )? (type1_no / 10) : ( (type1_no / 10) + 1);
        total_frames = type0_no + type1_frame_no ;
        segment_no = (total_frames*2 % (SEGMENT_SIZE-1) == 0) ? ( total_frames*2/(SEGMENT_SIZE-1) ) : (total_frames*2/(SEGMENT_SIZE-1) + 1);            //subtracting 1 since the last Tframe is not detected

    }
    
    
    TM_list* next_type_structure(TM_list *ptr){
        
        if(ptr == NULL){
            return NULL;
        }
                        
        int temp = decide_type(ptr->tmid);
        
        if((temp == 0) && (ptr->next_TM != NULL) ){
            
            do{
                ptr = ptr->next_TM;
                temp =  decide_type(ptr->tmid);
            }   
            while(temp == 1 && ptr->next_TM != NULL);   
            
            if(temp == 1){
            return NULL;
            }           
                
        }
        
        else if((temp == 1) && (ptr->next_TM != NULL)){
            
            do{
                ptr = ptr->next_TM;
                temp = decide_type(ptr->tmid);
            }   
            while(temp == 0 && ptr->next_TM != NULL);
            
            if(temp == 0){
            return NULL;
            }
                
                    
        }
        
        else{
                
//          cout<<"\nNULL returned by next_type_structure\n";
            return NULL;
            
        }
        return ptr;
    }
    
    /*
        brief:      take input type 0  or  1 and return the address of the first node in the list that have that type
        parameter:  type 0 or 1
        return:     pointer of the first node having same type      
    */
    TM_list* first_type_structure(int type){
        TM_list* temp_ptr = list_ptr;
    
        if(type == 0){
            while((decide_type(temp_ptr->tmid) == 1)){
                temp_ptr = temp_ptr->next_TM;
            
                if(temp_ptr == NULL){
                    return NULL ;
                }       
            }   
        }
        
        else if(type == 1){
            while((decide_type(temp_ptr->tmid) == 0) ){
                temp_ptr = temp_ptr->next_TM;
                
                if(temp_ptr == NULL){
                    return NULL;    
                }   
            }   
        }   
        return temp_ptr;
    }
    
    unsigned char TMframe_type1[TM_FRAME_SIZE];
    bool type1_frame_flag;                              //should be true for every new list
    
     unsigned char * type1_frame(){
        
        int i;
        static TM_list *pointer ;
        static int counter  = 0;
        
        if(type1_frame_flag){
            pointer = first_type_structure(1);
            counter = 0;
            type1_frame_flag = false;
        }
        
        

        for(i = 4 ; (i < 134) && (pointer != NULL) ; i++){
             TMframe_type1[i] = pointer->TM_string[counter];
             
              if(counter++ == 12){
                counter = 0;
                pointer = next_type_structure(pointer);
              }
        }
        
        // header
        TMframe_type1[0] = 1<<7 + ( (i-4)/10 )<<3;                          //( (i-4)/10 ) gives number of packets in the frame
            //insert time ;
        TMframe_type1[3] = CRC::crc16_gen(TMframe_type1,3);
        //end header
        
        if(pointer == NULL){
            for( ; i < 134 ; i++){                                          //repeating ;ast packet to fill up the extra space
                TMframe_type1[i] = TMframe_type1[i-13]; 
            }
        
        }
        return TMframe_type1;
    
    }
    
    bool type0_frame_flag;
    
    unsigned char* type0_frame(){
        static TM_list *pointer ; 
        
        if(type0_frame_flag){
            pointer = first_type_structure(0);  
            type0_frame_flag = false;
        }            
        
        else {
            pointer = next_type_structure(pointer);
            
        }
        return pointer->TM_string;
    }


    
void interleave( unsigned char *input, unsigned char *output ){
    
    unsigned int outState = 0;
    unsigned int outByte = 0;
    
    for( unsigned int i = 0 ; i < 36 ; ++i ){
        for(unsigned int j = 0 ; j < 30 ; ++j){
            unsigned int x = j*36+i;
            unsigned char tempBit = ((input[x >> 3]) >> (7-(x % 8))) & 1;
            switch(outState){
                case 0:
                    outState = 1;
                    output[outByte] = tempBit << 7;
                    break;
                case 1:
                    outState = 2;
                    output[outByte] += tempBit << 6;
                    break;
                case 2:
                    outState = 3;
                    output[outByte] += tempBit << 5;
                    break;
                case 3:
                    outState = 4;
                    output[outByte] += tempBit << 4;
                    break;
                case 4:
                    outState = 5;
                    output[outByte] += tempBit << 3;
                    break;
                case 5:
                    outState = 6;
                    output[outByte] += tempBit << 2;
                    break;
                case 6:
                    outState = 7;
                    output[outByte] += tempBit << 1;
                    break;
                case 7:
                    outState = 0;
                    output[outByte] += tempBit;
                    ++outByte;
                    break;
            }
        }
        for(unsigned int j = 0 ; j < 2 ; ++j){
            switch(outState){
                case 0:
                    output[outByte] = 0;
                    outState = 1;
                    break;
                case 1:
                    outState = 2;
                    break;
                case 2:
                    outState = 3;
                    break;
                case 3:
                    outState = 4;
                    break;
                case 4:
                    outState = 5;
                    break;
                case 5:
                    outState = 6;
                    break;
                case 6:
                    outState = 7;
                    break;
                case 7:
                    outState = 0;
                    ++outByte;
                    break;
            }
        }
    }
}

    
    
    public:
        
        bool give_buffer ;
        bool transmission_done;
        unsigned char S_frame[S_FRAME_SIZE];
        unsigned char EoS[EoS_SIZE];
        SND_TM(){
            
//          list_ptr = x;
            
            diff_prev = 0;
            
            type0_no= 0;
            type1_no= 0;            
            //~ S-FRAME
            //~ SCH_64 * 2
            S_frame[0] = 0x46;
            S_frame[1] = 0x9d;
            S_frame[2] = 0xfb;
            S_frame[3] = 0xf0;
            S_frame[4] = 0xd2;
            S_frame[5] = 0xba;
            S_frame[6] = 0x89;
            S_frame[7] = 0xe4;
            
            S_frame[8] = 0x46;
            S_frame[9] = 0x9d;
            S_frame[10] = 0xfb;
            S_frame[11] = 0xf0;
            S_frame[12] = 0xd2;
            S_frame[13] = 0xba;
            S_frame[14] = 0x89;
            S_frame[15] = 0xe4;
    
            //~ FCCH
            for(int i = 16 ; i < 48 ; ++i ){
                S_frame[i] = 0x00;
            }
    
            
            for(int i = 0 ; i < 24 ; ++i){
                 EoS[i] = 0x00;
            }
    
            //~ S-FRAME [1]
            //~ first two bits of S-FRAME
            EoS[23] = 0x01;
            
            EoS[24] = 0x1a;
            EoS[25] = 0x77;
            EoS[26] = 0xef;
            EoS[27] = 0xc3;
            EoS[28] = 0x4a;
            EoS[29] = 0xea;
            EoS[30] = 0x27;
            EoS[31] = 0x91;
            EoS[32] = 0x1a;
            EoS[33] = 0x77;
            EoS[34] = 0xef;
            EoS[35] = 0xc3;
            EoS[36] = 0x4a;
            EoS[37] = 0xea;
            EoS[38] = 0x27;
            EoS[39] = 0x90;
    
            for(int i = 40 ; i < 72 ; ++i){
                EoS[i] = 0x00;
            }
            
            //~ S-FRAME [2]
            //~ first two bits of S-FRAME
            EoS[71] = 0x01;
            
            EoS[72] = 0x1a;
            EoS[73] = 0x77;
            EoS[74] = 0xef;
            EoS[75] = 0xc3;
            EoS[76] = 0x4a;
            EoS[77] = 0xea;
            EoS[78] = 0x27;
            EoS[79] = 0x91;
            EoS[80] = 0x1a;
            EoS[81] = 0x77;
            EoS[82] = 0xef;
            EoS[83] = 0xc3;
            EoS[84] = 0x4a;
            EoS[85] = 0xea;
            EoS[86] = 0x27;
            EoS[87] = 0x90;
            
            for(int i = 88 ; i < 120 ; ++i){
                EoS[i] = 0x00;
            }
            
            for(int i = 0 ; i < 10 ; ++i){
                FCCH80[i] = 0x00;
            }
            
            SCH40[0] = 0x0a;
            SCH40[1] = 0x3f;
            SCH40[2] = 0x46;
            SCH40[3] = 0xb4;
            SCH40[4] = 0x00;
            
//          give_buffer = false;            
            transmission_done=false;
            
        }
        
        void head_pointer(TM_list * ptr){
            list_ptr = ptr ;
            type1_frame_flag = true;
            type0_frame_flag = true;
            make_DataStream_flag = true;
            transmit_data_flag = true;
            transmission_done=false;
            adf_not_SDcard();
        }
        
        unsigned char convoluted_frame[270];                    
                    
        Convolution ConvObj;
        
        void convolution (unsigned char * ptr){
            
            ConvObj.convolutionEncode(ptr, convoluted_frame);
            ConvObj.convolutionEncode(ptr + 67, convoluted_frame + 135);
        }
        
        unsigned char interleave_data[2][144];                  //initialize to zero how;
        
        bool make_DataStream_flag;
        
        int make_DataStream(){
            static bool state = true;
            static int counter = 0;
            static unsigned char * ptr;
            static bool flag = false;
            
            if(make_DataStream_flag){
                data_number();
                state = true;
                counter = 0;
                flag = false;
                make_DataStream_flag = false;
            }
            
            if(state){
                    
                if(counter < type0_no){
                    ptr = type0_frame(); 
                    flag = true;    
                
                }
            
                else if(counter < total_frames ){
                    ptr = type1_frame();
                    flag = true;
                }
                
                counter++;  
                
            }
            
            state = !state;
            
            if (flag){
//              cout<<"i m here";
                
//              printf("------inside convolution\r\n");
                convolution(ptr);
//              printf("-------out of convolution\n");
                interleave(convoluted_frame,interleave_data[0]);
                interleave(convoluted_frame+ 135,interleave_data[1]);
//              printf("completed intrleave\n");
                flag = false;
                
            }
            
                    
            int temp =  (state == false) ? 0 : 1 ;
    
            return temp;
            
        }
        
        //112 bytes - half rolling buffer
        bool transmit_data_flag;            
            
        void transmit_data(unsigned char * transmit , bool * last_buffer){
            static int Tframe_counter = 0;                                  //contains the number of Tframes in a segment had been written  
            static int EOS_counter = 0;                                     //count no of byres of eos have been weitten in the buffer
            static int Sframe_Counter = 0;
            static int SCH40_counter = 0;
            static int string_space_counter = 0;
            static int FCCH80_counter = 0;
            int rolling_buffer_counter = 0;                                 //maximum it can be 1152 bits
            static bool Sframe_flag = true;
            static bool new_Tframe_flag = false;
            static bool FCCH80_flag = false;
            static bool data_flag = false;
            static int i;
            static bool repete_data_flag = false;
            static int segment_counter = 0;
            static bool diff_enc_flag = false;
                
                if(transmit_data_flag){
                    rolling_buffer_counter = 0;
                    Sframe_Counter = 0;
                    SCH40_counter = 0;
                    FCCH80_counter = 0;
                    Tframe_counter = 0;
                    EOS_counter = 0;
                    segment_counter = 0;
                    string_space_counter = 0;
                    
                    Sframe_flag = true;
                    new_Tframe_flag = false;
                    repete_data_flag = false;
                    data_flag = false;
                    FCCH80_flag = false;
                    transmit_data_flag = false;
                    diff_enc_flag = false;
                }
                
                for(rolling_buffer_counter = 0 ; rolling_buffer_counter<112 ; rolling_buffer_counter++){
                    
                    if(diff_enc_flag){
                        transmit[rolling_buffer_counter] = 0;
                        continue;
                    }
                    
                    if(Sframe_flag){
                        transmit[rolling_buffer_counter] = S_frame[Sframe_Counter++];
                        
                        if(Sframe_Counter == 48){
//                          printf("sframe quit\n");
                            Sframe_Counter = 0;
                            Sframe_flag = false;
                            new_Tframe_flag =true;
                        }
                        
                    }
                
                    else if(new_Tframe_flag){
                        transmit[rolling_buffer_counter] = SCH40[SCH40_counter++];      
                        
                        if(SCH40_counter == 5 ){
                            SCH40_counter = 0;
                            new_Tframe_flag = false;
//                          printf("new Tframe flag   quit\n");
//                          data_flag = (Tframe_counter == 38)? false : true; 
//                          put_F = !data_flag;
                            
                            repete_data_flag = (Tframe_counter == SEGMENT_SIZE -1)?true:false;
                            data_flag   =  !repete_data_flag;   
                            
                        }

                    }
                    
                    else if(data_flag){
                        
                        if(!string_space_counter  ){
                            i = make_DataStream();  
                        }
                        
                        transmit[rolling_buffer_counter] = interleave_data[i][string_space_counter++];
                        if(string_space_counter == 144){
//                          printf("data_flag   quit\n");
                            string_space_counter = 0;
                            FCCH80_flag = true;
                            data_flag = false;
                        }
                        
                    }
                    
                    else if(repete_data_flag){
                        transmit[rolling_buffer_counter]  = interleave_data[i][string_space_counter];;
                        if(++string_space_counter == 144){
                            repete_data_flag = false;
                            FCCH80_flag = true;
                            string_space_counter = 0;
//                          cout<<"repete_data_flag quit\n";
                        }
                    }
                    
                    else if(FCCH80_flag){
                        
                            transmit[rolling_buffer_counter] = FCCH80[FCCH80_counter++];
//                          cout<<FCCH80_counter;
                            if(FCCH80_counter == 10){
//                              printf("FCCH80   quit\n");
                                FCCH80_counter = 0;
                                FCCH80_flag = false;
                                
                                if(++Tframe_counter != SEGMENT_SIZE)
                                    new_Tframe_flag =  true;
                                    
                            }       
                
                    }
                    
                    
                
                    else if(Tframe_counter == SEGMENT_SIZE){    
                        
                        transmit[rolling_buffer_counter] = EoS[EOS_counter++];
                        
                        if(EOS_counter == 120){
                            diff_enc_flag = true; 
                            Tframe_counter = 0;
                            EOS_counter = 0;
                            
                            if(++segment_counter == segment_no){
//                              cout<<"transmit_counter = "<<++transmit_counter;
                                *last_buffer = true;
                                break; 
                                
                            }
                            else{
                                Sframe_flag = true;
                                continue;
                            }
                            
                        }
                        continue;
                    }                   
                                
                }
                
            
                
                differential_encode(transmit,112);

                if(diff_enc_flag){
                    diff_prev = 0;
                    diff_enc_flag = false;
                    Sframe_flag = true;
                    
                }       
                
        }
    
}snd_tm;