//without reset feature , with state checks.
InterruptIn IRQ(ADF_IRQ);
Ticker ticker;

bool sent_tmfrom_SDcard;
bool loop_on;
bool ADF_off;
bool buffer_state;
bool finish_write_data;
uint8_t signal = 0x00;
unsigned char bbram_buffer[66]={0x19,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0xF4,0xC2,0x10,0xC0,0x00,0x30,0x31,0x07,0x00,0x01,0x00,0x7F,0x00,0x0B,0x37,0x00,0x00,0x40,0x0C,0x00,0x05,0x00,0x00,0x18,0x12,0x34,0x56,0x10,0x10,0xC4,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00};

//int initialise_card();
//int disk_initialize();

#define bbram_write {\
     SPI_mutex.lock();\
    gCS_ADF=0;\
    spi.write(0xB0);\
    wait_us(300);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    for(int i=0;i<66;i++){\
        spi.write(bbram_buffer[i]);\
    }\
    gCS_ADF=1;\
    SPI_mutex.unlock();\
}
//------------------------------------------------------------------------
// state checking functions
//bool assrt_phy_off( int, int, int);
//bool assrt_phy_on( int,int,int);
//bool assrt_phy_tx(int,int,int);

#define START_ADDRESS 0x020;
#define MISO_PIN PTE3
/**************Defining Counter Limits**************/
#define THRS 20
#define STATE_ERR_THRS 20
#define PHY_OFF_EXEC_TIME 300
#define PHY_ON_EXEC_TIME 300
#define PHY_TX_EXEC_TIME 600
/******DEFINING COMMANDS*********/
#define CMD_HW_RESET 0xC8
#define CMD_PHY_ON 0xB1
#define CMD_PHY_OFF 0xB0
#define CMD_PHY_TX 0xB5
#define CMD_CONFIG_DEV 0xBB

#define check_status {\
    unsigned char stat=0;\
    gCS_ADF=0;\
    spi.write(0xFF);\
    stat = spi.write(0xFF);\
    gCS_ADF=1;\
    status = stat;\
}

// all three arguments are int
#define assrt_phy_off(return_this) {\
    int cmd_err_cnt = 0;\
    int spi_err_cnt = 0;\
    int state_err_cnt = 0;\
    for(int i = 0 ; i < 40 ;i++){\
        check_status;\
        if(status == 0xB1){\
            return_this = 0;\
            break;\
        }\
        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){\
            return_this = 1;\
            break;\
        }\
        else if(state_err_cnt>STATE_ERR_THRS){\
            return_this = 1;\
            break;\
        }\
        else if( (status & 0xA0) == 0xA0 ){\
            gCS_ADF=0;\
            spi.write(CMD_PHY_OFF);\
            gCS_ADF=1;\
            wait_us(PHY_OFF_EXEC_TIME);\
            state_err_cnt++;\
        }\
        else if(status&0x80==0x00){\
            wait_ms(5);\
            spi_err_cnt++;\
        }\
        else {\
            wait_ms(1);\
            cmd_err_cnt++;\
        }\
    }\
}


//#define assrt_phy_on(cmd_err_cnt, spi_err_cnt, state_err_cnt, return_this){\
//    status=check_status();\
//        if((status&0x1F)==0x12){\
//            return 0;\
//        }\
//        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){\
//            return 1;\
//        }\
//        else if(state_err_cnt>STATE_ERR_THRS){\
//            return 1;\
//        }\
//        else if((status&0xA0)==0xA0){\
//            cs_adf=0;\
//            spi.write(0xB1);\
//            cs_adf=1;\
//            wait_us(PHY_ON_EXEC_TIME);\
//            return assrt_phy_on(cmd_err_cnt,spi_err_cnt,state_err_cnt+1);\
//        }\
//        else if(status&0x80==0x00){\
//            wait_ms(5);\
//            //Error: SPI=0 Not ready CMD= Dont care
//            return assrt_phy_on(cmd_err_cnt,spi_err_cnt+1,state_err_cnt);\
//        }\
//        else{\
//            if(status&0xA0==0x80){\
//            wait_ms(1);\
//            //Error: Command Not ready SPI Ready cmd_err_cnt is a global variable
//            return assrt_phy_on(cmd_err_cnt+1,spi_err_cnt,state_err_cnt);\
//            }\
//        }\
//}




#define initial_adf_check {\
    spi.write(CMD_PHY_OFF);\
    int tempReturn = 0;\
    bool flag = false;\
    while( hw_reset_err_cnt < 2 ){\
        assrt_phy_off( tempReturn);\
        if( !tempReturn ){\
            bbram_write;\
            bbram_flag=1;\
            flag = true;\
            break;\
        }\
        else{\
            hardware_reset(0);\
            hw_reset_err_cnt++;\
            gPC.puts("Resetting hardware\r\n");\
        }\
    }\
    if( flag == false ){\
        gPC.puts("Seems to be SPI problem\r\n");\
    }\
    assrt_phy_off(tempReturn);\
    if(!bbram_flag){\
        bcn_flag=1;\
     }\
}

unsigned char status =0;
unsigned int cmd_err_cnt=0;
unsigned int state_err_cnt=0;
unsigned int miso_err_cnt=0;
unsigned int hw_reset_err_cnt=0;
bool bcn_flag=0;
bool bbram_flag=0;

//bool assrt_phy_off(int cmd_err_cnt,int spi_err_cnt,int state_err_cnt){
//    status=check_status();
//        if(status==0xB1){
//            return 0;
//        }
//        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){
//            return 1;//You need to Reset the hardware
//        }
//        else if(state_err_cnt>STATE_ERR_THRS){
//            return 1;//Again reset the hardware
//        }
//        else if((status&0xA0)==0xA0){  //If Status' first three bit ore 0b1X1 =>SPI ready, Dont care interrupt and CMD Ready.
//            cs_adf=0;
//            spi.write(CMD_PHY_OFF);        //CMD_PHY_OFF=0xB0
//            cs_adf=1;
//            wait_us(PHY_OFF_EXEC_TIME);// Typical = 24us  We are giving 300us 
//            return assrt_phy_off(cmd_err_cnt,spi_err_cnt,state_err_cnt+1);
//        }
//        else if(status&0x80==0x00){
//            wait_ms(5);
//            //Error: SPI=0 Not ready CMD= Dont care
//            return assrt_phy_off(cmd_err_cnt,spi_err_cnt+1,state_err_cnt);
//        }
//        else {//if(status&0xA0==0x80){
//            wait_ms(1);
//            //Error: Command Not ready SPI Ready cmd_err_cnt is a global variable
//            return assrt_phy_off(cmd_err_cnt+1,spi_err_cnt,state_err_cnt);
//        }
//}

//bool assrt_phy_on(int cmd_err_cnt,int spi_err_cnt,int state_err_cnt){
//    status=check_status();
//        if((status&0x1F)==0x12){
//            return 0;
//        }
//        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){
//            return 1;//You need to Reset the hardware
//        }
//        else if(state_err_cnt>STATE_ERR_THRS){
//            return 1;//Again reset the hardware
//        }
//        else if((status&0xA0)==0xA0){  //If Status' first three bit ore 0b1X1 =>SPI ready, Dont care interrupt and CMD Ready.
//            cs_adf=0;
//            spi.write(0xB1);        //CMD_PHY_OFF
//            cs_adf=1;
//            wait_us(PHY_ON_EXEC_TIME);// Typical = 24us  We are giving 300us 
//            return assrt_phy_on(cmd_err_cnt,spi_err_cnt,state_err_cnt+1);
//        }
//        else if(status&0x80==0x00){
//            wait_ms(5);
//            //Error: SPI=0 Not ready CMD= Dont care
//            return assrt_phy_on(cmd_err_cnt,spi_err_cnt+1,state_err_cnt);
//        }
//        else{
//            if(status&0xA0==0x80){
//            wait_ms(1);
//            //Error: Command Not ready SPI Ready cmd_err_cnt is a global variable
//            return assrt_phy_on(cmd_err_cnt+1,spi_err_cnt,state_err_cnt);
//            }
//        }
//}


// bool assrt_phy_tx(int cmd_err_cnt,int spi_err_cnt,int state_err_cnt){
//    status=check_status();
//        if((status & 0x1F) == 0x14){
//            return 0;
//        }
//        else if(cmd_err_cnt>THRS||spi_err_cnt>THRS){
//            return 1;//You need to Reset the hardware
//        }
//        else if(state_err_cnt>STATE_ERR_THRS){
//            return 1;//Again reset the hardware
//        }
//        else if((status&0xA0)==0xA0){  //If Status' first three bit ore 0b1X1 =>SPI ready, Dont care interrupt and CMD Ready.
//            cs_adf=0;
//            spi.write(0xB1);        //CMD_PHY_OFF
//            cs_adf=1;
//            wait_us(PHY_TX_EXEC_TIME);// Typical = 24us  We are giving 300us 
//            return assrt_phy_tx(cmd_err_cnt,spi_err_cnt,state_err_cnt+1);
//        }
//        else if(status&0x80==0x00){
//            wait_ms(1);
//            //Error: SPI=0 Not ready CMD= Dont care
//            return assrt_phy_tx(cmd_err_cnt,spi_err_cnt+1,state_err_cnt);
//        }
//        else {
//            if(status&0xA0==0x80){
//            wait_us(50);
//            //Error: Command Not ready SPI Ready cmd_err_cnt is a global variable
//            return assrt_phy_tx(cmd_err_cnt+1,spi_err_cnt,state_err_cnt);
//            }
//        }
//}

bool hardware_reset(int bcn_call){
    for(int i= 0; i < 20 ; i++){
        gCS_ADF=0;
        spi.write(CMD_HW_RESET);
        gCS_ADF=1;
        wait_ms(2);// Typically 1 ms
        int count=0;
        int temp_return = 0;
        while(count<10 && miso_err_cnt<10){      
            if(MISO_PIN){
                assrt_phy_off(temp_return);
                if(!temp_return){
                    return 0;
                }
                count++;
            }
            else{
                wait_us(50);
                miso_err_cnt++;
            }
        }
    }
    return 1;
}

//bool hardware_reset(int bcn_call){
//    if (bcn_call>20){//Worst Case 20seconds will be lost !
//        return 1;
//    }
//    int count=0;
//    cs_adf=0;
//    spi.write(CMD_HW_RESET);
//    cs_adf=1;
//    wait_ms(2);// Typically 1 ms
//    while(count<10 && miso_err_cnt<10){      
//        if(MISO_PIN){
//            int temp_return;
//            assrt_phy_off(0,0,0,temp_return);
//            if(!temp_return){
//                break;
//            }
//            count++;
//        }
//        else{
//            wait_us(50);
//            miso_err_cnt++;
//        }
//    }
//    if(count==10 ||miso_err_cnt==10){
//        return hardware_reset(bcn_call+1);  
//    }
//    else
//        return 0;
//    
//}




//void initial_adf_check(){
//        spi.write(CMD_PHY_OFF); //0xB0
//        while(hw_reset_err_cnt<2){
//        
//            if(!assrt_phy_off(0,0,0)){  //assrt_phy_off () returns 0 if state is PHY_OFF , returns 1 if couldn't go to PHY_OFF
//                bbram_write();
//                bbram_flag=1;
//                break;
//            }
//            else{
//                hardware_reset(0);  // Asserts Hardware for 20sec(20times). PHY_OFF for 20,000 times
//                hw_reset_err_cnt++;
//            }
//        }
//        assrt_phy_off(0,0,0);// We actually do not need this but make sure "we do not need this"
//        if(!bbram_flag){
//        //Switch to beacon
//            bcn_flag=1;
//         }
//}

//for reseting the transmission call assert function after b5 and b1. after b1 assert_phi_on and after b5 assert_phi_tx. 
//----------------------------------------------------------------------------

# define initiate {\
    SPI_mutex.lock();\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x08);\
    spi.write(0x14);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x08);\
    spi.write(0x15);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x24);\
    spi.write(0x20);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x37);\
    spi.write(0xE0);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x36);\
    spi.write(0x70);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0x09);\
    spi.write(0x39);\
    spi.write(0x10);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xBB);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    SPI_mutex.unlock();\
}


#define write_data {\
    SPI_mutex.lock();\
    gCS_ADF=0;\
    spi.write(0x0B);\
    spi.write(0x36);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    if(buffer_state){\
        spi.write(0x18);\
        spi.write(0x20);\
        for(unsigned char i=0; i<112;i++){\
            spi.write(buffer_112[i]);\
        }\
    }\
    else{\
        spi.write(0x18);\
        spi.write(0x90);\
        for(unsigned char i=0; i<112;i++){\
            spi.write(buffer_112[i]);\
        }\
    }\
    gCS_ADF=1;\
    SPI_mutex.unlock();\
    buffer_state = !buffer_state;\
    if(last_buffer){\
        finish_write_data = true;\
        gPC.puts("adf_off\r\n");\
    }\
}
 

void check(){   
    if(IRQ){
        gCOM_MNG_TMTC_THREAD->signal_set(signal);
    }
}
  

#define send_data {\
    if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card();\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    write_data;\
    if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card();\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    write_data;\
    if(sent_tmfrom_SDcard){\
        send_tm_from_SD_card();\
    }else{\
        snd_tm.transmit_data(buffer_112,&last_buffer);\
    }\
    SPI_mutex.lock();\
    gCS_ADF=0;\
    spi.write(0xB1);\
    gCS_ADF=1;\
    wait_us(300);\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    gCS_ADF=0;\
    spi.write(0xB5);\
    gCS_ADF=1;\
    wait_us(300);\
    gCS_ADF=0;\
    spi.write(0xFF);\
    spi.write(0xFF);\
    gCS_ADF=1;\
    SPI_mutex.unlock();\
    ticker.attach_us(&check,32000);\
}
    
    
    
#define adf_SND_SDCard {\
    buffer_state = true;\
    last_buffer = false;\
    loop_on = true;\
    ADF_off = false;\
    sent_tmfrom_SDcard = true;\
    signal = COM_MNG_TMTC_SIGNAL_ADF_SD;\
    start_block_num = starting_add;\
    end_block_num = ending_add;\
    initial_adf_check;\
    initiate;\
    send_data;\
    while(loop_on){\
        /*led2=!led2;*/\
        gCOM_MNG_TMTC_THREAD->signal_wait(COM_MNG_TMTC_SIGNAL_ADF_SD);\
        if(ADF_off){\
            SPI_mutex.lock();\
            ticker.detach();\
            gCS_ADF=0;\
            spi.write(0xB1);\
            gCS_ADF=1;\
            SPI_mutex.unlock();\
            gPC.puts("transmission done\r\n");\
            loop_on = false;\
        }else{\
            write_data;\
            if(!last_buffer)\
            send_tm_from_SD_card();\
        }\
    }\
}
    
void read_TC(Base_tc* TC_ptr){
    gPC.puts("Inside sd card sending\r\n");
    unsigned char service_subtype = 0;
    uint64_t starting_add  = 0, ending_add = 0;
    service_subtype = (TC_ptr->TC_string[2])&0x0f;
    starting_add =  (TC_ptr->TC_string[5]) +  ( (TC_ptr->TC_string[4])<<8 ) + ( (TC_ptr->TC_string[3]) <<16);
    ending_add =  (TC_ptr->TC_string[8]) +  ( (TC_ptr->TC_string[7])<<8 ) + ( (TC_ptr->TC_string[6]) <<16);
    starting_add = 10; // for now
    ending_add = 20;
//    adf_SND_SDCard(starting_add , ending_add);
    gPC.puts("sending from sd card\r\n");
    adf_SND_SDCard;
}

//Timeout ADF_non_responsive_timeout;
//bool ADF_non_responsive_flag = false;
//
//void ADF_non_responsive_fun(){
//    ADF_non_responsive_flag = true;
//    gCOM_MNG_TMTC_THREAD->signal_set(signal);
//}

void configure_adf(){
    finish_write_data = false;
    buffer_state = true;
    last_buffer = false;
    loop_on = true;
    ADF_off = false;
    /*initial adf check*/
    initial_adf_check;
    gPC.puts("initial adf check\r\n");
    initiate;
//    gPC.puts("initiate done\r\n");
    gPC.puts("adf configured\r\n");
}

void adf_not_SDcard(){
    sent_tmfrom_SDcard = false;
    configure_adf();
    signal = COM_MNG_TMTC_SIGNAL_ADF_NSD;
    send_data;
    
//    gPC.puts("Inside adf transmission\r\n");
//    ADF_non_responsive_timeout.attach(&ADF_non_responsive_fun, 10);

    while(loop_on){
        gCOM_MNG_TMTC_THREAD->signal_wait(COM_MNG_TMTC_SIGNAL_ADF_NSD);
//        if( ADF_non_responsive_flag == false ){
            if(finish_write_data){
                if(ADF_off){
                    SPI_mutex.lock();
                    ticker.detach();
        //            wait_ms(35); 
                    gCS_ADF=0;
                    spi.write(0xB1);
                    gCS_ADF=1;
                    SPI_mutex.unlock();
                    loop_on = false;
                    gPC.puts("Transmission done\r\n");
                }
                else{
                    ADF_off = true;
                }
            }else{   
                write_data;
                snd_tm.transmit_data(buffer_112,&last_buffer);
            }
//        }
//        else{
//            gPC.puts("ADF non responsive\r\n");
//            break;
//        }
    }
}
 