void adf_not_SDcard();
 
#define S_FRAME_SIZE 48
#define ISR 30
#define TM_FRAME_SIZE 134           //in bytes
#define T_FRAME_SIZE 159
#define EOS_SIZE 120
#define MAX_ADF_LEN 65535                    

const unsigned char S_frame[] = {0x46,0x9D,0xFB,0xF0,0xD2,0xBA,0x89,0xE4,0x46,0x9D,0xFB,0xF0,0xD2,0xBA,0x89,0xE4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
const unsigned char EoS[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x1A,0x77,0xEF,0xC3,0x4A,0xEA,0x27,0x91,0x1A,0x77,0xEF,0xC3,0x4A,0xEA,0x27,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x1A,0x77,0xEF,0xC3,0x4A,0xEA,0x27,0x91,0x1A,0x77,0xEF,0xC3,0x4A,0xEA,0x27,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
const unsigned char FCCH80[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
const unsigned char SCH40[] = {0x0a,0x3f,0x46,0xb4,0x00};

class SND_TM{
    
    Base_tm * head_ptr;   
    
//    transmit data variables
    unsigned char Tframe_c;                                      //_c represents counter, counts Tframe written in a segment
    unsigned char EOS_c;                                         //count no of bytes of eos have been weitten in the rolling buffer
    unsigned char Sframe_c;                                      //count no of bytes of Sframe have been weitten in the rolling buffer
    unsigned char SCH40_c;                                       //count no of bytes of SCH40 have been weitten in the rolling buffer
    unsigned char data_c;
    unsigned char FCCH80_c;
    unsigned char RB_c;                                          //rolling buffer counter
    unsigned char segment_c;                                    //counts the numver of segments sent
    unsigned char MAX_SEGMENT;
    bool Sframe;                                                //Sframe = 1bit of CF1
    bool SCH40_f;
    bool FCCH80_f;
    bool data_f;
    bool transmit_data_f;
    bool eos_f;
    bool junk_f;

    
//  type 1 frame

    Base_tm *T0F_pointer ;
    
    int diff_prev;
    void differential_encode(unsigned char* ptr, int length){
        for(int i=0; i<length;i++){
            unsigned char s = ptr[i] , t;
            t = s ^ (s >> 1);
            (diff_prev == 0) ? t=t^0x00 : t=t^0x80 ;
            diff_prev = int(s & 0x01);
            ptr[i] = t;
        }
    }    
    
    int type0_no;                                               //number of type zero frames
    int type1_no;                                               
    int total_frames;                                           //number of type one packe (TMP)
    int SEGMENT_NO;                                             //number of type one packe (TMP)
    void inline data_number(){
        int type1_frame_no;
        Base_tm*head = head_ptr;
        type0_no = 0;
        type1_no = 0;
        while(head != NULL){
            switch( GETshort_or_long_tm(head->fields) ){
                case 0:
                    type0_no++;
                    break;
                case 1:
                    type1_no++;
                    break;
            }
            head=head->next_TM;
        }
        type1_frame_no = ( type1_no % 10 == 0 )? (type1_no / 10) : ( (type1_no / 10) + 1);
        total_frames = type0_no + type1_frame_no ;
        SEGMENT_NO = (total_frames*2 % (ISR) == 0) ? ( total_frames*2/(ISR) ) : (total_frames*2/(ISR) + 1);            //subtracting 1 since the last SCH40_f is not detected
    }
    
#define next_type_structure(ptr){\
        unsigned char temp = GETshort_or_long_tm(ptr->fields);\
        if((temp == 0) && (ptr->next_TM != NULL) ){\
            do{\
                ptr = ptr->next_TM;\
                temp =  GETshort_or_long_tm(ptr->fields);\
            }\
            while(temp == 1 && ptr->next_TM != NULL);\
            if(temp == 1){\
                ptr = NULL;\
                break;\
            }\
        }\
        else if((temp == 1) && (ptr->next_TM != NULL)){\
            do{\
                ptr = ptr->next_TM;\
                temp = GETshort_or_long_tm(ptr->fields);\
            }\
            while(temp == 0 && ptr->next_TM != NULL);\
            if(temp == 0){\
                ptr NULL;\
                break;\
            }\
        }\
        else{\
            ptr NULL;\
        }\
    }
    
    /*
        brief:      take input type 0  or  1 and return the address of the first node in the list that have that type
        parameter:  type 0 or 1
        return:     pointer of the first node having same type      
    */
//    Base_tm* first_type_structure(int type){
//        Base_tm* temp_ptr = head_ptr;
//        if(type == 0){
//            while(GETshort_or_long_tm(temp_ptr->fields) == 1){
//                temp_ptr = temp_ptr->next_TM;
//                if(temp_ptr == NULL){
//                    return NULL ;
//                }       
//            }   
//        }
//        else if(type == 1){
//            while(GETshort_or_long_tm(temp_ptr->fields) == 0){
//                temp_ptr = temp_ptr->next_TM;
//                if(temp_ptr == NULL){
//                    return NULL;    
//                }   
//            }   
//        }   
//        return temp_ptr;
//    }


    #define first_type_structure( type,return_ptr) {\
        Base_tm* temp_ptr = head_ptr;\
        if(type == 0){\
            while(GETshort_or_long_tm(temp_ptr->fields) == 1){\
                temp_ptr = temp_ptr->next_TM;\
                if(temp_ptr == NULL){\
                    return_ptr = NULL ;\
                }\
            }\
        }\
        else if(type == 1){\
            while(GETshort_or_long_tm(temp_ptr->fields) == 0){\
                temp_ptr = temp_ptr->next_TM;\
                if(temp_ptr == NULL){\
                    return_ptr = NULL;\
                }\
            }\
        }\
        return_ptr = temp_ptr;\
    }


    
    Base_tm *T1F_pointer ;
    int T1F_counter;
    unsigned char TMframe_type1[TM_FRAME_SIZE];
    bool type1_frame_flag;                                               //should be true for every new list
    
    #define type1_frame(ptr){\
        int i=4;\
        if(type1_frame_flag){\
            first_type_structure(1,T1F_pointer);\
            T1F_counter = 0;\
            type1_frame_flag = false;\
        }\
        for(i = 4 ; (i < 134) && (T1F_pointer != NULL) ; i++){\
             TMframe_type1[i] = T1F_pointer->TM_string[T1F_counter];\
              if(T1F_counter++ == 12){\
                T1F_counter = 0;\
                next_type_structure(T1F_pointer);\
              }\
        }\
        TMframe_type1[0] = 1<<7 + ( (i-4)/10 )<<3;\
        TMframe_type1[3] = crc16_gen(TMframe_type1,3);\
        if(T1F_pointer == NULL && i>12){\
            for( ; i < 134 ; i++){\
                TMframe_type1[i] = TMframe_type1[i-13];\
            }\
        }\
    }
    
    
//    unsigned char * type1_frame(){
//        int i=4;
//        if(type1_frame_flag){
//            T1F_pointer = first_type_structure(1);
//            T1F_counter = 0;
//            type1_frame_flag = false;
//        }
//        for(i = 4 ; (i < 134) && (T1F_pointer != NULL) ; i++){
//             TMframe_type1[i] = T1F_pointer->TM_string[T1F_counter];
//              if(T1F_counter++ == 12){
//                T1F_counter = 0;
//                T1F_pointer = next_type_structure(T1F_pointer);
//              }
//        }
//        // header
//        TMframe_type1[0] = 1<<7 + ( (i-4)/10 )<<3;                          //( (i-4)/10 ) gives number of packets in the frame
//            //insert time ;
//        TMframe_type1[3] = CRC::crc16_gen(TMframe_type1,3);
//        //end header
//        if(T1F_pointer == NULL && i>12){
//            for( ; i < 134 ; i++){                                          //repeating ;ast packet to fill up the extra space
//                TMframe_type1[i] = TMframe_type1[i-13]; 
//            }
//        }
//        return TMframe_type1;
//    }
    
    bool type0_frame_flag;
    
    
 #define type0_frame(ptr){\
        if(type0_frame_flag){\
            first_type_structure(0,T0F_pointer);\
            type0_frame_flag = false;\
        }\
        else {\
            next_type_structure(T0F_pointer);\
        }\
        ptr =  T0F_pointer->TM_string;\
    }
    
    
//    unsigned char* type0_frame(){
//        if(type0_frame_flag){
//            T0F_pointer = first_type_structure(0);  
//            type0_frame_flag = false;
//        }            
//        else {
//            T0F_pointer = next_type_structure(T0F_pointer);
//        }
//        return T0F_pointer->TM_string;
//    }
     
    unsigned char convoluted_frame[270];                    
    Convolution ConvObj2;
    void convolution (unsigned char * ptr){
        ConvObj2.convolutionEncode(ptr, convoluted_frame);
        ConvObj2.convolutionEncode(ptr + 67, convoluted_frame + 135);
    }
        
        
    unsigned char interleave_data[2][144];                 
    unsigned char DS_index;
    bool DS_state;
    int DS_counter;
    bool DS_f;
    bool make_DataStream_f;
//    #define make_DataStream {\
//        unsigned char* ptr;\
//        if(make_DataStream_f == true){\
//            DS_state = true;\
//            DS_counter = 0;\
//            DS_f = false;\
//            make_DataStream_f = false;\
//        }\
//        if(DS_state){\
//            if(DS_counter < total_frames-type0_no){\
//                type1_frame(ptr); \
//                DS_f = true;\
//            }\
//            else if(DS_counter < total_frames ){\
//                type0_frame(ptr);\
//                DS_f = true;\
//            }\
//            DS_counter++;\
//        }\
//        DS_state = !DS_state;\
//        if (DS_f){\
//            DS_f = false;\
//            convolution(ptr);\
//            interleave(convoluted_frame,interleave_data[0]);\
//            interleave(convoluted_frame+ 135,interleave_data[1]);\
//        }\
//        DS_index = (DS_state==true)?1:0;\
//    }
    
    public:
        
        bool reset_adf;
        SND_TM(){
            MAX_SEGMENT = (MAX_ADF_LEN-T_FRAME_SIZE)/( S_FRAME_SIZE + ISR*T_FRAME_SIZE);                //(max length - eos size)/(sframe length + tFrameLength*ISR)
//            cout<<int(MAX_SEGMENT)<<endl;
        }
        
 
        
        void head_pointer(Base_tm* ptr){
            head_ptr = ptr ;
            type1_frame_flag = true;
            type0_frame_flag = true;
            make_DataStream_f = true;
            transmit_data_f = true;
            diff_prev = 0;
            data_number();
//            make_DataStream;
            gPC.putc('z');
        }
        
         
        void inline transmit_data(unsigned char * transmit , bool * last_buffer){
            if(transmit_data_f){
                RB_c = 0;
                Sframe_c = 0;
                SCH40_c = 0;
                FCCH80_c = 0;
                Tframe_c = 0;
                EOS_c = 0;
                segment_c = 0;
                data_c = 0;
                
                Sframe = true;
                SCH40_f = false;
                data_f = false;
                FCCH80_f = false;
                transmit_data_f = false;
                reset_adf = false;
                *last_buffer = false;
            }
            
            for(RB_c = 0 ; RB_c<112 ; RB_c++){
                
                if(junk_f){
                    transmit[RB_c] = 0xaa;
                }
                
                if(Sframe){
                    transmit[RB_c] = S_frame[Sframe_c++];
                    if(Sframe_c == 48){
 //                     printf("exit s frame\n");
                        Sframe_c = 0;
                        Sframe = false;
                        SCH40_f =true;
                    }
                    continue;
                }
//                
                if(SCH40_f){
                    transmit[RB_c] = SCH40[SCH40_c++];      
                    if(SCH40_c == 5 ){
                        SCH40_c = 0;
                        SCH40_f = false; 
                        data_f = true; 
//                      printf("exit SCH40 frame\n");
                    }
                    continue;
                }
//                    
                if(data_f){
                    transmit[RB_c] = interleave_data[DS_index][data_c++];
                    if(data_c == 144){
//                        make_DataStream;
                        data_c = 0;
                        FCCH80_f = true;
                        data_f = false;
//                        printf("exit Data\n");
                    }
                    continue;
                }

                if(FCCH80_f){
                    transmit[RB_c] = FCCH80[FCCH80_c++];
                    if(FCCH80_c == 10){
                        FCCH80_c = 0;
                        FCCH80_f = false;
//                        printf("exit FCCH80\n");
                        if(++Tframe_c != ISR)
                            SCH40_f =  true;
                        else{
                            Tframe_c = 0;
                            segment_c++;
                            if(segment_c == SEGMENT_NO||segment_c == MAX_SEGMENT)
                                {eos_f = true;}
                            else{
                                Sframe = true;
                            }
                        }
                    }
                    continue;
                }       
                
                if(eos_f){    
                    transmit[RB_c] = EoS[EOS_c++];
                    if(EOS_c == EOS_SIZE){
                        EOS_c = 0;
                        eos_f = false;
 //                     printf("exit EOS\n");
                        if(segment_c == MAX_SEGMENT){
                            segment_c = 0;
                            SEGMENT_NO = SEGMENT_NO - MAX_SEGMENT;
                            reset_adf = true;
                            Sframe = true;
                        }else{
                            *last_buffer = true;
                        }
                        junk_f = true;
                    }
                    continue;
                }                   
            }
        
            differential_encode(transmit,112);
            if(reset_adf == true){
                diff_prev = 0;
                junk_f = false;
            }
                
        }
        
};
SND_TM snd_tm;