#include "mbed.h"
#include "TextLCD.h"


I2C i2c(p9, p10);
Serial pc(USBTX, USBRX); // tx, rx

//LCD EA DOGM162x-A
TextLCD lcd(p15, p16, p17, p18, p19, p21); // rs, e, d4-d7
 
BusOut leds(LED1, LED2, LED3, LED4);

int i;

int main() {

    char address;
    short xvalue;
    short yvalue;
    short zvalue;
    float f_xvalue,f_yvalue;
        
    char data[6];
    
    lcd.printf("Bosch BMA020\nAccelerometer");
    
    wait (2);
    lcd.cls();
        
    while(1) {
        
        address = 0x70;             // write address
        data[0] = 0x02;             // register address
        i2c.write(address, data, 1);
        address = 0x71;             // read address, read 6 bytes automatically
        i2c.read(address, data, 6); 
        
        xvalue=data[0]>>6;
        xvalue+=(short)data[1]<<2;
        
        yvalue=data[2]>>6;
        yvalue+=(short)data[3]<<2;

        zvalue=data[4]>>6;
        zvalue+=(short)data[5]<<2;

        pc.printf("%4d%4d%4d\n", xvalue, yvalue, zvalue); // write to serial port (9600 Baud)
        
        xvalue<<=6;
        xvalue/=64;
        f_xvalue=xvalue;
        f_xvalue*=0.004;   
        
        yvalue<<=6;
        yvalue/=64;
        f_yvalue=yvalue;
        f_yvalue*=0.004;     
                                
        lcd.locate(0,0);
        lcd.printf("X=%+1.2f Y=%+1.2f", f_xvalue, f_yvalue);
                
        lcd.locate(0,1);
        lcd.printf("                ");
        if (data[1]<16)                     // visualize x value like spirit level device
        {
            lcd.locate(15-data[1],1);
            lcd.printf("O");
        }
        
        
       
        
        if (data[2]&&0x01) leds = 1 << data[3]+2; // neue Daten?

        wait (0.1);
    }
}
