#include "mbed.h"

DigitalOut myled(LED1);

DigitalOut t_out_0( PA_2 );
DigitalOut t_out_1( PA_3 );
DigitalOut t_out_2( PB_13 );
DigitalOut t_out_3( PA_10 );
DigitalOut t_out_4( PA_9 );
DigitalOut t_out_5( PA_8 );

DigitalIn rx_0( PC_9 );
DigitalIn rx_1( PC_8 );
DigitalIn rx_2( PB_6 );
DigitalIn rx_3( PB_4 );
DigitalIn rx_4( PB_5 );
DigitalIn rx_5( PB_7 );

I2C i2c(PB_9, PB_8);
const int addr = 0x10;  // Arduino addr. 0x08 is left-shifted by 1 to get 0x10

Serial pc( SERIAL_TX, SERIAL_RX );

int main() {
    
    rx_0.mode( PullDown );
    rx_1.mode( PullDown );
    rx_2.mode( PullDown );
    rx_3.mode( PullDown );
    rx_4.mode( PullDown );
    rx_5.mode( PullDown );
    
    char i2c_out[1];
    i2c_out[0] = 0xDD;
    char i2c_in[1];
    i2c_in[0] = 0x00;
    
    myled = 0;
    while(1) {
        
        int ret = i2c.write(addr, i2c_out, 1);
        pc.printf( "Write exit code: %d \r\n", ret );
        pc.printf( "Written byte: 0x%02X \r\n", i2c_out[0] );
                
        t_out_0.write( rx_0.read() );
        t_out_1.write( rx_1.read() );
        t_out_2.write( rx_2.read() );
        t_out_3.write( rx_3.read() );
        t_out_4.write( rx_4.read() );
        t_out_5.write( rx_5.read() );
        
        //wait( 0.5 );
        
        int loopback = i2c.read(addr, i2c_in, 1);
        pc.printf( "Read byte: 0x%02X \r\n\n", i2c_in[0] );
        
        if( i2c_in[0] == i2c_out[0] ) {
            myled = 1;
        }
    }
}