#include "mbed.h"
#include "dac2.h"

// DAC2 Pin Setup
// 12-bits, 1-channel (I2C1: PB7 = SDA, PB6 = SCL)
I2C i2c_dac2_1ch( PB_7, PB_6 );
DigitalOut dac2_1ch_addrsel( PB_5 );        // sets the A0 (LSB) address bit (use like chip select)

void dac2_init( void ) {
    i2c_dac2_1ch.frequency( 400000 );
    dac2_write( 0 );
}

void dac2_write( uint16_t val ) { // For MCP4725 12-bit DAC (values 0..4095)
    dac2_1ch_addrsel = 1;       // Assert A0
    
    char message[ 3 ];
    message[ 0 ] = 0x40;        // Write new value without saving to EEPROM
    message[ 1 ] = val / 16;
    message[ 2 ] = ( val % 16 ) << 4;
    
    i2c_dac2_1ch.write( ( 0x61 << 1 ), message, 3 );

    dac2_1ch_addrsel = 0;       // De-assert A0
}