// Project includes
#include "globals.h"
#include "hardware.h"
#include "map.h"
#include "graphics.h"
#include "speech.h"

// Functions in this file
int get_action (GameInputs inputs);
int check_button(GameInputs inputs);
int update_game (int action);
void draw_game (int init);
void draw_startScreen();
void init_main_map ();
int main ();
int buttonPressed1 = 0;
int buttonPressed2 = 0;
int buttonPressed3 = 0;

/**
 * The main game state. Must include Player locations and previous locations for
 * drawing to work properly. Other items can be added as needed.
 */
struct {
    int x,y;    // Current locations
    int px, py; // Previous locations
    int has_key;
    int health;
    int omni;
    int apples;
    int end;
} Player;

/**
 * Given the game inputs, determine what kind of update needs to happen.
 * Possbile return values are defined below.
 */
#define NO_ACTION 0
#define ACTION_BUTTON 1
#define MENU_BUTTON 2
#define GO_LEFT 3
#define GO_RIGHT 4
#define GO_UP 5
#define GO_DOWN 6
#define TALK 7
#define DOORFOUND 8

int get_action(GameInputs inputs)
{
    MapItem* itemNorth = get_north(Player.x,Player.y);
    MapItem* itemSouth = get_south(Player.x,Player.y);
    MapItem* itemEast = get_east(Player.x,Player.y);
    MapItem* itemWest = get_west(Player.x,Player.y);
    MapItem* itemHere = get_here(Player.x,Player.y);

    //pc.printf("%d " , itemEast);
    //pc.printf("%d " , itemEast -> walkable);
    //pc.printf("%f, %f ", inputs.ax, inputs.ay);
    
    if((itemEast->type == NPC || itemWest->type == NPC || itemNorth->type == NPC || itemSouth->type == NPC) && inputs.b2 == 0)
    {
        return TALK;    
    }
    if((itemEast->type == DOOR || itemWest->type == DOOR || itemNorth->type == DOOR || itemSouth->type == DOOR) && inputs.b2 == 0)
    {
        return DOORFOUND;    
    }
    else if((inputs.ay <= -0.2) && (itemNorth->walkable || Player.omni == 1))
    {
        return GO_UP;
    }
    else if((inputs.ay >= 0.2) && (itemSouth->walkable || Player.omni == 1))
    {
        return GO_DOWN;
    }
    else if((inputs.ax <= -0.2) && (itemWest->walkable || Player.omni == 1))
    {
        return GO_LEFT;
    }
    else if((inputs.ax >= 0.2) && (itemEast->walkable || Player.omni == 1))
    {
        return GO_RIGHT;
    }
    else
        return NO_ACTION;
}

int check_Button(GameInputs inputs)
{
    if(inputs.b1 == 0 && buttonPressed1 == 0)
    {
        buttonPressed1 = 1;
    }
    if(inputs.b1 == 1 && buttonPressed1 == 1)
    {
        Player.omni = !Player.omni;
        buttonPressed1 = 0;
        return 1;
    }
    if(inputs.b2 == 0 && buttonPressed2 == 0)
    {
        buttonPressed2 = 1;
    }
    if(inputs.b2 == 1 && buttonPressed2 == 1)
    {
        buttonPressed2 = 0;
        return 1;
    }
    if(inputs.b3 == 0 && buttonPressed3 == 0)
    {
        buttonPressed3 = 1;
    }
    if(inputs.b3 == 1 && buttonPressed3 == 1)
    {
        buttonPressed3 = 0;
        return 1;
    }          
}

void check_stuff()
{
    MapItem* itemHere = get_here(Player.x,Player.y);
    if(itemHere->type == APPLE)
    {
        deleteHere(Player.x,Player.y);
        Player.apples ++;   
    }
    else if(itemHere->type == POIAPPLE)
    {
        deleteHere(Player.x,Player.y);
        Player.health --;   
    }
    else if(itemHere->type == KEY)
    {
        deleteHere(Player.x,Player.y);
        Player.has_key = 1;   
    }
}


/**
 * Update the game state based on the user action. For example, if the user
 * requests GO_UP, then this function should determine if that is possible by
 * consulting the map, and update the Player position accordingly.
 * 
 * Return values are defined below. FULL_DRAW indicates that for this frame,
 * draw_game should not optimize drawing and should draw every tile, even if
 * the player has not moved.
 */
#define NO_RESULT 0
#define GAME_OVER 1
#define FULL_DRAW 2
int update_game(int action)
{
    // Save player previous location before updating
    Player.px = Player.x;
    Player.py = Player.y;
    
    // Do different things based on the each action.
    // You can define functions like "go_up()" that get called for each case.
    switch(action)
    {
        case GO_UP:
            Player.y = Player.y + 1; 
            break;
        case GO_LEFT:   
            Player.x = Player.x - 1; 
            break;            
        case GO_DOWN:   
            Player.y = Player.y - 1; 
            break;
        case GO_RIGHT:
            Player.x = Player.x + 1; 
            break;            
        case TALK:
            if(Player.apples == 0)
            {
                //talk to NPC
                speech("Hello there my","Young duck");
                speech("I can see you","are able to walk");
                speech("You see I have","a problem!");
                speech("My legs aren't","what they used to be");
                speech("Give me 5 apples","and I will grant");
                speech("You the key", "out of here");
                speech("Careful of",  "Poison apples!");
                add_apple(41,6);
                add_apple(41,7);
                add_apple(41,8);
                add_apple(41,9);
                add_apple(41,10);
                add_poiapple(45,5);
                add_poiapple(43,2);
                add_poiapple(47,8);
                add_poiapple(47,9);
                add_poiapple(48,9);
                add_poiapple(46,9);
                add_poiapple(41,5);
            }
            else if (Player.apples >= 5)
            {
                speech("Thank you little", "Duckling!");
                speech("Here is the key", "to the door!");
                add_key(46,1);
            }
            else
                speech("Where are the", "apples sir?");
            break;
        case DOORFOUND:
            {
                //open door
                if(Player.has_key == 0)
                {
                    speech("You don't have the key!","");    
                }
                else
                {
                    speech("You open the door", "and return safely home");
                    Player.end = 0;    
                }    
            }
        case MENU_BUTTON: break;
        default:        break;
    }
    return NO_RESULT;
}

/**
 * Entry point for frame drawing. This should be called once per iteration of
 * the game loop. This draws all tiles on the screen, followed by the status 
 * bars. Unless init is nonzero, this function will optimize drawing by only 
 * drawing tiles that have changed from the previous frame.
 */
void draw_game(int init)
{
    // Draw game border first
    if(init)
    {
        draw_border();
    }
    
    
    // Iterate over all visible map tiles
    for (int i = -5; i <= 5; i++) // Iterate over columns of tiles
    {
        for (int j = -4; j <= 4; j++) // Iterate over one column of tiles
        {
            // Here, we have a given (i,j)
            
            // Compute the current map (x,y) of this tile
            int x = i + Player.x;
            int y = j + Player.y;
            
            // Compute the previous map (px, py) of this tile
            int px = i + Player.px;
            int py = j + Player.py;
                        
            // Compute u,v coordinates for drawing
            int u = (i+5)*11 + 3;
            int v = (j+4)*11 + 15;
            
            // Figure out what to draw
            DrawFunc draw = NULL;
            if (i == 0 && j == 0) // Only draw the player on init
            {
                draw_player(u, v, Player.has_key);
                continue;
            }
            else if (x >= 0 && y >= 0 && x < map_width() && y < map_height()) // Current (i,j) in the map
            {
                MapItem* curr_item = get_here(x, y);
                MapItem* prev_item = get_here(px, py);
                if (init || curr_item != prev_item) // Only draw if they're different
                {
                    if (curr_item) // There's something here! Draw it
                    {
                        draw = curr_item->draw;
                    }
                    else // There used to be something, but now there isn't
                    {
                        draw = draw_nothing;
                    }
                }
            }
            else if (init) // If doing a full draw, but we're out of bounds, draw the walls.
            {
                draw = draw_wall;
            }

            // Actually draw the tile
            if (draw) draw(u, v);
        }
    }

    // Draw status bars    
    draw_upper_status();
    draw_lower_status();
}


/**
 * Initialize the main world map. Add walls around the edges, interior chambers,
 * and plants in the background so you can see motion.
 */
void init_main_map()
{
    uLCD.filled_rectangle(0,0,127,127, BLACK);
    // "Random" plants
    Map* map = set_active_map(0);
    for(int i = 15; i < 20; i ++)
    {
        add_plant(i,1,VERTICAL,25);
    }
    for(int i = 41; i < 45; i ++)
    {
        add_plant(i,1,VERTICAL,25);
    }
    for(int i = 19; i < 26; i++)
    {
       add_plant(i,21,VERTICAL,5); 
    }
    for(int i = 35; i < 45; i++)
    {
        add_plant(i,21,VERTICAL,5);
    }
    add_wall(20,1,VERTICAL,20);
    add_wall(40,1,VERTICAL,20);
    add_wall(20,20,HORIZONTAL,5);
    add_wall(35,20,HORIZONTAL,5);
    add_door(30,1);
    add_NPC(48,1);
    
    pc.printf("plants\r\n");
        
    pc.printf("Adding walls!\r\n");
    add_wall(0,              0,              HORIZONTAL, map_width());
    add_wall(0,              map_height()-1, HORIZONTAL, map_width());
    add_wall(0,              0,              VERTICAL,   map_height());
    add_wall(map_width()-1,  0,              VERTICAL,   map_height());
    pc.printf("Walls done!\r\n");

    print_map();
}

/**
 * Program entry point! This is where it all begins.
 * This function orchestrates all the parts of the game. Most of your
 * implementation should be elsewhere - this holds the game loop, and should
 * read like a road map for the rest of the code.
 */
int main()
{
    // First things first: initialize hardware
    ASSERT_P(hardware_init() == ERROR_NONE, "Hardware init failed!");
    
    int startScreen = 1;
    //Start screen
    while(startScreen)
    {
        draw_startScreen();
        startScreen = !check_Button(read_inputs());
    }
    
    // Initialize the maps
    maps_init();
    init_main_map();
    
    // Initialize game state
    set_active_map(0);
    Player.x = Player.y = 5;
    Player.health = 5;
    Player.omni = 0;
    Player.apples = 0;
    Player.end = 1;
    // Initial drawing
    draw_game(true);
    
    // Main game loop
    while(Player.end)
    {
        // Timer to measure game update speed
        Timer t; t.start();
        draw_game(false);
        update_game(get_action(read_inputs()));
        draw_game(false);
        // Actuall do the game update:
        // 1. Read inputs        
        // 2. Determine action (get_action)        
        // 3. Update game (update_game)
        // 3b. Check for game over
        // 4. Draw frame (draw_game)
        // 5. Frame delay
        uLCD.locate(1,15);
        uLCD.printf("Health %d",Player.health);
        uLCD.locate(1,0);
        if(Player.x < 10)
            uLCD.printf("X 0%d",Player.x);    
        else
            uLCD.printf("X %d",Player.x);
        uLCD.locate(7,0);
        if (Player.y < 10)
            uLCD.printf("Y 0%d",Player.y);
        else
            uLCD.printf("Y %d",Player.y);
        uLCD.locate(9,15);
        uLCD.printf("Apples: %d",Player.apples);
        check_stuff();
        check_Button(read_inputs());
        if(Player.health <=0)
        {
            Player.end = 0;    
        }
        t.stop();
        int dt = t.read_ms();
        if (dt < 100) wait_ms(100 - dt);
    }
    draw_gameend();
}
