#include "graphics.h"
#include "globals.h"
#define YELLOW 0xFFFF00
#define BROWN  0xD2691E
#define DIRT   BROWN
#define RED    0xFF0000
#define ORANGE 0xFFA500
#define BLACK  0x000000
#define WHITE  0xffffff
#define SKIN   0xDCB847
void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = YELLOW;
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = DIRT;
        else if (img[i] == '5') colors[i] = LGREY;
        else if (img[i] == '3') colors[i] = DGREY;
        else if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'B') colors[i] = BLACK;
        else if (img[i] == 'W') colors[i] = WHITE;
        else if (img[i] == 'S') colors[i] = SKIN;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

const char duck[121] = {
    'B','B','B','B','B','B','Y','Y','Y','B','B',
    'B','B','B','B','B','Y','Y','Y','Y','Y','B',    
    'B','B','B','B','B','Y','Y','Y','B','Y','B',
    'B','B','B','B','B','Y','Y','Y','Y','O','R',
    'Y','B','Y','Y','Y','Y','Y','Y','Y','B','B',
    'Y','5','Y','Y','5','Y','Y','Y','Y','Y','B',
    'Y','Y','5','5','Y','Y','Y','Y','Y','Y','B',
    'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'B','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y',
    'B','Y','Y','Y','Y','Y','Y','Y','Y','Y','B',
    'B','Y','Y','Y','Y','Y','Y','Y','Y','Y','B',
    };
const char apple[121] = {
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','G','G','B','D','B','B','B','B',
    'B','B','B','B','G','D','B','B','B','B','B',
    'B','B','R','B','B','R','R','R','B','B','B',
    'B','R','W','W','R','R','R','R','R','R','B',
    'B','R','W','R','R','R','R','R','R','R','B',
    'B','R','R','R','R','R','R','R','R','R','B',
    'B','R','R','R','R','R','R','R','R','R','B',
    'B','B','R','R','R','R','R','R','R','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    };
    
const char poisonapple[121] = {
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','G','G','B','D','B','B','B','B',
    'B','B','B','B','G','D','B','B','B','B','B',
    'B','B','R','B','B','R','R','R','G','B','B',
    'B','G','W','W','R','R','R','R','R','R','B',
    'B','R','W','R','G','R','R','R','R','R','B',
    'B','R','R','R','R','R','R','R','G','R','B',
    'B','R','R','G','R','R','R','R','R','R','B',
    'B','B','R','R','R','R','R','R','R','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    };
    
const char oldMan[121] = {
    'B','B','B','B','S','S','S','S','B','B','B',
    'B','B','B','S','S','S','S','S','S','B','B',
    'B','B','3','W','S','S','S','S','S','B','B',
    'B','B','3','B','W','W','S','W','W','B','B',
    'B','B','3','S','B','S','S','S','B','B','B',
    'B','B','3','3','S','R','R','R','S','B','B',
    'B','D','D','D','3','3','3','3','B','B','B',
    'B','D','S','D','D','3','3','3','B','B','B',
    'B','D','S','D','D','D','3','S','B','B','B',
    'B','B','B','D','D','D','3','D','B','B','B',
    'B','B','B','S','B','S','B','D','B','B','B',
    };
    
const char goldkey [121] = {
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','Y','Y','Y','Y','B',
    'B','Y','Y','Y','Y','Y','Y','W','W','Y','B',
    'B','Y','Y','Y','Y','Y','Y','W','W','Y','B',
    'B','Y','B','Y','B','B','Y','Y','Y','Y','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    };
const char door [121] = {
    'D','D','D','D','D','D','D','D','D','D','D',
    'D','D','D','D','D','D','D','D','D','D','D',
    'D','D','D','D','D','D','D','D','D','D','D',
    'D','D','D','D','D','D','D','D','D','B','D',
    'D','D','D','D','D','D','D','D','D','B','D',
    'D','D','D','D','D','D','D','D','D','B','D',
    'D','D','D','D','D','D','D','D','D','B','D',
    'D','D','D','D','D','D','D','D','D','B','D',
    'D','D','D','D','D','D','D','D','D','D','D',
    'D','D','D','D','D','D','D','D','D','D','D',
    'D','D','D','D','D','D','D','D','D','D','D',
    };

const char plant [121] = {
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','G','B','G','B','G','G','B','B',
    'B','B','G','G','G','G','G','G','G','G','B',
    'B','G','G','G','G','G','G','G','G','G','B',
    'G','G','G','G','G','G','G','G','G','B','B',
    'B','G','G','G','G','G','G','G','G','G','B',
    'G','G','G','G','G','G','G','G','G','G','B',
    'G','G','G','G','G','G','G','G','G','G','G',
    };

void draw_player(int u, int v, int key)
{
   draw_img(u, v, duck);
}

void draw_nothing(int u, int v)
{
    // Fill a tile with blackness
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}

void draw_wall(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, BROWN);
}    

void draw_plant(int u, int v)
{
    draw_img(u, v, plant);
}

void draw_upper_status()
{
    // Draw bottom border of status bar
    uLCD.line(0, 9, 127, 9, GREEN);
    
    // Add other status info drawing code here
}

void draw_lower_status()
{
    // Draw top border of status bar
    uLCD.line(0, 118, 127, 118, GREEN);
    
    // Add other status info drawing code here
}

void draw_border()
{
    uLCD.filled_rectangle(0,     9, 127,  14, WHITE); // Top
    uLCD.filled_rectangle(0,    13,   2, 114, WHITE); // Left
    uLCD.filled_rectangle(0,   114, 127, 117, WHITE); // Bottom
    uLCD.filled_rectangle(124,  14, 127, 117, WHITE); // Right
}

void draw_startScreen()
{   
    uLCD.text_bold(ON);
    uLCD.text_string("Homebound Duck", 3, 1, FONT_7X8, WHITE);
    uLCD.text_string("HELP THIS DUCK", 2, 7,FONT_7X8, WHITE);
    uLCD.text_string("RETURN HOME", 5, 9,FONT_7X8, WHITE);
    uLCD.text_string("Press any button", 1, 14, FONT_7X8, WHITE);
    uLCD.text_string("to start", 1, 15, FONT_7X8, WHITE);
}

void draw_gameend()
{   
    uLCD.filled_rectangle(0,0, 127,  127, BLACK); // Top
    uLCD.text_bold(ON);
    uLCD.text_string("Game Over", 4, 1, FONT_7X8, WHITE);
}
void draw_NPC(int u, int v)
{
    draw_img(u, v, oldMan);
}
void draw_apple(int u, int v)
{
    draw_img(u,v,apple);
}
void draw_poiapple(int u, int v)
{
    draw_img(u,v,poisonapple);
}
void draw_door(int u, int v)
{
    draw_img(u,v,door);
}
void draw_key(int u, int v)
{
    draw_img(u,v,goldkey);    
}


