#include "mbed.h"
#include "MODSERIAL.h"
#include "Camera_LS_Y201.h"
#include "SDFileSystem.h"
#include "SHTx/sht15.hpp"
#include "Servo.h"
#include "TextLCD.h"

#define IR_THRESHOLD    0.009f

#define DEBMSG printf
#define NEWLINE() printf("\r\n")


MODSERIAL sms(p13, p14);
Serial pc(USBTX, USBRX);
Servo myservo(p22);
TextLCD lcd(p15, p16, p17, p18, p19, p21);
AnalogIn ir(p20);
SHTx::SHT15 temp_sensor(p9, p10);
SDFileSystem sd(p5, p6, p7, p8, "sd");
Camera_LS_Y201 cam1(p28, p27);
DigitalOut light1(p29);
DigitalOut light2(p30);
PwmOut  speaker(p23);

typedef struct work {
    FILE *fp;
} work_t;

work_t work;


bool movement = false;
float current_avg;

bool activate = true;

float current_temperature;
float target_temperature;
bool heat = true;

int index = 1;

//char* mobile_number = "6784628602";
//char* mobile_number = "4043887322";
char* mobile_number = "4045789581";


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

bool message_received = false;
char message[256];
char sms_buffer[256];
int message_count = 0;

void delete_messages()
{
    wait(0.25);
    sms.printf("AT+CMGF=1%c", 13);
    wait(0.25);
    sms.printf("AT+CMGD=1,4%c", 13);
    while(!sms.txBufferEmpty()) {
    }
    wait(2);
    sms.rxBufferFlush();
}

void send_sms(char * message)
{
    led3 = 1;
    pc.printf("Sending SMS\n");
    wait(0.25);
    sms.printf("AT+CMGF=1%c", 13);
    wait(.25);
    sms.printf("AT+CMGS=\"%s\"%c", mobile_number, 13);
    wait(0.25);
    sms.printf("%s%c", message ,26);
    while(!sms.txBufferEmpty()) {
    }
    wait(0.5);
    led3 = 0;
}

void receive_sms()
{
    wait(0.25);
    sms.printf("AT+CMGF=1%c", 13);
    wait(0.25);
    //sms.printf("AT+CMGL=\"ALL\"%c", 13);
    sms.printf("AT+CMGL=\"REC UNREAD\"%c", 13);
    while(!sms.txBufferEmpty()) {
    }
}

void get_data(char *buffer)
{
    int index = 0;
    char c = sms.getc();
    while(c != 10) {
        buffer[index++] = c;
        c = sms.getc();
    }
    buffer[index] = 0;
}

void adjust_temperature(){
    temp_sensor.update();
    current_temperature = temp_sensor.getTemperature();
    if(current_temperature > 85.0f){
        send_sms("High Temperature Alert!!!");
    }
    if(!heat){
        temp_sensor.setHeater(false);
        return;
    }
    if(current_temperature < target_temperature){
        temp_sensor.setHeater(true);
    } else {
        temp_sensor.setHeater(false);
    }
}

void read_message()
{
    while(sms.readable()) {
        get_data(sms_buffer);
        if(strstr(sms_buffer, "CMGL") != NULL) {
            for(int i = 0; i < 256; i++) message[i] = 0;
            get_data(message);
            message_received = true;
            delete_messages();
            return;
        }
        sms_buffer[0] = 0;
    }
    receive_sms();
}



void setup_devices()
{
    sms.baud(115200);
    pc.baud(115200);
    //pc.printf("\x1B[2J");
    //pc.printf("\x1B[H");
    message_received = false;
    led4 = 1;
    delete_messages();
    mkdir("/sd/mydir", 0777);
    temp_sensor.setScale(true);
    current_temperature = temp_sensor.getTemperature();
    target_temperature = current_temperature;
}

bool check_movement()
{
    float value = ir;
    if (value > (current_avg + IR_THRESHOLD) || value < (current_avg - IR_THRESHOLD)){
        led1 = 1;
    printf("MOVEMENT_DETECTED: IR value is %f, Current_avg: %f\r\n",value, current_avg);
        return true;
    } else {
        led1 = 0;
        //printf("IR value is %f, Current_avg: %f\r\n", value, current_avg);
        return false;
    }
}

void calibrate_ir()
{
    float current_sum = 0.0f;
    for(int i = 0; i < 10000; i++) {
        current_sum = current_sum + ir;
    }
    current_avg = current_sum / 10000.0f;
}

/**
* Callback function for readJpegFileContent.
*
* @param buf A pointer to a buffer.
* @param siz A size of the buffer.
*/
void callback_func(int done, int total, uint8_t *buf, size_t siz)
{
    fwrite(buf, siz, 1, work.fp);

    static int n = 0;
    int tmp = done * 100 / total;
    if (n != tmp) {
        n = tmp;
        DEBMSG("Writing...: %3d%%", n);
        NEWLINE();
    }
}


/**
* Capture.
*
* @param cam A pointer to a camera object.
* @param filename The file name.
*
* @return Return 0 if it succeed.
*/
int capture(Camera_LS_Y201 *cam, char *filename)
{
    /*
    * Take a picture.
    */
    if (cam->takePicture() != 0) {
        return -1;
    }
    DEBMSG("Captured.");
    NEWLINE();

    /*
    * Open file.
    */
    work.fp = fopen(filename, "wb");
    if (work.fp == NULL) {
        return -2;
    }

    /*
    * Read the content.
    */
    DEBMSG("%s", filename);
    NEWLINE();
    if (cam->readJpegFileContent(callback_func) != 0) {
        fclose(work.fp);
        return -3;
    }
    fclose(work.fp);

    /*
    * Stop taking pictures.
    */
    cam->stopTakingPictures();

    return 0;
}

void take_picture()
{
    
    myservo.write(0);
    int a;
    wait(1);
    char buffer[25];
    sprintf(buffer, "/sd/mydir/%d_1.jpg", index);
    a =  capture(&cam1,buffer);
    switch (a) {
        case -1:
            led1=1;
            break;
        case -2:
            //led2=1;
            break;
        case -3:
            led3=1;
            break;
        case 0:
            led4=1;
            lcd.printf("Took picture 1!\n");
            break;
    }

    wait(1);
    led1=0;
    //led2=0;
    led3=0;
    led4=0;

    myservo.write(0.5);
    wait(1);
    sprintf(buffer, "/sd/mydir/%d_2.jpg", index);
    a= capture(&cam1,buffer);

    switch (a) {
        case -1:
            led1=1;
            break;
        case -2:
            //led2=1;
            break;
        case -3:
            led3=1;
            break;
        case 0:
            led4=1;
            lcd.printf("Took picture 2!\n");
            break;
    }

    wait(1);
    led1=0;
    //led2=0;
    led3=0;
    led4=0;
    myservo.write(1);
    wait(1);
    sprintf(buffer, "/sd/mydir/%d_3.jpg", index++);
    a= capture(&cam1,buffer);
    switch (a) {
        case -1:
            led1=1;
            break;
        case -2:
            //led2=1;
            break;
        case -3:
            led3=1;
            break;
        case 0:
            led4=1;
            lcd.printf("Took picture 3!\n");
            break;
    }

    wait(1);
    led1=0;
    //led2=0;
    led3=0;
    led4=0;

}


void handle_message()
{
    int temp;
    pc.printf("MESSAGE: %s\n", message);
    if(strstr(message, "take picture") != NULL){
        take_picture();
    } else if(strstr(message, "turn off alarm") != NULL){
        speaker = 0;
    } else if(strstr(message, "get status") != NULL){
        char msg[100];
        int l1 = light1;
        int l2 = light2;
        int spk = speaker > 0.0f;
        sprintf(msg, "Status: Light1 = %d, Light2 = %d, Temperature = %f, Alarm = %d", l1, l2, temp_sensor.getTemperature(), spk);
        send_sms(msg);
        pc.printf(msg);
    } else if (strstr(message, "deactivate") != NULL){
        speaker = 0;
        activate = false;
        led2 = 0;
        pc.printf("\nIntrusion alert not active\n");
    } else if (strstr(message, "activate") != NULL){
        activate = true;
        calibrate_ir();
        light1 = 0;
        light2 = 0;
        heat = false;
        temp_sensor.setHeater(false);
        led2 = 1;
        pc.printf("\nIntrusion alert active\n");
    } else if (strstr(message, "turn off light 1") != NULL){
        pc.printf("\nTurning off light 1\n");
        light1 = 0;
    } else if (strstr(message, "turn off light 2") != NULL){
        pc.printf("\nTurning off light 2\n");
        light2 = 0;
    } else if (strstr(message, "turn on light 1") != NULL){
        pc.printf("\nTurning on light 1\n");
        light1 = 1;
    } else if (strstr(message, "turn on light 2") != NULL){
        pc.printf("\nTurning on light 2\n");
        light2 = 1;
    } else if (strstr(message, "turn off heat") != NULL){
        heat = false;
        lcd.printf("Heat off!\n");
        pc.printf("\nTurning off heat\n");
    } else if (strstr(message, "get temperature") != NULL){
        char new_message[30];
        sprintf(new_message, "Current Temperature is %f", temp_sensor.getTemperature());
        send_sms(new_message);
        pc.printf("\nSending current temperature %f\n", temp_sensor.getTemperature());
    } else if (sscanf(message, "set temperature %d", &temp) >=1){
        target_temperature = (float)temp;
        lcd.cls();
        lcd.printf("Target temp: %d\n", temp);
        heat = true;
        if(current_temperature < target_temperature){
            lcd.printf("Heater ON\n");
        } else {
            lcd.printf("Heater OFF\n");
        }
        pc.printf("Setting target temperature to %d\n", temp);
    }
    message[0] = 0;
    message_received = false;
    
}

void play_sound(){
    for(int i = 0; i < 5000; i++){
        for(float j = 0.0; j <= 1.0; j+=0.1){
            speaker = j;
            wait(0.0001);
            
        }
    }
    //speaker = 0.0;
}
