#include "mbed.h"
#include "FreescaleIAP.h"

/** Write contiguous integer data to flash memory
 *
 * @param data address of the data to be written
 * @param data_len size of data to be written
 * @param return Success if no errors were encountered, otherwise one of the error states defined in Freescale.h
 */
IAPCode write(int* data, size_t data_len);

/** Write a single integer to flash memory
 *  
 * @param data data that needs to be writter
 * @param return Success if no errors were encountered, otherwise one of the error states defined in Freescale.h
 */
IAPCode write(int data);
/** Retrieve written data
 * 
 * @param return address of start of data write sector
 */ 
int *getData();

/** Retrieve size of written data
 * 
 * @param return size of data written so far
 */
int getSize();