#include "mbed.h"
#include "FreescaleIAP.h"

static int start_address = flash_size() - SECTOR_SIZE;
static int write_address = start_address;

IAPCode write(int* data, size_t data_len){
    IAPCode errorCode;
    
    if((errorCode = erase_sector(write_address)) != 0)
        return errorCode;
    if((errorCode = program_flash(write_address, (char*)data, data_len)) != 0)
        return errorCode;
    write_address += data_len;
    return Success;
}

IAPCode write(int data){
    IAPCode errorCode;
    if((errorCode = erase_sector(write_address)) != 0)
        return errorCode;
    if((errorCode = program_flash(write_address, (char*)data, sizeof(data))) != 0)
        return errorCode;
    write_address += sizeof(data);
    return Success;    
}

int* getData(){
    return (int*)(start_address);    
}

int getSize(){
    return ((write_address - start_address)/sizeof(int));
}