#include "mbed.h"
#include "TinyGPS.h"
#include "Eeabp1.h"

//#define TEST_ANALOG
#define TEST_TEMP_HUMID
#define TEST_ACC

#if defined(TEST_DIGITAL_IN_INTTERUPT)
Eeabp1 *gp;
bool led_on = true;

void flip() {
    if (led_on)
        gp->setLedState(LED_OFF);
    else
        gp->setLedState(LED_ON);
    led_on = !led_on;
}
#endif /* defined(TEST_DIGITAL_IN_INTTERUPT) */

int main(void)
{
    Eeabp1 board;
    int ret = 0;

#if defined(TEST_DIGITAL_IN_INTTERUPT)
    gp = &board;
    led_on = true;
#endif /* defined(TEST_DIGITAL_IN_INTTERUPT) */

    board.setLedState(LED_ON);
    board.debug("Hello ina-hack!\r\n");

    board.setGrovePower(true);
#if defined(TEST_DIGITAL_OUT) || defined(TEST_DIGITAL_IN) || defined(TEST_DIGITAL_IN_INTTERUPT)
    board.setGrovePortType(GROVE_CH1, GROVE_DIO);
    board.setGrovePortType(GROVE_CH2, GROVE_DIO);
#endif
#if defined(TEST_DIGITAL_OUT)
    board.setGroveDioDirection(GROVE_CH1, GROVE_DIO_OUT);
    board.setGroveDioDirection(GROVE_CH2, GROVE_DIO_OUT);
#endif /* defined(TEST_DIGITAL_OUT) */
#if defined(TEST_DIGITAL_IN)
    board.setGroveDioDirection(GROVE_CH1, GROVE_DIO_IN);
    board.setGroveDioDirection(GROVE_CH2, GROVE_DIO_IN);
#endif /* defined(TEST_DIGITAL_IN) */
#if defined(TEST_DIGITAL_IN_INTTERUPT)
    board.setGroveDioDirection(GROVE_CH1, GROVE_DIO_IN, flip);
    board.setGroveDioDirection(GROVE_CH2, GROVE_DIO_IN, flip);
#endif /* defined(TEST_DIGITAL_IN_INTTERUPT) */
#if defined(TEST_ANALOG)
    board.setGrovePortType(GROVE_CH1, GROVE_ANALOG);
    board.setGrovePortType(GROVE_CH2, GROVE_ANALOG);
#endif /* defined(TEST_ANALOG) */

#if defined(TEST_LORA)
    ret = board.setLoRaPower(true);
    if (ret != 0) {
        board.debug("error %d\r\n", ret);
    }
#endif /* defined(TEST_LORA) */
#if defined(TEST_TEMP_HUMID)
    ret = board.enableTempHumidSensor();
    if (ret != 0)
        board.debug("error %d\r\n", ret);
#endif /* TEST_TEMP_HUMID */
#if defined(TEST_ACC)
    ret = board.enableAccelerometer();
    if (ret != 0)
        board.debug("error %d\r\n", ret);
#endif /* defined(TEST_ACC) */

#if defined(TEST_LORA)
    int i = 0;
#endif /* defined(TEST_LORA) */
#if defined(TEST_DIGITAL_OUT)
    bool on = true;
#endif /* defined(TEST_DIGITAL_OUT) */
    do {
        wait(2);
        board.loop();
#if defined(TEST_DIGITAL_OUT)
        if (on) {
            board.setGroveDio(GROVE_CH1, GROVE_DIO_HIGH);
            board.setGroveDio(GROVE_CH2, GROVE_DIO_LOW);
        } else {
            board.setGroveDio(GROVE_CH1, GROVE_DIO_LOW);
            board.setGroveDio(GROVE_CH2, GROVE_DIO_HIGH);
        }
        on = !on;
#endif /* defined(TEST_DIGITAL_OUT) */
#if defined(TEST_DIGITAL_IN)
        board.debug("------------\r\n");
        board.debug("P1 S1: %d\r\n", board.getGroveDio(GROVE_CH1, GROVE_SIG1));
        board.debug("P1 S2: %d\r\n", board.getGroveDio(GROVE_CH1, GROVE_SIG2));
        board.debug("P2 S1: %d\r\n", board.getGroveDio(GROVE_CH2, GROVE_SIG1));
        board.debug("P2 S2: %d\r\n", board.getGroveDio(GROVE_CH2, GROVE_SIG2));
#endif /* defined(TEST_DIGITAL_IN) */
#if defined(TEST_ANALOG)
        board.debug("------------\r\n");
        board.debug("P1 S1: %2.2f\r\n", board.getGroveAnalog(GROVE_CH1, GROVE_SIG1));
        board.debug("P1 S2: %2.2f\r\n", board.getGroveAnalog(GROVE_CH1, GROVE_SIG2));
        board.debug("P2 S1: %2.2f\r\n", board.getGroveAnalog(GROVE_CH2, GROVE_SIG1));
        board.debug("P2 S2: %2.2f\r\n", board.getGroveAnalog(GROVE_CH2, GROVE_SIG2));
#endif /* defined(TEST_ANALOG) */
#if defined(TEST_TEMP_HUMID)
        board.debug("------------\r\n");
        board.debug("Temp: %2.2f, Humid: %2.2f\r\n", board.getTemp(), board.getHumid());
#endif /* defined(TEST_ANALOG) */
#if defined(TEST_ACC)
        int x, y, z;
        board.getAcc(&x, &y, &z);
        board.debug("------------\r\n");
        board.debug("X: %d, Y: %d, Z: %d\r\n", x, y, z);
#endif /* defined(TEST_ACC) */

#if defined(TEST_LORA)
        board.sendLoRaString("hello %d", i++);
#endif /* defined(TEST_LORA) */
    } while(true);
}