#if !defined(EEAPP1_H)
#define EEAPP1_H
#include "mbed.h"
#include "types.h"
#include "Sht31.h"
#include "ADXL345_I2C.h"

typedef enum {
    LED_OFF,
    LED_ON,
    LED_BLINK_FAST,
    LED_BLINK_MID,
    LED_BLINK_SLOW,
}EeabLedState;

typedef enum {
    GROVE_CH1,
    GROVE_CH2,
}EeabGrovePort;

typedef enum {
    GROVE_SIG1,
    GROVE_SIG2,
}EeabGroveSig;

typedef enum {
    GROVE_DIO,
    GROVE_ANALOG,
}EeabGrovePortType;

typedef enum {
    GROVE_DIO_OUT,
    GROVE_DIO_IN,
}EeabGroveDioDirection;

typedef enum {
    GROVE_DIO_LOW = 0,
    GROVE_DIO_HIGH = 1,
}EeabGroveDio;

class Eeabp1
{
public:
    Eeabp1();
    int setLedState(EeabLedState state);
    void loop(void);
    int debug(const char * format, ...);
    int setLoRaPower(bool on);
    int sendLoRaString(const char * format, ...);
    void setGrovePower(bool on);
    int setGrovePortType(EeabGrovePort port, EeabGrovePortType type);
    int setGroveDioDirection(EeabGrovePort port, EeabGroveDioDirection dir, Callback<void()> func = NULL);
    int setGroveDio(EeabGrovePort port, EeabGroveDio val);
    int getGroveDio(EeabGrovePort port, EeabGroveSig sig);
    float getGroveAnalog(EeabGrovePort port, EeabGroveSig sig);
    int enableTempHumidSensor(void);
    float getTemp(void);
    float getHumid(void);
    int enableAccelerometer(void);
    int getAcc(int *x, int *y, int *z);

private:
    DigitalOut pwr_en;
    /* state LED */
    DigitalOut led;
    EeabLedState led_state;
    /* LoRa */
    RawSerial *serial;
    DigitalOut lora_power;
    DigitalOut lora_reset;
    bool lora_enabled;
    /* Grove */
    DigitalOut grove_power;
    bool grove_enabled;
    DigitalOut grv_sel2a;
    DigitalOut grv_sel2g;
    DigitalOut grv_sel1a;
    DigitalOut grv_sel1g;
    
    DigitalOut *grv_p1s1do; //Port1, Signal1, Digital Out // GP2
    DigitalOut *grv_p1s2do; //Port1, Signal2, Digital Out // GP1
    InterruptIn *grv_p1s1di; //Port1, Signal1, Digital In // GP2
    InterruptIn *grv_p1s2di; //Port1, Signal1, Digital In // GP2
    AnalogIn grv_p1s1a; //Port1, Signal1, Analog In // AN2
    AnalogIn grv_p1s2a; //Port1, Signal2, Analog In // AN2

    DigitalOut *grv_p2s1do; //Port2, Signal1, Digital Out // GP4
    DigitalOut *grv_p2s2do; //Port2, Signal2, Digital Out // GP3
    InterruptIn *grv_p2s1di; //Port2, Signal1, Digital In // GP4
    InterruptIn *grv_p2s2di; //Port2, Signal2, Digital In // GP3
    AnalogIn grv_p2s1a; //Port2, Signal1, Analog In // AN4
    AnalogIn grv_p2s2a; //Port2, Signal2, Analog In // AN3

    Sht31 *temp_humid_sensor;
    ADXL345_I2C *accelerometer;

    void flushSerial();
    int chkSerialChar(const char,uint16_t);
    int waitSerialChar(const char,uint16_t);
    int chkSerialCharOk();
    int chkSerialCharRes(char);
};

#endif /* !defined(EEAPP1_H) */