#include "mbed.h"
#include "LPS.h"

Timer t;

Serial pc(USBTX, USBRX); // tx, rx
Serial xbee(D1, D0); // tx, rx

/////////////////////////////
I2C i2c(D4,D5);
LPS ps(i2c);
///////////////////////////

char cmd = xbee.getc();

int main() {//1
    pc.printf("settig start\r\n");
    xbee.printf("settig start\r\n");
    
    ///////////////////////////////
    if (!ps.init()){//2
        printf("Failed to autodetect pressure sensor!\r\n");
        while (1);
    }//2
    ps.enableDefault();
    ///////////////////////////////
    
    /**************************************************************/
    
    
            //ここに気圧の標高の較正とGPSの接続を行う。
    
    
    /**************************************************************/
    
    pc.printf("begin\r\n");
    xbee.printf("begin\r\n");
    
    for (;;) {//2
        
        //if (pc.readable()) xbee.putc(pc.getc());
        if (xbee.readable()) pc.putc(xbee.getc());
        wait_us(1);
        
        //char cmd = xbee.getc();//cmd共有

        //機体の放出後→データを取る
        if(cmd == 'm'){//3
            pc.printf("start\r\n");
            t.start();
            cmd = ;
            
            while(1){//4
                //if (pc.readable()) xbee.putc(pc.getc());
                if (xbee.readable()) pc.putc(xbee.getc());
                //printf("oo");
                wait_us(1);
                
                /***********************************************************/
                //////////////////////////////////////
                float pressure = ps.readPressureMillibars();
                float altitude = ps.pressureToAltitudeMeters(pressure);
                float temperature = ps.readTemperatureC();
                pc.printf("p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C\r\n",pressure,altitude,temperature);
                    
                //////////////////////////////////////
                
                                //データ(気圧,GPS,地磁気)を取る。
                                //データの保存を10回行い, 保存する。
                
                
                /***********************************************************/
                //char cmd2 = xbee.getc();//共有化
                xbee.printf("%x\r\n",cmd);
                
                
                //機体の着陸後→プログラムを終わらす。
                if(cmd == 'n'){//5
                    pc.printf("end\r\n");
                    pc.printf("time = %f",t.read());
                    t.stop();
                    cmd = 0;
                    
                    return 0;
                    
                    }//5
                
                }//4
            
            
            }//3
    }//2
}//1