#include "mbed.h"

I2C i2c(p9,p10);
Serial pc(USBTX,USBRX);

//スレーブアドレス
uint8_t addrAG =  0b1101001<<1;//AD0=H(VDDIOにした)/7bitであるため. 右にズラして,左に0を追加することで, 8bitにする。　加速度ジャイロのスレーブアドレス
uint8_t addrM = 0b0001100<<1;//磁気センサのスレーブアドレス

//メモ
//1byte=8bit(char)
//2byte=16bit(int(shortも))

int main() { 
    int i,val; //valは1or0などの確認用
    uint8_t addr,addr1;
    char cmd[1];//charはmbedのi2c使用であるため。
    
    //セッシング(スリーブモード解除)
    i2c.start();
    cmd[0]=0x00;
    addr1 = 0x6b;
    i2c.write(addr1,cmd,1);//0x6bに0x00を書き込む
    cmd[0]=0x02;
    addr1 = 0x37;
    i2c.write(addr1,cmd,1);//0x37に0x02を書き込む
    
    //who I amで正常か？を判断する。実際, 加速度・ジャイロと地磁気の二つを確認している。
    addr = addrAG;
    for(i=0;i<2;i++){
        cmd[0] = 0x75; //こいつを読んで, 0x71がかえってくる。
        val=i2c.write( addr, cmd, 1);//内部レジスタを指定(1=1byte)
        //printf("val=%d",val);
        char v;
        val=i2c.read( addr, &v, 1);//レジスタの読み取り
        uint8_t WHO = v;
        //printf("val=%d, 0x%x",val,WHO);
        if(WHO == 0x71){
            printf("0x%x/WHO_I_AM is Yes\r\n",addr>>1);
            }else{
                printf("0x%x/WHO_I_AM is NO\r\n",addr>>1);
                }
        addr = addrM;
    }
        
    //加速度・ジャイロ
    //0x3bからの14byteに含まれる。そのデータを読む。一つのデータは16bit(=2byte)となるため, 2つのchar(8bit)として分けることができる。 short intなども可ではある。
    //加速度x:0x3b[0],0x3c[1] y:0x3d[3],0x3e[4] z:0x3f[5],0x40[6]   (0x41[7],0x42[8]は違うデータ)
    //角速度x:0x43[9],0x44[10] y:0x45[11],0x46[12] z:0x47[13],0x48[14]
    //上位8bitが先に並んでいる。
    
    char data[14];
    data[0] = 0x3b;
    val=i2c.write(addrAG,data,1);
    //printf("%d",val);
    val=i2c.read(addrAG,data,14);
    //printf("%d\r\n",val);
    
    
    i2c.stop();
}
