#include "mbed.h"

I2C i2c(p9,p10);
Serial pc(USBTX,USBRX);

//スレーブアドレス
uint8_t addrAG =  0b1101001<<1;//AD0=H(VDDIOにした)/7bitであるため. 右にズラして,左に0を追加することで, 8bitにする。　加速度ジャイロのスレーブアドレス
uint8_t addrM = 0b0001100<<1;//磁気センサのスレーブアドレス

const double G = 9.80665;//重力加速度

//メモ
//1byte=8bit(char)
//2byte=16bit(int(shortも))

int main() { 
    int i,val; //valは1or0などの確認用
    uint8_t addr,addr1;
    char cmd[1];//charはmbedのi2c使用であるため。
    
    //セッシング(スリーブモード解除)
    i2c.start();
    cmd[0]=0x00;
    addr1 = 0x6b;
    i2c.write(addr1,cmd,1);//0x6bに0x00を書き込む
    cmd[0]=0x02;
    addr1 = 0x37;
    i2c.write(addr1,cmd,1);//0x37に0x02を書き込む
    //printf("%d",val);
    
    //who I amで正常か？を判断する。実際, 加速度・ジャイロと地磁気の二つを確認している。
    addr = addrAG;
    for(i=0;i<2;i++){
        cmd[0] = 0x75; //こいつを読んで, 0x71がかえってくる。 
        val=i2c.write( addr, cmd, 1);//内部レジスタを指定(1=1byte)
        //printf("val=%d",val);
        char v;
        val=i2c.read( addr, &v, 1);//レジスタの読み取り
        uint8_t WHO = v;
        //printf("val=%d, 0x%x",val,WHO);
        if(WHO == 0x71){
            printf("0x%x/WHO_I_AM is Yes\r\n",addr>>1);
            }else{
                printf("0x%x/WHO_I_AM is NO\r\n",addr>>1);
                }
        addr = addrM;
    }
        
    while(1){
        //加速度・ジャイロ
        //0x3bからの14byteに含まれる。そのデータを読む。一つのデータは16bit(=2byte)となるため, 2つのchar(8bit)として分けることができる。 short intなども可ではある。
        //加速度x:0x3b[0],0x3c[1] y:0x3d[2],0x3e[3] z:0x3f[4],0x40[5]   (0x41[6],0x42[7]は違うデータ)
        //角速度x:0x43[8],0x44[9] y:0x45[10],0x46[11] z:0x47[12],0x48[13]
        //上位8bitが先に並んでいる。(ビックエンディアン方式)→2つの8bitを結合したい。
        
        char data[14];
        data[0] = 0x3b;
        val=i2c.write(addrAG,data,1);
        //printf("%d",val);
        val=i2c.read(addrAG,data,14);
        //printf("%d\r\n",val);
         
        //2つの8bitを16bitへ統合の仕方の1例
        //short bh = 0x4F;short bl=0x1A; (short→16bit)
        //a = (bh << 8)|bl;
        //0b 0000 0000 0100 1111 → 0b 0100 1111 0000 0000 
        //→0b 0100 1111 0001 1010
    
    
        short ax,ay,az,gx,gy,gz;//単位mV
        ax=(short)data[0]<<8|(short)data[1];
        ay=(short)data[2]<<8|(short)data[3];
        az=(short)data[4]<<8|(short)data[5];
        
        float AX,AY,AZ;//電圧から数値へ
        AX=(float)ax*0.000488*G/7.8124;
        AY=(float)ay*0.000488*G/7.8124;
        AZ=(float)az*0.000488*G/7.8124;
        
        gx=(short)data[8]<<8|(short)data[9];
        gy=(short)data[10]<<8|(short)data[11];
        gz=(short)data[12]<<8|(short)data[13];
        
        float GX,GY,GZ;//電圧から数値へ
        GX=(float)gx*0.00763;
        GY=(float)gy*0.00763;
        GZ=(float)gz*0.00763;
        
        printf("x%.3f,y%.3f,z%.3f  ",AX,AY,AZ);
        printf("x%.3f,y%.3f,z%.3f\r\n",GX,GY,GZ);
        
        //磁気
        //内部アドレスの0x0Aに0x12を書き込むことでAD変換。
        //0x03から7byteのデータが含まれるため, それを読む。各テータ変換数値が16bit
        //地磁気 x:0x03[0],0x04[1] y:0x05[2],0x06[3] z:0x07[4],0x08[5]
        //0x09[6](STMステータスメッセージ)//読む必要あり。
        //下位8bitが先にならんでいる。(リトルエンディアン方式)→2つの8bitを結合したい。
        
        //問題点2022.12/13のメモ
        //日本語の紹介にあったAD変換をやろうとしたら, valが０にならない。そのため,　mpu9250のardinoであったが,lpc1768にやってみた。しかし,なにもかわらなった。 
        //現状動かない。
        
        cmd[0]=0x0A;//本来は0x02
        addrM=0x12;//本来addrM　　00001010
        val=i2c.write(addr,cmd,1);//AD変換(8Hz)を行う。
        printf("%d",val);
        char add;
        //val=i2c.read(addrM,&add,1.0);
        
        //if(add&0x01){
            data[0]=0x03;
            val=i2c.write(addrM,data,1,1);
            //printf("%d",val);
            val=i2c.read(addrM,data,7,1);
            //printf("%d\r\n",val);
            
            //if(!(data[6]&0x08)){
                
                short mx,my,mz;
                mx=((short)data[1]<<8|(short)data[0]);
                my=((short)data[3]<<8|(short)data[2]);
                mz=((short)data[5]<<8|(short)data[4]);
                
                float MX,MY,MZ;//電圧から数値へ
                MX=(float)mx*0.00015;
                MY=(float)my*0.00015;
                MZ=(float)mz*0.00015;
                
        
                //printf("x%.3f,y%.3f,z%.3f  ",AX,AY,AZ);
                //printf("x%.3f,y%.3f,z%.3f\r\n",GX,GY,GZ);
                //printf("x%.3f,y%.3f,z%.3f\r\n",MX,MY,MZ);
                //}
            //}
        wait(1);
        }
    i2c.stop();
}
