//コマンドなしver
//コマンドだと反応しないため→コマンド用のxbeeを必要だと思われる。
//xbeeが使えない→基盤ミス

#include "mbed.h"
#include "SRF02.h"
#include "SDFileSystem.h"
#include "Servo.h"
#include "MPU6050.h"
#include "LPS.h"

DigitalOut myleds[]={LED1,LED2,LED3,LED4};


SDFileSystem sd(p5, p6, p7, p8, "sd");      //SDcard
SRF02 sensor(p9,p10,0xE0);                  //距離
Servo myservo(p21);                         //モーター
Serial pc(USBTX,USBRX,9600);                //機体teraterm
//Serial xbee(p13,p14,9600);                //xbee(今回使わない)
MPU6050 mpu(p9,p10);                        //９軸
I2C i2c(p28,p27);                           //気圧
LPS ps(i2c);

int accel[3];

Timer t;                                    //時間は表示する

int main() {
    t.start();
    //xbee.printf("SDcard start\r\n");
    pc.printf("SDcard start\r\n");
    mkdir("/sd/mydir", 0777);                               //filename
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");          //open
    
    if (!ps.init()){
        pc.printf("Failed to autodetect pressure sensor!\r\n");
        while (1);
        }
        ps.enableDefault();
        
        while(1){                                                           //ｄが**cm以下になった場合、for文に移る
            myleds[1] = 1; 
            wait(0.01);
            
            //気圧センサー(ここでは表示しない)
            //float pressure = ps.readPressureMillibars();
            //float altitude = ps.pressureToAltitudeMeters(pressure)-65;     //補正値必須
            //float temperature = ps.readTemperatureC();
            //pc.printf("p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C\r\n",pressure,altitude,temperature);
            
            //距離SRF02(使う)
            int d = sensor.getDistanceCm();
            pc.printf("Distance = %d cm\r\n",d);
            
            //加速度MPU9250(ここでは表示しない)
            //mpu.readAccelData(accel);                                          //加速度の値をaccel[3]に代入
            //int x = accel[0]-123;                                              //x軸方向の加速度
            //int y = accel[1]+60;                                               //y軸方向の加速度
            //int z = accel[2]+1110 ;                                            //z軸方向の加速度
            //float X = x*0.000597964111328125;
            //float Y = y*0.000597964111328125;
            //float Z = z*0.000597964111328125;
            //double a = X*X+Y*Y+Z*Z-95.982071137936;
            //pc.printf("%.2f %.2f %.2f %.2f\r\n",X,Y,Z,a);                     //速度と変位を表示
            
            if(fp == NULL) {                                                    //データが無い場合
             error("Could not open file for write\r\n");
             }
            fprintf(fp, "%d\r\n",d);                                            //距離保存
            myleds[1] = 0;
            wait(0.01);
            
            //表示させる文
            //pc.printf("t %0.4f p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C ax%.2f ay%.2f az%.2f |a| %.2f %d\r\n",t.read(),pressure,altitude,temperature,X,Y,Z,a,d);
            //xbee.printf("number %f t %0.4f p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C ax%.2f ay%.2f az%.2f |a| %.2f\r\n",t.read(),pressure,altitude,temperature,X,Y,Z,a);
            
            if(d <= 30){
             //モータを動かす(スポンジ展開)
             for(int motor =0; motor <100; motor++) {
                 myservo = motor/100.0;
                 wait(0.01);
                 }
                 for(int num =0;num<1000;num++){                                                                 //1000回行う(コマンドができないため)
                    myleds[2] = 1;
                    wait(0.01);
                    //気圧センサー(表示する)
                    float pressure = ps.readPressureMillibars();
                    float altitude = ps.pressureToAltitudeMeters(pressure);                                      //補正値必須
                    float temperature = ps.readTemperatureC();
                    //pc.printf("p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C\r\n",pressure,altitude,temperature);
                    
                    //加速度MPU9250(表示する)
                    mpu.readAccelData(accel);                                                                       //加速度の値をaccel[3]に代入
                    int x = accel[0]-123;                                                                           //x軸方向の加速度
                    int y = accel[1]+60;                                                                            //y軸方向の加速度
                    int z = accel[2]+1110 ;                                                                         //z軸方向の加速度
                    float X = x*0.000597964111328125;
                    float Y = y*0.000597964111328125;
                    float Z = z*0.000597964111328125;
                    double a = X*X+Y*Y+Z*Z-95.982071137936;
                    //pc.printf("%.2f %.2f %.2f %.2f\r\n",X,Y,Z,a);
                    
                    pc.printf("t %0.4f p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C ax%.2f ay%.2f az%.2f |a| %.2f\r\n",t.read(),pressure,altitude,temperature,X,Y,Z,a);
                    
                    if(fp == NULL) {                                                                                 //データが無い場合
                    error("Could not open file for write\r\n");
                    }
                    fprintf(fp,"%0.4f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f\r\n",t.read(),pressure,altitude,temperature,X,Y,Z,a);      //SDカードに保存
                    //xbee.printf("number %f t %0.4f p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C ax%.2f ay%.2f az%.2f |a| %.2f\r\n",t.read(),pressure,altitude,temperature,X,Y,Z,a);
                    myleds[2] = 0;
                    wait(0.01);
                    }
                    
                    //回数分行ったら、SDカードを保存終了
                    fclose(fp);                                             //保存終了
                    //xbee.printf("SDcard OK");
                    pc.printf("SDcard OK");
                    t.stop();
                    }
                    }
                    }