//level 2
#include "mbed.h"
I2C mpu9250(p9,p10);

uint8_t addrAG =  0b1101001<<1;//AD0=H(VDDIOにした)/7bitであるため. 右にズラして,左に0を追加することで, 8bitにする。　加速度ジャイロのスレーブアドレス
uint8_t addrM = 0b0001100<<1;//磁気センサのスレーブアドレス
double G = 9.80665;//重力加速度

class mpu{//クラス宣言
//メンバの宣言
private:    //外部から操作不可

public:     //操作可能
    char addr;
    int ac[3];//単位mV
    int gy[3];//単位mV
    int mg[3];//単位mV
    
    void ready();
    void who();
    void accel(int *ac);
    void gyro(int *gy);
    void magnet(int *mg);
};

void mpu::ready(){
    char data[7];
    data[0]=0x00;
    addr = 0x6b;
    mpu9250.write(addr,data,1);//0x6bに0x00を書き込む
    data[0]=0x02;
    addr = 0x37;
}

void mpu::who(){
    char data[7];
    int i;
    addr = addrAG;
    for(i=0;i<2;i++){
        data[0] = 0x75; //こいつを読んで, 0x71がかえってくる。 
        mpu9250.write( addr, data, 1,1);//内部レジスタを指定(1=1byte)
        mpu9250.read( addr,data, 1,0);//レジスタの読み取り
        uint8_t WHO = data[0];
        if(WHO == 0x71){
            printf("0x%x/WHO_I_AM is Yes\r\n",addr>>1);
            }else{
                printf("0x%x/WHO_I_AM is NO\r\n",addr>>1);
                }
        addr = addrM;
    }
}

void mpu::accel(int *ac){ //加速度//スコープ解決演算子
    char data[7];
    //int ac[3];//単位mV
    data[0] = 0x3b;
    mpu9250.write(addrAG,data,1,1);
    mpu9250.read(addrAG,data,7,0);

    ac[0]=(short)data[0]<<8|(short)data[1];
    ac[1]=(short)data[2]<<8|(short)data[3];
    ac[2]=(short)data[4]<<8|(short)data[5];
}

void mpu::gyro(int *gy){  //角速度//スコープ解決演算子
    char data[7];
    //int gy[3];//単位mV
    data[0] = 0x43;
    mpu9250.write(addrAG,data,1,1);
    mpu9250.read(addrAG,data,7,0);
    
    gy[0]=(short)data[0]<<8|(short)data[1];
    gy[1]=(short)data[2]<<8|(short)data[3];
    gy[2]=(short)data[4]<<8|(short)data[5];
}

void mpu::magnet(int *mg){ //地磁気//スコープ解決演算子
    char data[7];
    //int mg[3];//単位mV
    data[0]=0x12;
    addr=0x0A;
    mpu9250.write(addr,data,1);//AD変換(8Hz)を行う。
    data[0]=0x03;
    mpu9250.write(addrM,data,1,1);
    mpu9250.read(addrM,data,7,0);
    
    mg[0]=((short)data[1]<<8|(short)data[0]);
    mg[1]=((short)data[3]<<8|(short)data[2]);
    mg[2]=((short)data[5]<<8|(short)data[4]);
}

Serial pc(USBTX,USBRX);

int main(){
    mpu mpu;
    float AX,AY,AZ;
    float GX,GY,GZ;
    float MX,MY,MZ;
    
    mpu.ready();
    mpu.who();
    
    int ac[3];//単位mV
    int gy[3];//単位mV
    int mg[3];//単位mV
    
    while(1){
        mpu.accel(ac);
        AX=(float)ac[0];
        AY=(float)ac[1];
        AZ=(float)ac[2];
        
        mpu.gyro(gy);        
        GX=(float)gy[0];
        GY=(float)gy[1];
        GZ=(float)gy[2];
        
        mpu.magnet(mg);
        MX=(float)mg[0];
        MY=(float)mg[1];
        MZ=(float)mg[2];
        
        printf("x%.3f   ,y%.3f  ,z%.3f  ",AX,AY,AZ);
        printf("x%.3f   ,y%.3f  ,z%.3f  ",GX,GY,GZ);
        printf("x%.3f   ,y%.3f  ,z%.3f\r\n",MX,MY,MZ);
        
        wait(0.01);
    }
    
}