#include "mbed.h"
#include "math.h"
#include "MPU6050.h"

MPU6050 mpu(p9,p10);
Serial pc(USBTX,USBRX,9600);

int accel[3];

int main() {
    while(1){
        mpu.readAccelData(accel);//加速度の値をaccel[3]に代入
        int x = accel[0]-123;//x軸方向の加速度
        int y = accel[1]+60;//y軸方向の加速度
        int z = accel[2]+1110 ;//z軸方向の加速度
        float X = x*0.000597964111328125;
        float Y = y*0.000597964111328125;
        float Z = z*0.000597964111328125; 
        double a = X*X+Y*Y+Z*Z-95.982071137936;
        //pc.printf("%.2f %.2f %.2f\r\n",x,y,z);
    
        pc.printf("x%.2f y%.2f z%.2f a%.2f\r\n",X,Y,Z,a);//速度と変位を表示
        
        //加速度からロール角rとピッチ角pを計算
        double r = atan(X/Y)*57.2957;
        double o = Y*Y+Z*Z;
        double l = sqrt(o);
        double n = -X/l;
        double p = atan(n)*57.2957;
        
        pc.printf("r%.2f p%.2f\r\n",r,p);
        
       wait(0.01);
        }
        }