#include "mbed.h"
#include "LPS.h"

I2C i2c(D0,D1);
LPS ps(i2c);

int main(){
    wait(1);
    
    
    if (!ps.init()){
        printf("Failed to autodetect pressure sensor!\r\n");
        while (1);
    }
    
    ps.enableDefault();
    
    while(1){
        float pressure = ps.readPressureMillibars();
        float altitude = ps.pressureToAltitudeMeters(pressure);
        float temperature = ps.readTemperatureC();
        printf("p:%.2f\t mbar\ta:%.2f m\tt:%.2f deg C\r\n",pressure,altitude,temperature);
    
    wait(1);
    }
}