#define mC 261.626//ド
#define mD 293.665//レ
#define mE 329.628//ミ
#define mF 349.228//ファ
#define mG 391.995//ソ
#define mA 440.000//ラ
#define mB 493.883//シ

#include "mbed.h"
#include "HEPTA_CDH.h"
#include "LPS.h"

DigitalOut sp1(A0);
Ticker sound;

Timer t;
HEPTA_CDH cdh(PB_5, PB_4, PB_3, PA_8, "sd"); //mosi, miso, sclk, nonconnect
Serial xbee(D1, D0); // tx, rx
Serial pc(USBTX,USBRX,9600); //UART
I2C i2c(D4,D5); //sda, scl
LPS ps(i2c);
int count=0;
int j;
int oto = 0;

void tick(void)
{
    sp1.write(oto);
    oto=!oto;
}

int main(){
    //音色
    float mm[]={mC*4,mD*4,mE*4,mF*4,mG*4,mA*4,mB*4,mC*8};
    
    
    //Display from satellite to PC via xbee.
    pc.printf("settig start\r\n");
    xbee.printf("settig start\r\n");
    
    //Create a file to save the data acquired from the sensor to a microSD card
    //Also, if there is no microSD card, this error statement will be displayed
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    
    //If there is no Barometric Pressure Sensors, this error statement will appear in teraterm
    if (!ps.init()){//2
        printf("Failed to autodetect pressure sensor!\r\n");
        while (1);
    }//2
    ps.enableDefault();
    
    //Display "begin" in teraterm and save it to SDcard
    pc.printf("begin\r\n");
    xbee.printf("begin\r\n");
    fprintf(fp,"begin\r\n");
    for (;;) {//2
    
        ////Variable definitions for command input
        //if (pc.readable()) xbee.putc(pc.getc());
        if (xbee.readable()) pc.putc(xbee.getc());
        
        wait_us(1);
        
        char cmd1 = xbee.getc();//cmd共有
        
        //Input "m", the sensor data is displayed on the teraterm.
        //And the acquired data is saved to the SD card.（機体の放出後→データを取る）
        if(cmd1 == 'm'){//3
        
            pc.printf("start\r\n");
            xbee.printf("start\r\n");
            t.start();
            //cmd = 0;
            pc.printf("p [mbar]\ta [m]\tdeg [C]\r\n");
            xbee.printf("p [mbar]\ta [m]\tdeg [C]\r\n");
            fprintf(fp,"p [mbar]\ta [m]\tdeg [C]\r\n");
            fclose(fp);
            
            while(1){//4
                //FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
                //if (pc.readable()) xbee.putc(pc.getc());
                if (xbee.readable()) pc.putc(xbee.getc());
            
                //The operation of saving the data obtained from 10 data acquired to the SD card is repeated 40 times.
                for(j=0;j<50;j++){//5
                    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
                    for(int i=0;i<10;i++){//6
                        count=count+1;
                        float pressure = ps.readPressureMillibars();
                        float altitude = ps.pressureToAltitudeMeters(pressure);
                        float temperature = ps.readTemperatureC();
                        pc.printf("%d %.2f\t \t%.2f \t%.2f \r\n",count,pressure,altitude,temperature);
                        xbee.printf("%d %.2f\t \t%.2f \t%.2f \r\n",count,pressure,altitude,temperature);
                        fprintf(fp,"%d %.2f\t \t%.2f \t%.2f \r\n",count,pressure,altitude,temperature);
                        wait_us(10);
                    }//5
                    fclose(fp);
                }//4
                
                //wait_us(10);
                FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
                pc.printf("end\r\n");
                pc.printf("time = %f",t.read());
                xbee.printf("end\r\n");
                xbee.printf("time = %f",t.read());
                fprintf(fp,"end\r\n");
                fprintf(fp,"time = %f",t.read());
                t.stop();
                fclose(fp);
                //cmd = 0;
                char cmd2 = xbee.getc();
                
                if(cmd2 == 'n'){//5
                    while(1){//6
                        if (xbee.readable()) pc.putc(xbee.getc());
                        char cmd3 = xbee.getc();//cmd共有
                        
                        for(j=0;j < sizeof(mm)/sizeof(mm[0]);j++) {//7
                            sound.attach(&tick,1.0/mm[j]/2.0);  //並列プログラムによるえらーなので,無視
                            wait(0.5f);
                            }//7
                            
                            sound.detach();
                            j = 0;
                            
                            if(cmd3 == 'k'){//7
                                pc.printf("end\r\n");
                                sound.detach();
                                //return 0;//end
                                }//7
                            }//6
                        }//5
                    }//4
            }//3
        }//2
}//1
