#include "mbed.h"
#include <math.h>

SPI spi(p5,p6,p7);
DigitalOut cs(p8);

Serial pc(USBTX,USBRX);

int main(){
    spi.format(7,0);
    spi.frequency(1000000);
    pc.printf("Starting ADC interaction\r\n");
    double y;
    
    while(1){
        cs=0;
        spi.write(0x60);
        
        uint8_t high= spi.write(0x00);
        uint8_t low = spi.write(0x00);
        
        low = (high << 5)|(low>>2);
        high=high>>3;
        
        int value=(high<<8)|low;
         y = 53.444*(double(value()),-1.736);
        pc.printf("sensor 0 value = %.3f[mm]\r\n",y);
        
        cs = 1;
        wait(1);
        }
        }