/*
MPU9250をi2c通信してみた。

1バイトずつ送受信する場合は、スタートコンディション・ストップコンディションなどのアドレス送信などの制御が必要です。
連続だったら、いいらしい。(参照　https://os.mbed.com/users/okini3939/notebook/I2C_jp/　)

「マスターが受信する」によって、取得するため

1.slave address(スレーブアドレス→内部レジスタ)
2.ack(受信)
3.data1(8bits)
4.ack=1(送信)
5.data2(8bits)
6.ack=1(送信)

(参照 http://www.picfun.com/c15.html )
*/

#include "mbed.h"

Serial pc(USBTX,USBRX);
I2C i2c(p9, p10);

const int addr = 0xD0;   //加速度とジャイロのスレーブアドレス

short int axl,axh; //x軸の加速度
short int ayl,ayh; //y軸の加速度
short int azl,azh; //z軸の加速度

short int gxl,gxh; //xの角速度
short int gyl,gyh; //yの角速度
short int gzl,gzh; //zの角速度

int main()
{
    i2c.frequency(100000);
    pc.printf("Start!!\r\n");
    
    while(1) {
        //加速度
        //x軸加速度取得
        
        //1.slave address(スレーブアドレス→内部レジスタ)
        i2c.start();
        i2c.write(addr);//　slaveアドレス
        i2c.write(0x3b);//　内部レジスタ(59)
        i2c.stop();
        
        //2.ack=0(受信)
        i2c.start();
        i2c.read(false); //ack(受信)
        //3.data1(8bits)
        i2c.write(0x3c);//data1(60)1
        i2c.stop();
        
        //4.ack=0(送信)
        i2c.start();
        i2c.write(addr|0x01); //ack=1(送信)
        axh = i2c.read(0);//data取り出す
        i2c.stop();
        
        i2c.start();
        //5.data2(8bits)
        i2c.write(0x3d);//data2(61)2
        //6.ack=1(送信)
        i2c.write(addr|0x01); //ack=1(受信)
        axl = i2c.read(0);//data取り出す
        i2c.stop();
        
        //以下2～6を繰り返す。
        
        
        //y軸加速度取得
        i2c.start();
        i2c.read(false); //ack(受信)
        i2c.write(0x3e); //data(62)3
        i2c.stop();
        
        i2c.start();
        i2c.write(addr|0x01); //ack=1(送信)
        ayh = i2c.read(0);//data取り出す
        i2c.stop();
        
        i2c.start();
        i2c.write(0x3f); //data(63)4
        i2c.write(addr|0x01); //ack=1(送信)
        ayl = i2c.read(0);//data取り出す
        i2c.stop();
        
        //z軸加速度取得
        i2c.start();
        i2c.read(false); //ack(受信)
        i2c.write(0x40); //data(64)5
        i2c.stop();
        
        i2c.start();
        i2c.write(addr|0x01); //ack=1(送信)
        azh = i2c.read(0);//data取り出す
        i2c.stop();
        
        i2c.start();
        i2c.write(0x41); //data(65)6
        i2c.write(addr|0x01); //ack=1(送信)
        azl = i2c.read(0);//data取り出す
        i2c.stop();
        
        
        //ジャイロセンサ
        //x
        i2c.start();
        i2c.read(false); //ack(受信)
        i2c.write(0x42); //data
        i2c.stop();
        
        i2c.start();
        i2c.write(addr|0x01); //ack=1(送信)
        gxh = i2c.read(0);//data取り出す
        i2c.stop();
        
        i2c.start();
        i2c.write(0x43); //data
        i2c.write(addr|0x01); //ack=1(送信)
        gxl = i2c.read(0);//data取り出す
        i2c.stop();
        
        //y
        i2c.start();
        i2c.read(false); //ack(受信)
        i2c.write(0x44); //data
        i2c.stop();
        
        i2c.start();
        i2c.write(addr|0x01); //ack=1(送信)
        gyh = i2c.read(0);//data取り出す
        i2c.stop();
        
        i2c.start();
        i2c.write(0x45); //data
        i2c.write(addr|0x01); //ack=1(送信)
        gyl = i2c.read(0);//data取り出す
        i2c.stop();
        
        //z
        i2c.start();
        i2c.read(false); //ack(受信)
        i2c.write(0x46); //data
        i2c.stop();
        
        i2c.start();
        i2c.write(addr|0x01); //ack=1(送信)
        gzh = i2c.read(0);//data取り出す
        i2c.stop();
        
        i2c.start();
        i2c.write(0x47); //data
        i2c.write(addr|0x01); //ack=1(送信)
        gzl = i2c.read(0);//data取り出す
        i2c.stop();
        
        
        double  acc_ax = short((axh<<8) | (axl));
        double  acc_ay = short((ayh<<8) | (ayl));
        double  acc_az = short((azh<<8) | (azl));
        
        double  acc_gx = short((gxh<<8) | (gxl));
        double  acc_gy = short((gyh<<8) | (gyl));
        double  acc_gz = short((gzh<<8) | (gzl));
        
        double AX = (acc_ax)*2/32768*9.81;
        double AY = (acc_ay)*2/32768*9.81;
        double AZ = (acc_az)*2/32768*9.81;
        
        double GX = (acc_gx)*0.0128114995; //0.02562299
        double GY = (acc_gy)*0.0128114995; //0.0128114995(測定レンジ±500)
        double GZ = (acc_gz)*0.0128114995;
        
        pc.printf("%f %f %f\r\n",AX,AY,AZ);
        pc.printf("%f %f %f\r\n",GX,GY,GZ);                             //GXがずれている
        wait(0.01);
    }
}