#include "mbed.h"
#include "QMC5883L.h"

QMC5883L qmc;

DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);

int main() {
    
qmc.init();

pc.baud(115200);

while(1) {
    
wait(0.001);

int mgx=qmc.getMagXvalue();
int mgy=qmc.getMagYvalue();
int mgz=qmc.getMagZvalue();

float mgxyz=sqrt(pow((float)mgx,2)+pow((float)mgy,2)+pow((float)mgz,2));
pc.printf("%d,%d,%d,%7.0f\n\r",mgx,mgy,mgz,mgxyz);

}
}