#ifndef __controller_h
#define __controller_h

#define PI 3.14159265358979 // 円周率πの定義

/*********** 使用するポート、サンプル時間、制御ゲインなどの設定 (ここから) ***************/
    // タイマーのサンプル周期等
#define TS0     0.002      // [s], timerTS0のサンプル時間（電流制御用）   sampling time (priority highest: Ticker IRQ) of motor current i control PID using timer interrupt
#define TS1     0.002      // [s], timerTS1のサンプル時間（位置制御用）   sampling time (priority high: RtosTimer) of motor angle th PID using rtos-timer
#define TS2     0.2        // [s], timerTS2のサンプル時間（不使用） sampling time (priority =main(): precision 4ms) to save data to PC using thread. But, max data length is 1000.
#define TS3     0.002      // [s], timerTS3のサンプル時間（データセーブ用） sampling time (priority low: precision 4ms)
#define TS4     0.2        // [s], timerTS4のサンプル時間（モニタ表示用）  sampling time (priority lowest: precision 4ms)  to display data to PC tera term
#define TMAX    5.0          // [s], プログラム開始から終了までの時間   experiment starts from 0[s] to TMAX[s]
#define N_DATA  1000        // PC上のmbed USB ディスクにセーブするデータの数

#define DA_PORT p18         // デバッグ用DAポート   analog out (DA) port of mbed
/*********** 使用するポートやサンプル時間、制御ゲインなどの設定 (ここから) ***************/

    // 制御器 K(s) の定数、変数の宣言
typedef struct struct_controller_parameters{
    float  y;          // 出力（制御量）
    float  r;          // 目標値
    float  u;          // 制御入力
    float  eI;         // 偏差eの積分値（積分項）
    float  e_old;      // 偏差eの1サンプル過去の値
    float  eI_old;     // 偏差eの積分値の1サンプル過去の値
}controller_parameters;

    // タイマー宣言
extern void timerTS0();    // TS0[s]ごとにコールされるタイマー   timer called every TS0[s].
extern void timerTS1(void const *argument);    // TS1[s]ごとにコールされるタイマー   timer called every TS1[s].
extern void timerTS2();    // TS2[s]ごとにコールされるタイマー   timer called every TS2[s].
extern void timerTS3();    // TS3[s]ごとにコールされるタイマー   timer called every TS3[s].
extern void timerTS4();    // TS4[s]ごとにコールされるタイマー   timer called every TS4[s].

extern void init_parameters();    // モータの機器定数等の設定, 制御器の初期化する関数の宣言

extern unsigned long _countTS0;   // TS0[s]ごとのカウント数
extern float   _time;          // [s], プログラム開始時からの経過時間

extern controller_parameters    K[2]; // 制御器の定数、変数

extern float data[][5];             // PC上のmbed USB ディスクにセーブするデータ   // memory to save data offline instead of "online fprintf".
extern unsigned short _countTS3_data;  // data[i][5]のカウンタ

#endif