#ifndef __fast_math_h
#define __fast_math_h

#define PI 3.14159265358979 // π: def. of PI
#define DEG60   512         // 60degを512に定義

extern unsigned short  sin60[]; // sin table from 0 to 60 deg. (max precision error is 0.003%)
// sin(th) = (float)(_sin(th/(PI/3.)*(float)DEG60+0.5))/65535.;
extern long _sin(unsigned short);    // return( 65535*sin(th) ), th=rad*DEG60/(PI/3)=rad*(512*3)/PI (0<=rad<2*PI)
extern long _cos(unsigned short);    // return( 65535*sin(th) ), th=rad*DEG60/(PI/3)=rad*(512*3)/PI (0<=rad<2*PI)
extern void init_fast_math();       // call before using _sin(). sin0-sin60deg; 0deg=0, 60deg=512

//extern float  norm(float);          // ２ノルムを計算
extern float  sqrt2(float x);         // √xのx=1まわりのテイラー展開 √x = 1 + 1/2*(x-1) -1/4*(x-1)^2 + ...

#endif