#ifndef __controller_h
#define __controller_h

#define PI 3.14159265358979 // 円周率πの定義

/*********** 使用するポート、サンプル時間、制御ゲインなどの設定 (ここから) ***************/
//#define SIMULATION          // ブラシ付DCモータの特性をシミュレーションするとき、コメント外す
//#define USE_CURRENT_CONTROL // 電流制御ありのとき、コメント外す   Current control on. Comment if current control off.

//#define DEADZONE_PLUS   0//1.  // deadzone of plus side
//#define DEADZONE_MINUS  0//-1.5 // deadzone of minus side

    // エンコーダの設定
#define N_ENC   (24*4)      // エンコーダ分解能（4逓倍）＝1回転分のパルス数×４    "*4": QEI::X4_ENCODING. Number of pulses in one revolution(=360 deg) of rotary encoder.
#define CH_A    p29         // A相用ポート   A phase port
#define CH_B    p30         // B相用ポート   A phase port

    // タイマーのサンプル周期等
//#define PWM_FREQ 10000.0   // [Hz], PWMチョッピング周波数  pwm freq. (> 1/(DEAD_TIME*10))
//#define DEADTIME 0.0001    // [s], デッドタイム（モータに加える電圧の正負が変わるときに上下アーム短絡を避けるために同時オフする時間）  // [s], deadtime to be set between plus volt. to/from minus
#define TS0     0.002      // [s], timerTS0のサンプル時間（電流制御用）   sampling time (priority highest: Ticker IRQ) of motor current i control PID using timer interrupt
#define TS1     0.002      // [s], timerTS1のサンプル時間（位置制御用）   sampling time (priority high: RtosTimer) of motor angle th PID using rtos-timer
#define TS2     0.2        // [s], timerTS2のサンプル時間（不使用） sampling time (priority =main(): precision 4ms) to save data to PC using thread. But, max data length is 1000.
#define TS3     0.002      // [s], timerTS3のサンプル時間（データセーブ用） sampling time (priority low: precision 4ms)
#define TS4     0.2        // [s], timerTS4のサンプル時間（モニタ表示用）  sampling time (priority lowest: precision 4ms)  to display data to PC tera term
//void    timerTS1(void const *argument), CallTimerTS3(void const *argument), CallTimerTS4(void const *argument);
//    RtosTimer RtosTimerTS1(timerTS1);  // RtosTimer priority is osPriorityAboveNormal, just one above main()
//    Thread ThreadTimerTS3(CallTimerTS3,NULL,osPriorityBelowNormal);
//    Thread ThreadTimerTS4(CallTimerTS4,NULL,osPriorityLow);
#define TMAX    5.0          // [s], プログラム開始から終了までの時間   experiment starts from 0[s] to TMAX[s]
#define N_DATA  1000        // PC上のmbed USB ディスクにセーブするデータの数

    // 電流制御マイナーループ
#define iKP    10./2     // [V/A], 電流制御PIDのPゲイン
#define iKI    100./2    // [V/A s], 電流制御PIDのIゲイン
#define iKD    0         // [V/A/s], 電流制御PIDのDゲイン
#define vMAX   3.3       // [V], 指令電圧の最大値（超えるとこの値に制限する）

    // 速度制御メインループ
#ifdef USE_CURRENT_CONTROL  // 電流制御ありのとき
 #define wKp 0.05               // [A/(rad/s)], 速度制御PIDのPゲイン
 #define wKi 2.50               // [A/(rad/s) s], 速度制御PIDのIゲイン
 #define wKd 0                  // [A/(rad/s)/s], 速度制御PIDのDゲイン
#else                       // 電流制御なしのとき
 #define wKp 0.05               // [A/(rad/s)], 速度制御PIDのPゲイン
 #define wKi 0.5//2.50          // [A/(rad/s) s], 速度制御PIDのIゲイン
 #define wKd 0.0005                // [A/(rad/s)/s], 速度制御PIDのDゲイン
#endif
#define iLPF   0.95         // 0-1, 速度に対する1次LPFの強さ; Low Pass Filter, G(z)=(1-a)/(z-a)
#define iMAX   1.0//3.3          // [A], 電流指令の最大値

#define DA_PORT p18         // デバッグ用DAポート   analog out (DA) port of mbed
/*********** 使用するポートやサンプル時間、制御ゲインなどの設定 (ここから) ***************/


    // モータの定数、信号などの宣言
typedef struct struct_motor_parameters{
 #ifdef SIMULATION // シミュレーションのとき
    float  L;      // [H], インダクタンス
    float  R;      // [Ω], モータ巻線抵抗
    float  phi;    // [V s], 永久磁石の鎖交磁束
    float  Jm;     // [Nms^2], イナーシャ
    float  Tm;     // [Nm], モータトルク
    float  TL;     // [Nm], 負荷トルク
    float  p;      // 極対数
 #endif
    float  th[2];  // [rad], モータの回転角, th[0]は現在の値, th[1]はTS0[s]だけ過去の値
    float  w;      // [rad/s], モータの回転速度
    float  w_lpf;  // [rad/s], フィルタで高周波ノイズを除去したモータ速度
    float  i;      // [A], モータ電流
    float  v;      // [V], モータ電圧
}motor_parameters;

    // 電流制御マイナーループの定数、変数の宣言
typedef struct struct_current_loop_parameters{
    float  i_ref;  // iの目標値
    float  v_ref;  // vの目標値
    float  eI;     // 電流制御用偏差の積分値（積分項）
    float  e_old;  // 電流制御用偏差の1サンプル過去の値
}current_loop_parameters;

    // 速度制御メインループの定数、変数の宣言
typedef struct struct_velocity_loop_parameters{
    float  w_lpf;          // [rad/s], モータ速度(LPF通過後)
    float  w_ref;          // [rad/s], モータ目標速度
    float  i_ref;          // 電流指令[A]
    float  eI;             // 速度制御用偏差の積分値（積分項）
    float  e_old;          // 速度制御用偏差の1サンプル過去の値
}velocity_loop_parameters;

    // タイマー宣言
extern void timerTS0();    // TS0[s]ごとにコールされるタイマー   timer called every TS0[s].
extern void timerTS1(void const *argument);    // TS1[s]ごとにコールされるタイマー   timer called every TS1[s].
extern void timerTS2();    // TS2[s]ごとにコールされるタイマー   timer called every TS2[s].
extern void timerTS3();    // TS3[s]ごとにコールされるタイマー   timer called every TS3[s].
extern void timerTS4();    // TS4[s]ごとにコールされるタイマー   timer called every TS4[s].

extern void init_parameters();    // モータの機器定数等の設定, 制御器の初期化する関数の宣言

extern unsigned long _countTS0;   // TS0[s]ごとのカウント数
extern float   _time;          // [s], プログラム開始時からの経過時間

extern motor_parameters            p;  // モータの定数、信号など
extern current_loop_parameters     il; // 電流制御マイナーループの定数、変数
extern velocity_loop_parameters    vl; // 速度制御メインループの定数、変数

extern float data[][5];             // PC上のmbed USB ディスクにセーブするデータ   // memory to save data offline instead of "online fprintf".
extern unsigned short _countTS3_data;  // data[i][5]のカウンタ

#endif