#ifndef __Hbridge_h
#define __Hbridge_h

//*************  使用するポートなどの設定 (ここから) *****************
#define PWM_FREQ 10000.0   // [Hz], PWMチョッピング周波数    pwm freq. (> 1/(DEAD_TIME*10))
#define DEADTIME 0.0001    // [s], デッドタイム（モータに加える電圧の正負が変わるときに上下アーム短絡を避けるために同時オフする時間）    // [s], deadtime to be set between plus volt. to/from minus
#define fwdIN_PORT    p21  //LED1    // ポート：fwdIN    port for U phase fwdIN arm
#define rvsIN_PORT    p22  // ポート：rvsIN    port for U phase rvsIN arm
#define PWM_WAVEFORM    0  // PWM変調方式 0: ノコギリ波比較, 1: 三角波比較    saw tooth wave comparison, 1: triangler wave comparison
#define TMIN            5  // [us], pwm_out()の演算時間    processing time of pwm_out()
#define R_SHUNT_P_PORT p19 // ポート：電流検出用シャント抵抗のプラス側アナログ入力
#define R_SHUNT_M_PORT p20 // ポート：電流検出用シャント抵抗のマイナス側アナログ入力
#define R_SHUNT     0.47   // [Ω], 電流検出用シャント抵抗値 shunt resistanse
//*************  使用するポートなどの設定 (ここまで) *****************

typedef struct struct_pwm_parameters{    // フルブリッジのパラメータ宣言    parameters of H bridge pwm
    float           duty;      // 0-1, PWMデューティ    duty of H bridge
    unsigned char   mode;      // チョッピングのオンオフを決定するモード
    long            fwdIN_us;  // [us], fwdINをオンする時間幅
    long            rvsIN_us;  // [us], rvsINをオンする時間幅
    unsigned char   fReverse;  // モータ逆回転フラグ：回転方向が順方向のとき0、逆方向のとき1。[0]が現在の値、[1]はその前の値    reverse direction?
    unsigned char   fDeadtime; // 正負切替時にデッドタイムを要求するフラグ    set deadtime? (v is plus to/from minus?)
}pwm_parameters;
extern pwm_parameters   IN;    // フルブリッジのパラメータ宣言

extern void start_pwm();    // PWMスタートする関数を宣言
extern void stop_pwm();     // PWMストップする関数を宣言
#endif