#ifndef __UVWpwm_h
#define __UVWpwm_h

//*************  User setting parameters (begin) *****************
//#define PWM_FREQ    0.5         //[Hz], pwm freq.
//#define DEADTIME    0.2         // [s], deadtime to be set between plus volt. to/from minus
#define U_UPPER_PORT    p21    // U相上アームUu用ポート
#define U_LOWER_PORT    p22    // U相下アームUd用ポート
#define V_UPPER_PORT    p23    // V相上アームVu用ポート
#define V_LOWER_PORT    p24    // V相下アームVd用ポート
#define W_UPPER_PORT    p25    // W相上アームWu用ポート
#define W_LOWER_PORT    p26    // W相下アームWd用ポート
#define PWM_WAVEFORM    1      // 0: saw tooth wave comparison, 1: triangler wave comparison
#define TMIN            3      // [us], processing time of pwm_out()

#define R_SHUNT_UP_PORT p16 // ポート：U相電流検出用抵抗の+側アナログ入力
#define R_SHUNT_UM_PORT p17 // ポート：U相電流検出用抵抗の-側アナログ入力
#define R_SHUNT_VP_PORT p19 // ポート：V相電流検出用抵抗の+側アナログ入力
#define R_SHUNT_VM_PORT p20 // ポート：V相電流検出用抵抗の-側アナログ入力
#define R_SHUNT     0.47   // [Ω], 電流検出用シャント抵抗の値
//*************  User setting parameters (end) *****************

typedef struct struct_pwm_parameters{ // UVW相pwm用の変数宣言
    float duty;          // 0-1, PWMデューティ
    unsigned char  mode; // チョッピングのオンオフを決定するモード
    long   upper_us;     // [us], 上アームをオンする時間幅
    long   lower_us;     // [us], 下アームをオンする時間幅
}pwm_parameters;
extern pwm_parameters     uvw[]; // UVW pwm の定数、変数

extern void start_pwm();
extern void stop_pwm();
#endif