#ifndef __controller_h
#define __controller_h

//#define PI 3.14159265358979 // def. of PI
/*********** User setting for control parameters (begin) ***************/
#define SIMULATION          // Comment this line if not simulation
#define USE_CURRENT_CONTROL // Current control on. Comment if current control off.
#define DEADZONE_PLUS   1.  // deadzone of plus side
#define DEADZONE_MINUS -1.5 // deadzone of minus side
    // encoder
#define N_ENC   (24*4)     // "*4": QEI::X4_ENCODING. Number of pulses in one revolution(=360 deg) of rotary encoder.
#define CH_A    p29         // A phase port
#define CH_B    p30         // A phase port

#define DA_PORT p18           // analog out (DA) port of mbed

#define PWM_FREQ 1000.0  //[Hz], pwm freq. (> 1/(DEAD_TIME*10))
#define DEADTIME    0.0001  // [s], deadtime to be set between plus volt. to/from minus
#define TS0     0.001//08//8      // [s], sampling time (priority highest: Ticker IRQ) of motor current i control PID using timer interrupt
#define TS1     0.002//0.01       // [s], sampling time (priority high: RtosTimer) of motor angle th PID using rtos-timer
#define TS2     0.2        // [s], sampling time (priority =main(): precision 4ms) to save data to PC using thread. But, max data length is 1000.
#define TS3     0.002        // [s], sampling time (priority low: precision 4ms)
#define TS4     0.2         // [s], sampling time (priority lowest: precision 4ms)  to display data to PC tera term
//void    timerTS1(void const *argument), CallTimerTS3(void const *argument), CallTimerTS4(void const *argument);
//    RtosTimer RtosTimerTS1(timerTS1);  // RtosTimer priority is osPriorityAboveNormal, just one above main()
//    Thread ThreadTimerTS3(CallTimerTS3,NULL,osPriorityBelowNormal);
//    Thread ThreadTimerTS4(CallTimerTS4,NULL,osPriorityLow);
#define TMAX    3.0          // [s], experiment starts from 0[s] to TMAX[s]
#define TMAX_FIND_ORIGIN    0.1//1.0          // [s], finding th origin starts from 0[s] to TMAX[s]

    // 電流制御マイナーループ
#define iKPd    10./2     // 電流制御d軸PIDのPゲイン (d-axis)
#define iKId    100./2    // 電流制御d軸PIDのIゲイン (d-axis)
#define iKDd    0         // 電流制御d軸PIDのDゲイン (d-axis)
#define iKPq    10./2     // 電流制御q軸PIDのPゲイン (q-axis)
#define iKIq    100./2    // 電流制御q軸PIDのIゲイン (q-axis)
#define iKDq    0         // 電流制御q軸PIDのDゲイン (q-axis)

#define vdqMAX  300.
#define SQRvdqMAX (vdqMAX*vdqMAX)   // [V^2] vdqの大きさの最大値の二乗

    // 速度制御メインループ
#ifdef USE_CURRENT_CONTROL
 #define wKp 0.05        // 速度制御PIDのPゲイン
 #define wKi 2.50        // 速度制御PIDのIゲイン
 #define wKd 0           // 速度制御PIDのDゲイン
#else
 #define wKp 0.005       // 速度制御PIDのPゲイン
 #define wKi 0.2         // 速度制御PIDのIゲイン
 #define wKd 0           // 速度制御PIDのDゲイン
#endif

#define iLPF    0.9     // 0-1, 速度に対する1次LPF; Low Pass Filter, G(z)=(1-a)/(z-a)
#define iqMAX   100       // [A], ｑ軸電流指令のMAX制限（異常に大きい指令値を制限する）

/*********** User setting for control parameters (end) ***************/


typedef struct struct_motor_parameters{
    // モータの定数、信号など
 #ifdef SIMULATION // シミュレーションのとき
    float  Ld;     // [H], d軸インダクタンス
    float  Lq;     // [H], q軸インダクタンス
    float  Lq0;    // 磁気飽和を考慮 (Lq = Lq0 - Lq1*iq)
    float  Lq1;    //
    float  R;      // [Ω], モータ各相巻線抵抗
    float  phi;    // [V s], 永久磁石の鎖交磁束
    float  Jm;     // [Nms^2], イナーシャ
    float  Tm;     // [Nm], モータトルク
    float  TL;     // [Nm], 負荷トルク
 #endif
    float  th[2];  // [rad].   ロータの位置, th[0]=th(t), th[1]=th(t-TS0)
    float  w;      // [rad/s], モータ速度
    float  w_lpf;  // [rad/s], フィルタで高周波ノイズを除去したモータ速度
    float  iab[2]; // [A], αβ軸電流 iab = [iα;iβ];
    float  idq[2]; // [A], dq軸電流 idq = [id;iq];
    float  vab[2]; // [V], αβ軸電圧 vab = [vα;vβ];
    float  vuvw[3];// [V], UVW相電圧 vuvw = [vu;vv;vw];
    float  iuvw[3];// [A], UVW相電流 iuvw = [iu;iv;iw];
    float  p;      // 極対数
    float  Cuvw[2][3]; // UVW座標からαβ座標への変換行列Cuvw
}motor_parameters;

typedef struct struct_current_loop_parameters{
    // 電流制御マイナーループの定数、変数
    float  idq_ref[2]; // idqの目標値
    float  vdq_ref[2]; // vdqの目標値
    float  eI_idq[2];  // 電流制御用偏差の積分値（積分項）
    float  e_old[2];   // 電流制御用偏差の1サンプル過去の値
}current_loop_parameters;

typedef struct struct_velocity_loop_parameters{
    // 速度制御メインループの定数、変数
    float  w_lpf;          // [rad/s], モータ速度(LPF通過後)
    float  w_ref;          // [rad/s], モータ目標速度
    float  tan_beta_ref;   // [rad],   モータ電流位相
    float  iq_ref;         // ｑ軸電流指令[A]
    float  eI;             // 速度制御用偏差の積分値（積分項）
    float  e_old;          // 速度制御用偏差の1サンプル過去の値
}velocity_loop_parameters;

extern void timerTS0();    // timer called every TS0[s].
extern void timerTS1(void const *argument);    // timer called every TS1[s].
extern void timerTS2();    // timer called every TS2[s].
extern void timerTS3();    // timer called every TS3[s].
extern void timerTS4();    // timer called every TS4[s].

extern void init_parameters();    // IPMSMの機器定数等の設定, 制御器の初期化

extern unsigned long _count;   // sampling number
extern float   _time;          // time[s]

extern unsigned short  f_find_origin;  // flag to find the origin of the rotor angle theta

extern motor_parameters            p;  // モータの定数、信号など
extern current_loop_parameters     il; // 電流制御マイナーループの定数、変数
extern velocity_loop_parameters    vl; // 速度制御メインループの定数、変数

extern float data[][5];    // memory to save data offline instead of "online fprintf".
extern unsigned short _count_data;    // counter for data[1000][5]

#endif