const char* hStreamName = "humidity";                      // Humidity stream ID
const char* tStreamName = "temp";                          // Temperature stream ID
const char* accelStreamNames[] = { "accelX", "accelY", "accelZ" };  // Accelerometer stream IDs

class Configuration {
public:
    char    deviceId[33],   // Device you want to post to
            m2xKey[33],     // Your M2X API Key or Master API Key
            udpHost[30],
            devIMEI[16];
            
    bool    enableM2X,
            enableCommands,
            enableUDP,
            m2xConfigured;
                        
    int     commandDelay,   // how many seconds we should wait between polling for a command
            commandPolls,   // how many times we should poll for a command
            udpPort;
            
    double  locLat,
            locLong;

    Configuration(): deviceId(""),
                    m2xKey(""),
                    enableM2X(true), 
                    enableCommands(false),                    
                    enableUDP(false),
                    commandDelay(10),
                    commandPolls(6)
    {
        if (cfg.read("/sd/config.ini")) {
            cfg.getValue("Device_ID", deviceId, sizeof(deviceId));
            cfg.getValue("M2X_Key", m2xKey, sizeof(m2xKey));
            cfg.getValue("UDP_Host", udpHost, sizeof(udpHost));
            cfg.getValue("IMEI", devIMEI, sizeof(devIMEI));
            
            char buff[15];
            int aux;
            
            if (cfg.getValue("Enable_M2X", buff, sizeof(buff)))
                enableM2X = strcmp(buff, "1") == 0;
            
            if (cfg.getValue("M2X_Commmands", buff, sizeof(buff)))
                enableCommands = strcmp(buff, "1") == 0;
            
            if (cfg.getValue("Enable_UDP", buff, sizeof(buff)))
                enableUDP = strcmp(buff, "1") == 0;
            
            if (cfg.getValue("Command_Wait", buff, sizeof(buff))) {
                aux = atoi(buff);
                if ((aux > 0) && (aux < 3600))
                    commandDelay = aux;
            };

            if (cfg.getValue("Command_Polls", buff, sizeof(buff))) {
                aux = atoi(buff);
                if ((aux > 0) && (aux < 10))
                    commandPolls = aux;
            };

            if (cfg.getValue("UDP_Port", buff, sizeof(buff))) {
                aux = atoi(buff);
                if ((aux > 0) && (aux < 65535))
                    udpPort = aux;
            };
                
            double lat, lon;
            
            if (cfg.getValue("Latitude", buff, sizeof(buff)))
                lat = atof(buff);
            
            if (cfg.getValue("Longitude", buff, sizeof(buff)))
                lon = atof(buff);
            
            if ((lat >= -90) && (lat <= 90) && (lon >= -180) && (lon <= 180)) {
                locLat = lat;
                locLong = lon;
            }
        }
        
        m2xConfigured = *deviceId && *m2xKey;
        
        enableCommands = enableM2X && enableCommands;
    };
    
    void dumpConfig(Serial& pc) {
        pc.printf("# config.ini" CRLF);
        pc.printf("Enable_M2X=%d" CRLF, enableM2X ? 1 : 0);
        pc.printf("Device_ID=%s" CRLF, deviceId);
        pc.printf("M2X_Key=%s" CRLF, m2xKey);
        pc.printf("M2X_Commands=%d" CRLF, enableCommands ? 1 : 0);
        pc.printf("#" CRLF);                
        pc.printf("Enable_UDP=%d" CRLF, enableUDP ? 1 : 0);        
        pc.printf("UDP_Host=%s" CRLF, udpHost);
        pc.printf("UDP_Port=%d" CRLF, udpPort);
        pc.printf("IMEI=%s" CRLF, devIMEI);
        pc.printf("Latitude=%f" CRLF, locLat);
        pc.printf("Longitude=%f" CRLF, locLong);
        pc.printf("#" CRLF);
        pc.printf("Command_Wait=%d" CRLF, commandDelay);
        pc.printf("Command_Polls=%d" CRLF, commandPolls);
        pc.printf("# Data will be sent every %d seconds" CRLF, commandPolls * commandDelay);
    }
        
private:
    ConfigFile cfg;
};