#include "mbed.h"
#include "hcsr04.h"
#include "math.h"

Serial pc(D8, D2);

DigitalIn digi(D6);
DigitalOut led(LED1);

//D12 TRIGGER D9 ECHO
HCSR04 sensor(D12, D9);

Timer t;

SPI max72_spi(D11,NC,D13);
DigitalOut load(D10);

int maxInUse = 1;

#define max7219_reg_noop   0x00
#define max7219_reg_digit0 0x01
#define max7219_reg_digit1 0x02
#define max7219_reg_digit2 0x03
#define max7219_reg_digit3 0x04
#define max7219_reg_digit4 0x05
#define max7219_reg_digit5 0x06
#define max7219_reg_digit6 0x07
#define max7219_reg_digit7 0x08
#define max7219_reg_decodeMode 0x09
#define max7219_reg_intensity 0x0a
#define max7219_reg_scanLimit 0x0b
#define max7219_reg_shutdown 0x0c
#define max7219_reg_displayTest 0x0f

#define MHZ 1000000

void maxSin(int reg,int col)
{
    load = 0;
    max72_spi.write(reg);
    max72_spi.write(col);
    load =1;
}
void maxall(int reg,int col)
{
    load = 0;
    for(int c=1; c<=maxInUse; c++) {
        max72_spi.write(reg);
        max72_spi.write(col);
    }
    load =1;
}
/*void maxOne(int NU,int reg,int col)
{
    int c=0;
    load = 0;
    for(c=maxInUse; c>NU; c--) {
        max72_spi.write(0);
        max72_spi.write(0);
    }
    max72_spi.write(reg);
    max72_spi.write(col);
    for(c=NU-1; c>=1; c--) {
        max72_spi.write(0);
        max72_spi.write(0);
    }
    load = 1;
}*/
void Set()
{
    max72_spi.format(8,0);

    maxall(max7219_reg_scanLimit,0x07);
    maxall(max7219_reg_decodeMode,0x00);
    maxall(max7219_reg_shutdown,0x01);
    maxall(max7219_reg_displayTest,0x00);
    for(int i=1; i<=8; i++) {
        maxall(i,0);
    }
    maxall(max7219_reg_intensity,0x0f&0x0f);

}
void loop()
{
    int i,j,k,f,n;
    double z=2;

    int q,w;
    int num1,num2,num3,num4;

    int hallState = 0;
    int count = 0;
    int speed;
    float rad = 1;
    int dis = 0;
    int di = 0;

    t.start();

    while(1) {


        if(pc.readable()) {
            num1 = pc.getc();
            num1 = pc.getc();
            num2 = pc.getc();
            num3 = pc.getc();
            num4 = pc.getc();

            //printf("%c%c%c%c\n",num1,num2,num3,num4);

            if(num1 == '#' && num4 == '$') {
                if(num2 == 'T') {
                    if(num3 == 'R') {
                        printf("%c%c%c%c\n",num1,num2,num3,num4);
                        //wait_ms(20);
                        for(j=8; j>=1; j--) {
                            for(n=8; n>=1; n--) {
                                q = (pow(z,j+1));
                                w = (pow(z,j));
                                i = (pow(z,j+2));
                                k = (pow(z,j-1));
                                maxSin(1,w);
                                maxSin(2,k);
                                maxSin(3,i);
                                maxSin(4,w);
                                maxSin(5,i);
                                maxSin(6,q);
                                maxSin(7,q);
                                maxSin(8,k);
                                wait_ms(5);
                                f++;
                                if(f>8) {
                                    f=0;
                                }
                            }
                        }
                    }
                    //TURN LEFT
                    if(num3 == 'L') {
                        printf("%c%c%c%c\n",num1,num2,num3,num4);
                        //wait_ms(20);
                        for(j=1; j<=8; j++) {
                            for(n=1; n<=8; n++) {
                                q = (pow(z,j-3));
                                w = (pow(z,j-2));
                                i = (pow(z,j-4));
                                k = (pow(z,j-1));
                                maxSin(1,w);
                                maxSin(2,k);
                                maxSin(3,i);
                                maxSin(4,w);
                                maxSin(5,i);
                                maxSin(6,q);
                                maxSin(7,q);
                                maxSin(8,k);
                                wait_ms(5);
                                f++;
                                if(f>8) {
                                    f=0;
                                }
                            }
                        }
                    }
                }

            }

            if(num2 == 'B' && num3 == 'R') {
                printf("%c%c%c%c\n",num1,num2,num3,num4);
                //wait_ms(20);

                maxSin(1,255);
                maxSin(2,255);
                maxSin(3,255);
                maxSin(4,255);
                maxSin(5,255);
                maxSin(6,255);
                maxSin(7,255);
                maxSin(8,255);

            }

            /*if(num2 == 'E' && num3 == 'M') {
                printf("%c%c%c%c\n",num1,num2,num3,num4);
                //wait_ms(20);

                maxSin(1,66);
                maxSin(2,66);
                maxSin(4,36);
                maxSin(6,36);
                maxSin(8,255);
                wait(0.10);
                maxSin(1,0);
                maxSin(2,0);
                maxSin(4,0);
                maxSin(6,0);
                maxSin(8,0);
                wait(0.10);
            }*/



            //if(num2 == 'M' && num3 == 'D') {
            //printf("%c%c%c%c\n",num1,num2,num3,num4);
            //wait_ms(20);
            else {

                //printf("%c%c%c%c\n",num1,num2,num3,num4);
                //wait_ms(20);

                maxSin(1,0);
                maxSin(2,0);
                maxSin(3,0);
                maxSin(4,0);
                maxSin(5,0);
                maxSin(6,0);
                maxSin(7,0);
                maxSin(8,0);


            }
        }
        
        hallState = digi.read();

        if(t.read()<=1) {

            if (hallState == 0) {
                // turn LED on:
                led = 1;
                //wait_ms(5);
                //printf("%d\n",hallState);
                //wait(0.5);
                count++;
                ++dis;
                //pc.printf("%d\n",count);
                //wait_ms(50);

            } else {
                // turn LED off:
                led = 0;
                //wait_ms(5);
                //printf("%d\n",hallState);
                //wait(0.5);
            }
        } else {

            di = (dis*rad);

            speed = count*rad;
            speed = speed*(3.6);
            //speed = 79.2;

            //printf("%d\n",speed);
            //pc.printf("#S%02d$",speed);

            long distance = sensor.distance();

            pc.printf("#");
            //printf("#");
            if(distance >= 570 && distance < 620) {
                pc.printf("#D00S%02dK%03d$",speed,di);
                //printf("#D00$");
                //printf("#D00S%02dK%03d$",speed,di);
            } else if(distance >= 520 && distance < 570) {
                pc.printf("#D01S%02dK%03d$",speed,di);
                //printf("#D01$");
                //printf("#D01S%02dK%03d$",speed,di);
            } else if(distance >= 470 && distance < 520) {
                pc.printf("#D02S%02dK%03d$",speed,di);
                //printf("#D02$");
                //printf("#D02S%02dK%03d$",speed,di);
            } else if(distance >= 420 && distance < 470) {
                pc.printf("#D03S%02dK%03d$",speed,di);
                //printf("#D03$");
                printf("#D03S%02dK%03d$",speed,di);
            } else if(distance >= 370 && distance < 420) {
                pc.printf("#D04S%02dK%03d$",speed,di);
                //printf("#D04$");
                //printf("#D04S%02dK%03d$",speed,di);
            } else if(distance >= 220 && distance < 370) {
                pc.printf("#D05S%02dK%03d$",speed,di);
                //printf("#D05$");
                //printf("#D05S%02dK%03d$",speed,di);
            } else if(distance >= 170 && distance < 220) {
                pc.printf("#D06S%02dK%03d$",speed,di);
                //printf("#D06$");
                //printf("#D06S%02dK%03d$",speed,di);
            } else if(distance >= 120 && distance < 170) {
                pc.printf("#D07S%02dK%03d$",speed,di);
                //printf("#D07$");
                //printf("#D07S%02dK%03d$",speed,di);
            } else if(distance >= 70 && distance < 120 ) {
                pc.printf("#D08S%02dK%03d$",speed,di);
                //printf("#D08$");
                //printf("#D08S%02dK%03d$",speed,di);
            } else if(distance <= 70) {
                pc.printf("#D09S%02dK%03d$",speed,di);
                //printf("#D09S%02dK%03d$",speed,di);
                //printf("#D09$");
            } //else {
            // pc.printf("%d cm",distance);
            //}

            count = 0;
            t.reset();
        }
    }
}

int main()
{
    Set();
    loop();
}