#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "DS1820.h"
#include "SWO.h"
#define     SENSORS_COUNT   64 

 //Serial      pc(USBTX, USBRX);
 SWO_Channel swo("channel");

 DigitalOut  led(LED1);
 OneWire     oneWire(PG_6);            // substitute D8 with actual mbed pin name connected to the DS1820 data pin
 DS1820*     ds1820[SENSORS_COUNT];
 int         sensors_found = 0;      // counts the actually found DS1820 sensors
 float       temp = 0;
 int         result = 0;

int main()
{
    uint8_t string[50] = {0};
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    int i = 0;

while(1) {
    swo.printf("\r\n Starting \r\n");

     //Enumerate (i.e. detect) DS1820 sensors on the 1-wire bus
     for(i = 0; i < SENSORS_COUNT; i++) {
         ds1820[i] = new DS1820(&oneWire);
         if(!ds1820[i]->begin()) {
             delete ds1820[i];
             break;
         }
     } 

     sensors_found = i;    
     if (sensors_found == 0) {
         swo.printf("No DS1820 sensor found!\r\n");
//         return -1;
     }
     else
         swo.printf("Found %d sensors.\r\n", sensors_found);
  

         swo.printf("-------------------\r\n");

//         for(i = 0; i < sensors_found; i++)
//             ds1820[i]->startConversion();   // start temperature conversion from analog to digital       
//         wait(1.0);                          // let DS1820s complete the temperature conversion
//         for(int i = 0; i < sensors_found; i++) {
//             if(ds1820[i]->isPresent())
//                 swo.printf("temp[%d] = %3.1f%cC\r\n", i, ds1820[i]->read(), 176);     // read temperature
//         }

        swo.printf("\r\n Start display \r\n");
        BSP_LCD_Clear(LCD_COLOR_PETROL);
        BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
        BSP_LCD_SetBackColor(LCD_COLOR_PETROL);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);

        BSP_LCD_DisplayStringAt(0, 1, (uint8_t *)"MBED Robin", CENTER_MODE);

        BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
        BSP_LCD_DisplayStringAt(0, 100, (uint8_t *)"DISCOVERY STM32F746NG", CENTER_MODE);

        //probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        //printf("It is %3.1foC\r\n", probe.temperature());
        //temp=probe.temperature();
        //BSP_LCD_DisplayStringAt(20, 175, string, LEFT_MODE);
        HAL_Delay(1000);
    }

}
