#include "mbed.h"
#include "EthernetInterface.h"
#include "nowy_brzydki_plik.h"

 
#define MBED_DEV_IP       "192.168.0.52"
#define MBED_DEV_MASK     "255.255.255.0"
#define MBED_DEV_GW       "0.0.0.0"
#define ECHO_SERVER_PORT   5000


Serial s(USBTX, USBRX);
volatile char   c = '\0'; // Initialized to the NULL character
 uint32_t data;
 
/*! @brief Defines the PHY register.*/
typedef enum _enet_phy_register
{
    kEnetPhyCR = 0, /*!< PHY control register */
    kEnetPhySR = 1, /*!< PHY status register*/
    kEnetPhyId1 = 2, /*!< PHY identification register 1*/
    kEnetPhyId2 = 3, /*!< PHY identification register 2*/
    kEnetPhyCt2 = 0x1e /*!< PHY control2 register*/
} enet_phy_register_t;
 /*! @brief Defines the PHY status.*/
typedef enum _enet_phy_status
{
    kEnetPhyLinkStatus = 0x4,  /*!< ENET PHY link status bit*/
    kEnetPhyAutoNegAble = 0x08, /*!< ENET PHY auto negotiation ability*/
    kEnetPhyAutoNegComplete = 0x20, /*!< ENET PHY auto negotiation complete*/
    kEnetPhySpeedDulpexMask = 0x07 /*!< ENET PHY speed mask on status register 2*/
} enet_phy_status_t;
/*! @brief Defines the control flag.*/
typedef enum _enet_phy_control
{
    kEnetPhyAutoNeg = 0x1000,/*!< ENET PHY auto negotiation control*/
    kEnetPhySpeed = 0x2000, /*! ENET PHY speed control*/
    kEnetPhyLoop = 0x4000, /*!< ENET PHY loop control*/
    kEnetPhyReset = 0x8000, /*!< ENET PHY reset control*/
    kEnetPhy10HalfDuplex = 0x01, /*!< ENET PHY 10 M half duplex*/
    kEnetPhy100HalfDuplex = 0x02,/*!< ENET PHY 100 M half duplex*/
    kEnetPhy10FullDuplex = 0x05,/*!< ENET PHY 10 M full duplex*/
    kEnetPhy100FullDuplex = 0x06/*!< ENET PHY 100 M full duplex*/
} enet_phy_control_t;
typedef enum _enet_phy_speed
{
    kEnetSpeed10M = 0,   /*!< ENET PHY 10 M speed*/
    kEnetSpeed100M = 1  /*!< ENET PHY 100 M speed*/
} enet_phy_speed_t;

typedef enum _link_md
{
    autoMDIRegister = 0x1F,   /*!< ENET PHY 10 M speed*/
        disableAutoMDI = 0x2000,
        startCableDiagREgister = 0x1D,
        enableCableDiag = 0x8000
} link_md_t;

void onCharReceived()
{
    c = s.getc();
}
void baud(int baudrate) {
    
    s.baud(baudrate);
}

 uint32_t mii_read_data(uint32_t phyReg, uint32_t *dataPtr)
{
    //uint32_t instance, uint32_t phyAddr, uint32_t phyReg, uint32_t *dataPtr
    return enet_mii_read(0,0,phyReg,dataPtr);
}
 uint32_t mii_write_data(uint32_t phyReg, uint32_t dataToWtite)
{
    //enet_mii_write(uint32_t instance, uint32_t phyAddr, uint32_t phyReg, uint32_t data)
    return enet_mii_write(0,0,phyReg,dataToWtite);
}

void change_speed(uint32_t phyReg,uint32_t new_speed){
    
    mii_write_data(phyReg,new_speed);

}
 void turn_on_autonegotiation(uint32_t phyReg,uint32_t message){
        mii_write_data(phyReg,message);
 }

int get_connection_speed(uint32_t phyReg, uint32_t *dataPtr)
{
    mii_read_data(phyReg,dataPtr);
    data &=kEnetPhySpeedDulpexMask; 
  if ((kEnetPhy100HalfDuplex == data) || (kEnetPhy100FullDuplex == data))
   {
      return 100;
   }

    return 10  ;
}
 
int main (void) {
int speed;
    baud(115200);
    
        
  EthernetInterface eth;
    printf("Initializing interface...\r\n");
  eth.init(MBED_DEV_IP, MBED_DEV_MASK, MBED_DEV_GW); //Assign a device ip, mask and gateway
    
    
    printf ("Hello World! Enter task number:\n");
    onCharReceived();
    switch(c){
        case '1': 
            {
            printf("LEts find out about RJ-45 socket diodes\n");
            printf("Connecting to network...\r\n");
            printf("Wait for red LED and connect with putty\n");
            eth.connect(); 
            printf("IP Address is %s\n", eth.getIPAddress());
            
            TCPSocketServer server;
            server.bind(ECHO_SERVER_PORT);
            server.listen();
            DigitalOut myled(LED1);
    
            while (true) {
                printf("Write a message in putty \n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 3000); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
       client.close();
            }
            break;
            }
        case '2': 
        {
            printf("LEts check transmission speed\n");
            printf("Connecting to network...\r\n");
            eth.connect(); 
            speed = get_connection_speed(kEnetPhyCt2, &data);
            printf("Connected at %d Mb/s\r\n", speed);
            printf("IP Address is %s\n", eth.getIPAddress());
            break;
        }
        case '3':{
            printf("Lets change speed\n");
            printf("Changing speed to 10Mb\n");
            printf("Connecting to network...\r\n");
            change_speed(kEnetPhyCR, kEnetSpeed10M);
            eth.connect(); 
            printf("IP Address is %s\n", eth.getIPAddress());
            speed = get_connection_speed(kEnetPhyCt2, &data);
            printf("Connected at %d Mb/s\r\n", speed);

                break;
        }
        case '4':{
            uint32_t counter;
             uint32_t data1;
 
            printf("Autonegotiation\n");

            speed = get_connection_speed(kEnetPhyCt2, &data);
            printf("Connected at %d Mb/s\r\n", speed);
            printf("Changing speed to 10Mb\n");
            change_speed(kEnetPhyCR, kEnetSpeed10M);
            turn_on_autonegotiation(kEnetPhyCR, kEnetPhyAutoNeg);
            
            for (counter = 0; counter < 0x10000; counter++)
            {
                if (enet_mii_read(0,0,kEnetPhySR,&data1) == 0)
                {
                    if ((data1 & kEnetPhyAutoNegComplete) != 0)
                    {
                                                printf("Autonegotiaion enabled\n");
                                                break;
                    }
                }                       
            }
            
            printf("Connecting to network...\r\n");
            eth.connect(); 
            
            speed = get_connection_speed(kEnetPhyCt2, &data);
            printf("Connected at %d Mb/s\r\n", speed);
            break;
        }
        case '5':
        {
            uint32_t counter;
             uint32_t data1;
            double result;
            printf("Cable Test...\n");
            printf("Disable auto MDI/MDI-X\n");
            mii_write_data(autoMDIRegister,disableAutoMDI);
            printf("Start cable diagnostic\n");
            mii_write_data(startCableDiagREgister,enableCableDiag);
            printf("Wait ...\n");
                        for (counter = 0; counter < 0x10000; counter++)
            {
                if (enet_mii_read(0,0,startCableDiagREgister,&data1) == 0)
                {
                    if (!(data1 & enableCableDiag))
                    {
                                                printf("Test completed\n");
                                                break;
                    }
                }                       
            }
                        if ((data1 & 0x6000))
                            printf("Test failed\n");
            printf("Print data %d\n", data);
            result = (double)(0x00FF & data1);
            printf("Result = %lf \n", result*0.38);
            break;
        }
        default: break;
    }       
    while(1);
}

