/* Program for Standard Timer */
#include "mbed.h"
#include "Watchdog1.h"

// Host PC Communication channels
//Serial pc(SERIAL_TX, SERIAL_RX); // tx, rx
Serial pc(USBTX, USBRX);

int PT = 120; // Purge time in seconds
int RT = 60; // Repressurisation time in seconds
int USBC = 0; // USB Communication

Watchdog wd;

Ticker              timeKeeping;

DigitalOut my_RHMV(A2); //RHMV
DigitalOut my_RV(A1); //RV
DigitalOut my_RHPV(A0); //RHPV
DigitalOut my_LHPV(A3); //LHPV
DigitalOut my_led(LED1);  //ONLED

DigitalOut my_RHPVLED(D6); //RHPVLED
DigitalOut my_RHMVLED(D5); //RHMVLED
DigitalOut my_RVLED(D4); //RVLED
DigitalOut my_LHMVLED(D3); //RHMVLED
DigitalOut my_LHPVLED(D2); //LHPVLED

int secondscounter = 0;

int LHCT = PT + RT; // LH cycle time
int LHPT = PT + RT + PT; // LH purge time
int CT = PT + RT + PT + RT; // Cycle Time

int main()
{
    my_RHMV = 0;
    my_RHPV = 1;
    my_LHPV = 0;
    my_RV = 0;

    wd.Configure(4.0);

    pc.printf("Dryer Start\r\n");

    while(1) {

        wd.Service();
        my_led = !my_led;
        secondscounter = secondscounter + 1;
        wait(1);

        if (USBC == 1) {

            if (secondscounter <= PT) {
                pc.printf("RH DRYING LH REGEN\r\n");
            }
            if (secondscounter > PT && secondscounter <= LHCT) {
                pc.printf("RH DRYING LH REPRESS\r\n");
            }
            if ((secondscounter > LHCT) && (secondscounter <= LHPT)) {
                pc.printf("LH DRYING RH REGEN\r\n");
            }
            if (secondscounter > LHPT && (secondscounter <= CT)) {
                pc.printf("LH DRYING RH REPRESS\r\n");
            }
        } // (USB == 1)

        if (secondscounter <= PT) {

            my_RHMV = 0;
            my_RHPV = 1;
            my_LHPV = 0;
            my_RV = 0;

            my_RHPVLED = 1;  //RHPVLED
            my_RHMVLED = 0;  //RHMVLED
            my_RVLED = 0;  //RVLED
            my_LHMVLED = 1;  //LHMVLED
            my_LHPVLED = 0;  //LHPVLED
        }
        if (secondscounter > PT && secondscounter <= LHCT) {
            my_RHMV = 0;
            my_RHPV = 0;
            my_LHPV = 0;
            my_RV = 1;

            my_RHPVLED = 0;  //RHPVLED
            my_RHMVLED = 0;  //RHMVLED
            my_RVLED = 1;  //RVLED
            my_LHMVLED = 1;  //LHMVLED
            my_LHPVLED = 0;  //LHPVLED
        }

        if ((secondscounter > LHCT) && (secondscounter <= LHPT)) {

            my_RHMV = 1;
            my_RHPV = 0;
            my_LHPV = 1;
            my_RV = 0;

            my_RHPVLED = 0;  //RHPVLED
            my_RHMVLED = 1;  //RHMVLED
            my_RVLED = 0;  //RVLED
            my_LHMVLED = 0;  //LHMVLED
            my_LHPVLED = 1;  //LHPVLED
        }

        if (secondscounter > LHPT && (secondscounter <= CT)) {
            my_RHMV = 1;
            my_RHPV = 0;
            my_LHPV = 0;
            my_RV = 1;

            my_RHPVLED = 0;  //RHPVLED
            my_RHMVLED = 1;  //RHMVLED
            my_RVLED = 1;  //RVLED
            my_LHMVLED = 0;  //LHMVLED
            my_LHPVLED = 0;  //LHPVLED
        }

        if (secondscounter == (CT)) {
            secondscounter = 0;
        }
    }//While
}//main()