#include "HYT.h"
#include "mbed.h"

HYT::HYT(PinName sda, PinName scl) : _i2c(sda, scl)
{
}

/*************************************************************************************************************************/
void HYT::MRCommand(void)
{
    _i2c.write(HYT_ADDR, 0, 0);
}


/*************************************************************************************************************************/
int HYT::DFCommand(void)
{
    char    dataI2C[4];
    int     stateBit;
    int     humidityRaw;
    int     temperatureRaw;

    _i2c.read(HYT_ADDR, dataI2C, 4);

    stateBit = (dataI2C[0] & 0x40) >> 6;
    if (stateBit == 0) {
        humidityRaw = ((dataI2C[0] & 0x3F) << 8) | dataI2C[1];
        temperatureRaw = ((dataI2C[2] << 8) | dataI2C[3]) >> 2;
        if (temperatureRaw < 0x3FFF && humidityRaw < 0x3FFF) {
            temperature = ((float)(temperatureRaw) * 165.0f / 16383.0f) - 40.0f;
            humidity = (float)humidityRaw * 100.0f / 16383.0f;
        } else {
            // sensor returns wrong data (1111...11)
            return -1;
        }
    } else {
        // no new value received from sensor
        return -2;    
    } 
    
    return 0;
}