#include "mbed.h"
#include "TextLCD.h"
#include "HYT.h"
#include "Watchdog.h"

// Setup Hardware
HYT SENSOR (D0,D1); //Nucleo (SDA,SCL) (D0,D1) (D4,D5)
TextLCD lcd(D9, D6, D5, D4, D3, D2); // rs, e, d4-d7

// Setup Watchdog
Watchdog wd;

//Define Pins
AnalogOut AOUT(A3);
DigitalOut my_led(LED1);
DigitalOut Alarm_led(A7);

//Setup Timer
Ticker timeKeeping;

//Setup Variables
float Calibration = 0; // RH correction value
float SetPoint = 5; // Max Dew Point in Celsius to trigger alarm.
int Counter = 0;
float RHValue = 0;
float TempValue = 0;
float A = 0;
float DewPoint = -50;
float sample = 0;
float test = 0;

int main() {
    //lcd.printf("Hello World5!\n");
    Alarm_led=1;
    //lcd.setBacklight(TextLCD::LightOn);
    //lcd.setCursor(TextLCD::CurOff_BlkOff);
    wd.Configure(4.0);

    wait_ms(100);

    lcd.printf("TegnonEfficiency\n");
    lcd.locate(0,1);
    lcd.printf("Dew Point Sensor\n");

    wait_ms(1000);

    lcd.cls();

    lcd.printf("Dew Point:");
    lcd.locate(0,1);
    lcd.printf("RH:");
    lcd.locate(8,1);
    lcd.printf("T:");

while(1) {
        Counter = Counter + 1;
        wait(1);
        wd.Service();
        my_led = !my_led;

if(Counter == 10)
{
    lcd.cls();
    lcd.printf("Dew Point:");
    lcd.locate(0,1);
    lcd.printf("RH:");
    lcd.locate(8,1);
    lcd.printf("T:");
    Counter = 0;
    }

        if(DewPoint > SetPoint) {
            Alarm_led = !Alarm_led;
        } else {
            Alarm_led=1;
        }

        SENSOR.MRCommand();
        wait_ms(100);
        SENSOR.DFCommand();
        wait_ms(100);
              
            RHValue = (SENSOR.humidity);
            TempValue = (SENSOR.temperature);

 if(RHValue > 1)
 {      

            A = log( RHValue * 0.01 * pow(10, 7.5*TempValue/(237.2+TempValue) )  );
            DewPoint = ( 23720 * A/(17.269-A))/100;

            if(DewPoint < -50) {
                DewPoint = -50;
            }

            if(DewPoint > 20) {
                DewPoint = 20;
            }

        test = 0.01428728*DewPoint+0.714364;

            lcd.locate(10,0);
            lcd.printf("      ");
            lcd.locate(10,0);
            lcd.printf("%.1f%", DewPoint);
            lcd.printf("C");
            lcd.locate(3,1);
            lcd.printf("     ");
            lcd.locate(3,1);
            lcd.printf("%.1f%", RHValue);
            lcd.locate(10,1);
            lcd.printf("      ");
            lcd.locate(10,1);
            lcd.printf("%.1f%", TempValue);
            lcd.printf("C\n");

            AOUT = 0.0142857142857143*DewPoint+0.7142857143;
        
            }
            else
            {
                AOUT = 0;
                lcd.cls();
                wait_ms(1000);
                lcd.locate(0,0);
                lcd.printf("     Sensor     \n");
                lcd.locate(0,1);
                lcd.printf("      Error     \n");
                }
                
    } // While(1)
} //Void Main


