//Import Libraries
#include "mbed.h"
#include "TextLCD.h"
#include "Watchdog.h"
#include "millis.h"

//Dryer Cycle
int PT = 120; // Purge time in seconds
int RT = 60; // Repressurisation time in seconds
int IdleTimeHrs = 12; // cycle activated every x hours to lubricate valves.
int LCycles = 2; //Number of lubication cycles

//Dew Point Setpoint
float SetPoint = -40; // Dew Point Set Point

//Watchdog
Watchdog wd;

//Screen Setup
TextLCD lcd(D6, D9, D2, D3, D4, D5); // rs, e, d4-d7

//Define clock
Ticker              timeKeeping;

//Pin Allocation
DigitalOut my_RHPV(A0);
DigitalOut my_RHMV(A1);
DigitalOut my_RV(A2);
DigitalOut my_LHMV(A6);
DigitalOut my_LHPV(A7);
DigitalOut my_led(D13);
DigitalIn my_Dip2(D11);  //Dip 2
DigitalIn my_Dip1(D12);  //Dip 1
AnalogIn DP_In(A3);

//Counters
unsigned long previousMillis = 0;        // will store last time LED was updated
long OnTime = 1000;                     // milliseconds of on-time
int secondscounter = 0;                 // counts the seconds of the cycle
int Counter = 0;                        // used to reset the screen every 10 seconds
int Cycledryercounter = 0;              // used to cycle the dryer for 5 cycles if the dryer has been idle for 24hrs.
int Idlecounter = 0;                    // used to accumulate the cummulative idle time.
int Valuecounter = 0;                   // used to calculate the weighted average of the dewpoint.
//int IdleTimeSeconds = 180; //idle time in seconds
int IdleTimeSeconds = IdleTimeHrs * 60 * 60; //idle time in seconds
int LCycleseconds = LCycles * 360 - 20; // Lubrication cycles in seconds

//Variables
int LHCT = PT + RT; // LH cycle time
int RHPT = PT + RT + PT; // RH purge time
int CT = PT + RT + PT + RT; // Cycle Time
float RHValue = 0; //RH from dew point sensor
float TempValue = 0; //Temp from dew point sensor
float DewPoint = 0; //Calculated dew point
float Value1 = 0; //first sensor reading
float Value2 = 0; //second sensor reading
float Value3 = 0; //third sensor reading

int main()
{

//This piece of code runs once at start-up:
//________________________________________

    my_RHMV = 1;//0
    my_LHMV = 0;//1
    my_RHPV = 0;//1
    my_LHPV = 0;//1
    my_RHPV = 1;//0
    my_LHPV = 0;//1
    my_RV = 0;//1

    wd.Configure(4.0);

    wait_ms(100);
    lcd.printf("TegnonEfficiency\n");
    lcd.locate(0,1);
    lcd.printf("   DP Control  \n");

    wait_ms(1000);
    lcd.cls();
    lcd.printf("Dew Point:");
    lcd.locate(0,1);
    lcd.printf("Set Point:");

    millisStart();

    while(1) {

//This piece of code runs every millisecond for ever:
//___________________________________________________


        unsigned long currentMillis = millis(); // Get current time

        if(Cycledryercounter >= 1) {
            SetPoint = -110;

        } else {
            if(my_Dip2 ==0) {
                if(my_Dip1 ==0) {
                    SetPoint = -20;
                }
                if(my_Dip1 ==1) {
                    SetPoint = -40;
                }
            }
            if(my_Dip2 ==1) {
                if(my_Dip1 ==0) {
                    SetPoint = -60;
                }
                if(my_Dip1 ==1) {
                    SetPoint = -80;
                }
            }
        }

        if (secondscounter < PT) {
            my_RHMV = 1;//0
            my_LHMV = 0;//1
            my_RHPV = 1;//0
            my_LHPV = 0;//1
            my_RV = 0;//1
        }
        if (secondscounter >= PT && secondscounter < LHCT) {
            my_RHMV = 1;//0
            my_LHMV = 0;//1
            my_RHPV = 0;//1
            my_LHPV = 0;//1
            my_RV = 1;//0

        }

        if ((secondscounter > LHCT) && (secondscounter < RHPT)) {
            my_RHMV = 0;//1
            my_LHMV = 1;//0
            my_RHPV = 0;//1
            my_LHPV = 1;//0
            my_RV = 0;//1
        }
        if (secondscounter >= RHPT && (secondscounter < CT)) {
            my_RHMV = 0;//1
            my_LHMV = 1;//0
            my_RHPV = 0;//1
            my_LHPV = 0;//1
            my_RV = 1;//0
        }

//This piece of code runs every second for ever:
//______________________________________________

        if ((currentMillis - previousMillis) >= OnTime) {
            previousMillis = currentMillis;
            wd.Service();
            my_led = !my_led;

            secondscounter = secondscounter + 1;
            Counter = Counter + 1;

            if(Cycledryercounter >= 1) {
                Cycledryercounter = Cycledryercounter + 1;
            }

            if(Counter == 10) {
                lcd.cls();
                lcd.printf("Dew Point:");
                lcd.locate(0,1);
                lcd.printf("Set Point:");
                Counter = 0;
            }

           // if(Valuecounter ==0) {
              //  Value1 = DP_In.read()*100 - 80;
            //}

            //if(Valuecounter ==1) {
            //    Value2 = DP_In.read()*100 - 80;
            //}

            //if(Valuecounter ==2) {
            //    Value3 = DP_In.read()*100 - 80;
            //}

            //Valuecounter = Valuecounter +1;

            DewPoint = DP_In.read()*100 - 100;

            lcd.locate(10,0);
            lcd.printf("      ");
            lcd.locate(10,0);
            lcd.printf("%3.1f%", DewPoint);
            lcd.locate(10,1);
            lcd.printf("      ");
            lcd.locate(10,1);
            lcd.printf("%3.1f%", SetPoint);


//Delay cycle if the Dewpoint is lower than the setpoint:
//_______________________________________________________

            if ((DewPoint <  SetPoint)  && (secondscounter == LHCT)) {
                secondscounter = secondscounter - 1;
                Idlecounter = Idlecounter + 1;
            }

            if ((DewPoint <  SetPoint)  && (secondscounter == CT)) {
                secondscounter = secondscounter - 1;
                Idlecounter = Idlecounter + 1;
            }

            if (DewPoint >=  SetPoint) {
                Idlecounter = 0;
            };

//Set Counters:
//____________

            if(Idlecounter == IdleTimeSeconds) {
                Cycledryercounter = 1;
            }

            if(Cycledryercounter == LCycleseconds) {
                Cycledryercounter = 0;
            }

            if(Valuecounter == 2) {
                Valuecounter = 0;
            }

            if (secondscounter == (CT + 1)) {
                secondscounter = 0;
            }

        } // Loop for every second
    } // While(1) - Every millisecond
} //Void Main - Once
