#include "mbed.h"
#include "TextLCD.h"
#include "HYT.h"
#include "Watchdog.h"
#include "millis.h"

int PT = 120; // Purge time in seconds
int RT = 60; // Repressurisation time in seconds
float SetPoint = -3; // Dew Point Set Point
int ClimateControl = 0; // Switch On Climate Control
float DewPointSuppresion = 20; // Set Dew Point Suppression

//Watchdog
Watchdog wd;

HYT SENSOR (D0,D1); //Nano (SDA,SCL) (D0,D1) (D4,D5)
TextLCD lcd(D6, D9, D2, D3, D4, D5); // rs, e, d4-d7

Ticker              timeKeeping;

DigitalOut my_RHPV(A0);
DigitalOut my_RHMV(A1);
DigitalOut my_RV(A2);
DigitalOut my_LHMV(A6);
DigitalOut my_LHPV(A7);
DigitalOut my_led(D13);
DigitalIn my_Dip2(D11);  //Dip 2
DigitalIn my_Dip1(D12);  //Dip 1
AnalogOut DP_Out(A3);

float NewSetPoint = 0;
int CheckSensor = 1;
unsigned long previousMillis = 0;        // will store last time LED was updated
long OnTime = 1000;                     // milliseconds of on-time
int secondscounter = 0;
int Counter = 0;
int sensorbroken =0;

int LHCT = PT + RT; // LH cycle time
int LHPT = PT + RT + PT; // LH purge time
int CT = PT + RT + PT + RT; // Cycle Time

float RHValue = 0;
float TempValue = 0;
float A = 0;
float DewPoint = 0;

int main()
{

    my_RHMV = 1;//0
    my_LHMV = 0;//1
    my_RHPV = 0;//1
    my_LHPV = 0;//1
    my_RHPV = 1;//0
    my_LHPV = 0;//1
    my_RV = 0;//1

    wd.Configure(4.0);

    wait_ms(100);

    lcd.printf("TegnonEfficiency\n");

    lcd.locate(0,1);
    if (ClimateControl == 1) {
        lcd.printf("Climate Control \n");
    } else {
        lcd.printf("   DP Control   \n");
    }

    wait_ms(1000);
    lcd.cls();
    lcd.printf("DP:");
    lcd.locate(9,0);
    lcd.printf("S:");
    lcd.locate(0,1);
    lcd.printf("RH:");
    lcd.locate(9,1);
    lcd.printf("T:");

    millisStart();

    while(1) {
        unsigned long currentMillis = millis(); // Get current time

        if(ClimateControl == 0) {
            if(my_Dip2 ==0) {
                if(my_Dip1 ==0) {
                    SetPoint = -3;
                }
                if(my_Dip1 ==1) {
                    SetPoint = -20;
                }
            }
            if(my_Dip2 ==1) {
                if(my_Dip1 ==0) {
                    SetPoint = -40;
                }
                if(my_Dip1 ==1) {
                    SetPoint = -50;
                }
            }
        }

        if ((currentMillis - previousMillis) >= OnTime) {
            previousMillis = currentMillis;
            wd.Service();
            my_led = !my_led;

            secondscounter = secondscounter + 1;
            Counter = Counter + 1;

            if(Counter == 10) {
                lcd.cls();
                lcd.printf("DP:");
                lcd.locate(9,0);
                lcd.printf("S:");
                lcd.locate(0,1);
                lcd.printf("RH:");
                lcd.locate(9,1);
                lcd.printf("T:");
                Counter = 0;
            }

            SENSOR.MRCommand();
            wait_ms(100);
            //SENSOR.DFCommand();
            
            CheckSensor = SENSOR.DFCommand();
            RHValue = (SENSOR.humidity);
            TempValue = (SENSOR.temperature);

            sensorbroken = 0;
            
            if(CheckSensor != 0){
            sensorbroken = 1;
            }  

            //if(RHValue < 0.01) {
            //    sensorbroken = 1;
            //}

            if(TempValue < -20) {
                sensorbroken = 1;
            }

            if(sensorbroken == 0) {
               RHValue = (SENSOR.humidity);
               TempValue = (SENSOR.temperature);
               
               if (RHValue != 0){
               
                A = log( RHValue * 0.01 * pow(10, 7.5*TempValue/(237.2+TempValue) )  );
                DewPoint = (23720 * A/(17.269-A))/100;
                }
                
                if (RHValue == 0){
                    DewPoint = -50;
                    }
                
                if(DewPoint > 20){
                    DewPoint = 20;
                    }
                    
                    if(DewPoint < -50){
                    DewPoint = -50;
                    }
            

                if (ClimateControl == 1) {
                    NewSetPoint = TempValue - DewPointSuppresion;

                    if ( NewSetPoint < SetPoint) {
                        NewSetPoint = SetPoint;
                    }

                } else {
                    NewSetPoint = SetPoint;
                }
                lcd.locate(3,0);
                lcd.printf("     ");
                lcd.locate(3,0);
                lcd.printf("%3.1f%", DewPoint);
                lcd.locate(11,0);
                lcd.printf("    ");
                lcd.locate(11,0);
                lcd.printf("%3.1f%", NewSetPoint);
                lcd.locate(3,1);
                lcd.printf("     ");
                lcd.locate(3,1);
                lcd.printf("%3.1f%", RHValue);
                lcd.locate(11,1);
                lcd.printf("     ");
                lcd.locate(11,1);
                lcd.printf("%.1f%", TempValue);
                
                DP_Out = 0.0104*DewPoint + 0.702; // For dewpoint -50 to 20 with output signal 0.6V to 3V
                //DP_Out = 0.0143*DewPoint + 0.714;
                
                
                if ((DewPoint <  NewSetPoint)  && (secondscounter == LHCT)) {
                    secondscounter = secondscounter - 1;
                }

                if ((DewPoint <  NewSetPoint)  && (secondscounter == CT)) {
                    secondscounter = secondscounter - 1;
                }

            } else {
                lcd.locate(0,0);
                lcd.printf("    Standard    ");
                lcd.locate(0,1);
                lcd.printf("     Cycle      ");
                DP_Out = 0.1;
            }
        }

        if (secondscounter < PT) {
            my_RHMV = 1;//0
            my_LHMV = 0;//1
            my_RHPV = 1;//0
            my_LHPV = 0;//1
            my_RV = 0;//1
        }
        if (secondscounter >= PT && secondscounter < LHCT) {
            my_RHMV = 1;//0
            my_LHMV = 0;//1
            my_RHPV = 0;//1
            my_LHPV = 0;//1
            my_RV = 1;//0

        }

        if ((secondscounter > LHCT) && (secondscounter < LHPT)) {
            my_RHMV = 0;//1
            my_LHMV = 1;//0
            my_RHPV = 0;//1
            my_LHPV = 1;//0
            my_RV = 0;//1

        }
        if (secondscounter >= LHPT && (secondscounter < CT)) {
            my_RHMV = 0;//1
            my_LHMV = 1;//0
            my_RHPV = 0;//1
            my_LHPV = 0;//1
            my_RV = 1;//0

        }

        if (secondscounter == (CT + 1)) {
            secondscounter = 0;
        }
    } // While(1)
} //Void Main
