#include "mbed.h"
#include "ESP8266Interface.h"
#include <MQTTClientMbedOs.h>
#include "Adafruit_SSD1331.h"
#include "Adafruit_GFX.h"
 
//Miten pistän kiinni
 
//sensori
//r = virta 5v
//b = ground
//w = D6
 
//wifi
//L432KC D5=PB6=UART1TX --- 3 RXD
//L432KC D4=PB7=UART1RX --- 4 TXD
//L432KC 3V3 --- 1 3.3V
//L432KC GND --- 2 GND
 
DigitalOut led1(LED1);
InterruptIn alarm(D6, PullUp);
Adafruit_SSD1331 OLED(D9, D8, D10, D11, NC, D13);
DigitalOut VCCEN(D3);
DigitalOut PMODEN(D5);
#define Black 0x0000
#define Blue 0x001F
#define Red 0xF800
#define Green 0x07E0
#define Cyan 0x07FF
#define Magenta 0xF81F
#define Yellow 0xFFE0
#define White 0xFFFF
 
 
int main() {
    
    //Tässtä led näyttö kun ohjelma käynnistyy
    OLED.begin();
    OLED.clearScreen();
    OLED.fillScreen(Black);
    OLED.setTextColor(White);
    OLED.setCursor(30,25);
    OLED.setTextSize(1);
    OLED.printf("Booting up");
    
    //Tästä alkaa wifi ja mqtt hörjöilyt
    ESP8266Interface esp(MBED_CONF_APP_ESP_TX_PIN, MBED_CONF_APP_ESP_RX_PIN);
    
    //Store device and broker IP 
    SocketAddress deviceIP;
    SocketAddress MQTTBroker;
    
    TCPSocket socket;
    MQTTClient client(&socket);
    
    printf("[ESP8266Interface.h] Connecting to network interface...");
    int ret = esp.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    
    if (ret != 0) {
        printf("\n[ESP8266Interface.h] Connection error!");
    } else {
        esp.get_ip_address(&deviceIP);
        printf("\n[ESP8266Interface.h] Connected to IP via DHCP: %s", deviceIP.get_ip_address());
    }
    
    esp.gethostbyname(MBED_CONF_APP_MQTT_BROKER_HOSTNAME, &MQTTBroker);
    MQTTBroker.set_port(MBED_CONF_APP_MQTT_BROKER_PORT);
 
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    char *id = MBED_CONF_APP_MQTT_ID;
    data.clientID.cstring = id;
    printf("\n[MQTTBroker] ID: %d", id); 
    
    int counter;
    counter = 0;
    
    char buffer[64];
    sprintf(buffer, "{\"Count\": \"%d\"}", counter);
    printf("\n[MQTTBroker] Buffer: %u", buffer);
 
    MQTT::Message msg;
    msg.qos = MQTT::QOS0;
    msg.retained = false;
    msg.dup = false;
    
 
    printf("Opening socket...");
    socket.open(&esp);
    printf("Opened!");
    socket.connect(MQTTBroker);
    printf("Opening to MQTT...");
    client.connect(data); 
    printf("Opened!");

    printf("\nReporting the following warnings:\n");
    MBED_WARNING1(MBED_ERROR_TIME_OUT, "Timeout error", 1);
    printf("   MBED_ERROR_TIME_OUT       Status: 0x%x Value: 0x%x\n", MBED_ERROR_TIME_OUT, 1);
    
    
    //Tässtä led näyttö alku
    
    OLED.clearScreen();
    OLED.fillScreen(Black);
    OLED.setTextColor(Red);
    OLED.setCursor(30,25);
    OLED.setTextSize(3);
    OLED.printf("%d", counter);
 
    //Tästä alkaa sensori sensuroinnit
    while(true) {
        if (alarm){
            counter++;
            printf("\nToimii! Jippii! '%d' \r\n", counter);
            OLED.fillScreen(Black);
            OLED.setCursor(30,25);
            OLED.printf("%d", counter);
            sprintf(buffer, "{\"Count\": \"%d\"}", counter);
            msg.payload = (void*)buffer;
            msg.payloadlen = strlen(buffer);
            ThisThread::sleep_for(1000);
                
            //Tässä laite lähettää mqtt paketin
            client.publish(MBED_CONF_APP_MQTT_TOPIC, msg);
            //client.yield(100);
            //client.disconnect();
        }
    }
}