#include "mbed.h"
#include "InterruptIn.h"
#include "PulseWidthCounter.h"

PulseWidthCounter::PulseWidthCounter(PinName _interrupt,bool positive=true) : interrupt(_interrupt)     //constructa  
{
    if ( positive ) 
    {   interrupt.rise(this,&PulseWidthCounter::start);
        interrupt.fall(this,&PulseWidthCounter::stop);
    }
    else
    {   interrupt.fall(this,&PulseWidthCounter::start);
        interrupt.rise(this,&PulseWidthCounter::stop);
    }
}

void PulseWidthCounter::start()
{
    _time.reset();
    _time.start();
}

void PulseWidthCounter::stop()
{
    _time.stop();
    count = _time.read_us();
}
