#include "mbed.h"
#include "Limiter.h"

Limiter::Limiter(float RATE)
{
    _rate = RATE;
    _lastval = 0.0;
}

void Limiter::setup(float _cutoffreq,float _interval)
{
    _period = 1 / _cutoffreq;
    _rate = _period / ( _period + _interval );
    _lastval = 0.0;
}

float Limiter::calc(float _now)
{
    _lastval = _rate * _lastval + ( 1 - _rate ) * _now;
    return _lastval;
}
;
