#ifndef CONFIG_H
#define CONFIG_H

//#define SERIAL_LCD
//#define SOFT_PWM
//#define LPCXpresso
//#define LocalFileOut

#define TX_TYPE 0               // 0:FM 1:IR
#define Thro_Zero 30
#define Thro_Lo 75
#define Thro_Hi 950
#define Pulse_Min 1000
#define Pulse_Max 2000
#define Stick_Limit 350
#define M1 M[0]
#define M2 M[1]
#define M3 M[2]
#define M4 M[3]
#define M5 M[4]
#define M6 M[5]
#define THR CH[0]
#define AIL CH[1]
#define ELE CH[2]
#define RUD CH[3]
#define AUX CH[4]
#define AX2 CH[5]
#define AX3 CH[6]
#define AX4 CH[7]
#define AX5 CH[8]
#define HEIGHT 3
#define _ITG3200  0x00
#define _L3GD20   0x01
#define TICK_TIME 0.05
#define GYRO_ADJUST 2
#define THR_MIDRANGE 80

enum PlaneType{Quad_X=0,Quad_VP,Quad_3D,Delta,Delta_TW,AirPlane};
enum JR{_THR=0,_AIL,_ELE,_RUD,_GYRO,_AUX1,_AUX2,_AUX3,_AUX4};       //JR 信号の順番
//enum Futaba{_AIL=0,_ELE,_THR,_RUD,_GYRO,_AUX1,_AUX2,_AUX3,_AUX4};       //Futaba 信号の順番
enum stknum{ROL=0,PIT,YAW,COL,GAIN,AUX2};       // Stick[]の順番
/*
struct pidinf {
    float kp;
    float ki;
    float kd;
    float limit;
    float integral_limit;
    float differential_limit;
};*/
struct config {
    float Revision;
    int Struct_Size;
    char StartMode;              //'c':config mode  'f':flight mode
    char Model_Type;             // 0x00:Quad-X  0x01:Quad-H-3D
    signed char Gyro_Gain_Setting;
    int Stick_Ref[6];            //Stick Neutral Position
    float Stick_Mix[3];               //Mixing ratio of stick operation
    signed char Gyro_Dir[4];
    float Gyro_Gain[6];
    signed char Servo_Dir[6];
    float Accel_Ref[3];
//    float Accel_Gain[3];
    float PID_Interval;
    float Cutoff_Freq;
    int Flight_Time;
    int LCD_Contrast;
    int PWM_Mode;
    int Throttl_Trim;
    int PWM_Interval; 
//    pidinf pid[4];
    float Active_Gyro_Gain;
//    float Gimbal_Gain;
//    int Gimbal_Neutral_Width;
//    int Gimbal_Dir;
    int Reverse_Point;
    float Thro_Limit_Val;
    float Thro_Limit_Rate;
public:
    config() {
        Revision = 1.01;
        Struct_Size = sizeof(config);
        Stick_Ref[0] = 1500;
        Stick_Ref[1] = 1500;
        Stick_Ref[2] = 1500;
        Stick_Ref[3] = 1080;
        Stick_Ref[4] = 1500;
        Stick_Ref[5] = 1500;
        Stick_Mix[0] = 0.4;
        Stick_Mix[1] = 0.4;
        Stick_Mix[2] = 0.65;
        Gyro_Dir[0] = -1;
        Gyro_Dir[1] = -1;
        Gyro_Dir[2] = 1;
        Gyro_Dir[3] = -1;
        Gyro_Gain[0] = 0.50;
        Gyro_Gain[1] = 0.50;
        Gyro_Gain[2] = 0.50;
        Gyro_Gain[3] = 0.00;
        Gyro_Gain[4] = 0.00;
        Gyro_Gain[5] = 0.00;
        Servo_Dir[0] = 1;
        Servo_Dir[1] = 1;
        Servo_Dir[2] = 1;
        Servo_Dir[3] = 1;
        Servo_Dir[4] = 1;
        Servo_Dir[5] = 1;
        Accel_Ref[0] = 0;
        Accel_Ref[1] = 0;
        Accel_Ref[2] = 0;
//        Accel_Gain[0] = 0.50;
//        Accel_Gain[1] = 0.50;
//        Accel_Gain[2] = 0.50;
        Model_Type = 0;
        Gyro_Gain_Setting = -1;
        Cutoff_Freq=0.15;
        Flight_Time=360;
        LCD_Contrast = 33;
        PWM_Mode = 1;
        Throttl_Trim = 0;
        PWM_Interval = 3000; 
        StartMode = 'C';
        PID_Interval = 0.004;
        Active_Gyro_Gain = 0.6; 
        Reverse_Point = 1500;
        Thro_Limit_Val = 100;
        Thro_Limit_Rate = 0.2;
    }
};
#endif





















































