#include "mbed.h"
#include "SerialLcd.h"
void wait(float);

SerialLcd::SerialLcd(PinName TX,PinName RX): _lcd(TX,RX)
{   
//    LCD_contrast = 60; 
}

int SerialLcd::write(const char* value) {
    size_t len = strlen(value);
    return _lcd.write(value,len);
}

int SerialLcd::_putc(int value) {
    const uint8_t buf = value;
    _lcd.write(&buf,1);
    return value;
}

int SerialLcd::_getc() {
    return -1;
}

void SerialLcd::cls()
{
    char buf[2];
    buf[0] = 0xFE;
    buf[1] = 0x01;
    _lcd.write(buf,2);
    wait(0.01);
}

void SerialLcd::locate(int clm,int row)
{
    char buf[2];
    buf[0] = 0xFE;
    buf[1] = 0x80 + (row * 0x40) + clm ;
    _lcd.write(buf,2);
    wait(0.01);
}
;
