#ifndef MBED_I2cPeripherals_H
#define MBED_I2cPeripherals_H

#include "mbed.h"
#include <iostream> 
#include "stdarg.h"

#define LPS331AP    // baro
#define L3GD20      // gyro
#define MPU6050     // gyro and accelameter 
#define ITG3200     // gyro
#define ACM1602     // I2C LCD
#define ST7032      // I2C LCD
#define ADXL345     // accelameter
#define GYRO_ADDR 0
#define ACCEL_ADDR 1
#define LCD_ADDR 3
#define BARO_ADDR 4
#define ULTRASONIC_ADDR 5
#define I2C_EEPROM_ADDR 0xA0

class I2cPeripherals
{
public:
    I2cPeripherals(PinName , PinName );
    
    void start(int contrast=60);
    int write_lcd(const char*);
    void write_reg(int,char,char*,int);
    void read_reg(int,char,char*,int);
    int write_EEPROM(short,char*,int);
    int read_EEPROM(short,char*,int);
    void cls();
    void locate(int,int);
    int GetAddr(int);
    int angular(float*,float*,float*);
    int Acceleration(float*,float*,float*);
    int pressure();
    int temperature();
    float height_cm();
    float height_mm();
    float height_us();
private:
//    virtual int _putc(int value);
//    virtual int _getc();
    void i2c_write(int,char*,int);
    void find();
    int ultrasonic(char);
    I2C _i2c;
    int LCD_addr;
    char LCD_cmd;
    char LCD_data;
    int Gyro_addr;
    char Gyro_data;
    int Accel_addr;
    char Accel_data;
    int barometor_addr;
    char barometor_data;
    int  ultrasonic_addr;
    char  ultrasonic_data;
    int ultrasonic_distance;
    int LCD_contrast;
    struct SensorInf    {
        char addr;
        char who;       //WHO_AMI
        char whoaddr;   //WHO_AMI resister address
    };
};
#endif